package org.immutables.vavr.examples;

import io.vavr.collection.CharSeq;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ExampleCharSeqType}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableExampleCharSeqType.builder()}.
 */
@SuppressWarnings({"all"})
@Generated(from = "ExampleCharSeqType", generator = "Immutables")
public final class ImmutableExampleCharSeqType implements ExampleCharSeqType {
  private final CharSeq text;

  private ImmutableExampleCharSeqType(CharSeq text) {
    this.text = text;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  private final class InitShim {
    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      return "Cannot build ExampleCharSeqType, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return Some data
   */
  @Override
  public CharSeq text() {
    return text;
  }

  public ImmutableExampleCharSeqType withText(CharSeq value) {
    CharSeq newValue = value;
    if (this.text == newValue) return this;
    return new ImmutableExampleCharSeqType(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableExampleCharSeqType} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableExampleCharSeqType
        && equalTo((ImmutableExampleCharSeqType) another);
  }

  private boolean equalTo(ImmutableExampleCharSeqType another) {
    return this.text().equals(another.text());
  }

  /**
   * Computes a hash code from attributes: {@code text}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + (text().hashCode());
    return h;
  }

  /**
   * Prints the immutable value {@code ExampleCharSeqType} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ExampleCharSeqType{"
        + "text=" + (text().toString())
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ExampleCharSeqType} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ExampleCharSeqType instance
   */
  public static ImmutableExampleCharSeqType copyOf(ExampleCharSeqType instance) {
    if (instance instanceof ImmutableExampleCharSeqType) {
      return (ImmutableExampleCharSeqType) instance;
    }
    return ImmutableExampleCharSeqType.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableExampleCharSeqType ImmutableExampleCharSeqType}.
   * @return A new ImmutableExampleCharSeqType builder
   */
  public static ImmutableExampleCharSeqType.Builder builder() {
    return new ImmutableExampleCharSeqType.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableExampleCharSeqType ImmutableExampleCharSeqType}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private CharSeq text_string = CharSeq.empty();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ExampleCharSeqType} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ExampleCharSeqType instance) {
      Objects.requireNonNull(instance, "instance");
      text(instance.text());
      return this;
    }

    public Builder addText(Character element) {
      this.text_string = this.text_string.append(element);
      return this;
    }

    public Builder addText(Character... elements) {
      this.text_string = this.text_string.appendAll(Arrays.asList(elements));
      return this;
    }

    public Builder addAllText(Iterable<Character> elements) {
      this.text_string = this.text_string.appendAll(elements);
      return this;
    }

    public Builder text(CharSeq elements) {
      this.text_string = elements;
      return this;
    }

    public Builder setIterableText(Iterable<Character> elements) {
      this.text_string = CharSeq.ofAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableExampleCharSeqType ImmutableExampleCharSeqType}.
     * @return An immutable instance of ExampleCharSeqType
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableExampleCharSeqType build() {
      return new ImmutableExampleCharSeqType(text_build());
    }

    private CharSeq text_build() {
      return this.text_string;
    }
  }
}
