package org.immutables.vavr.examples;

import io.vavr.collection.Array;
import io.vavr.collection.IndexedSeq;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ExampleIndexedSeqType}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableExampleIndexedSeqType.builder()}.
 */
@SuppressWarnings({"all"})
@Generated(from = "ExampleIndexedSeqType", generator = "Immutables")
public final class ImmutableExampleIndexedSeqType
    implements ExampleIndexedSeqType {
  private final IndexedSeq<Integer> integers;

  private ImmutableExampleIndexedSeqType(IndexedSeq<Integer> integers) {
    this.integers = integers;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  private final class InitShim {
    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      return "Cannot build ExampleIndexedSeqType, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return Some data
   */
  @Override
  public IndexedSeq<Integer> integers() {
    return integers;
  }

  public ImmutableExampleIndexedSeqType withIntegers(IndexedSeq<Integer> value) {
    IndexedSeq<Integer> newValue = value;
    if (this.integers == newValue) return this;
    return new ImmutableExampleIndexedSeqType(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableExampleIndexedSeqType} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableExampleIndexedSeqType
        && equalTo((ImmutableExampleIndexedSeqType) another);
  }

  private boolean equalTo(ImmutableExampleIndexedSeqType another) {
    return this.integers().equals(another.integers());
  }

  /**
   * Computes a hash code from attributes: {@code integers}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + (integers().hashCode());
    return h;
  }

  /**
   * Prints the immutable value {@code ExampleIndexedSeqType} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ExampleIndexedSeqType{"
        + "integers=" + (integers().toString())
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ExampleIndexedSeqType} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ExampleIndexedSeqType instance
   */
  public static ImmutableExampleIndexedSeqType copyOf(ExampleIndexedSeqType instance) {
    if (instance instanceof ImmutableExampleIndexedSeqType) {
      return (ImmutableExampleIndexedSeqType) instance;
    }
    return ImmutableExampleIndexedSeqType.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableExampleIndexedSeqType ImmutableExampleIndexedSeqType}.
   * @return A new ImmutableExampleIndexedSeqType builder
   */
  public static ImmutableExampleIndexedSeqType.Builder builder() {
    return new ImmutableExampleIndexedSeqType.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableExampleIndexedSeqType ImmutableExampleIndexedSeqType}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private IndexedSeq<Integer> integers_indexed_seq = Array.empty();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ExampleIndexedSeqType} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ExampleIndexedSeqType instance) {
      Objects.requireNonNull(instance, "instance");
      integers(instance.integers());
      return this;
    }

    public Builder addIntegers(Integer element) {
      this.integers_indexed_seq = this.integers_indexed_seq.append(element);
      return this;
    }

    @SafeVarargs
    public final Builder addIntegers(Integer... elements) {
      this.integers_indexed_seq = this.integers_indexed_seq.appendAll(Arrays.asList(elements));
      return this;
    }

    public Builder addAllIntegers(Iterable<Integer> element) {
      this.integers_indexed_seq = this.integers_indexed_seq.appendAll(element);
      return this;
    }

    public Builder integers(IndexedSeq<Integer> elements) {
      this.integers_indexed_seq = elements;
      return this;
    }

    public Builder setIterableIntegers(Iterable<Integer> elements) {
      this.integers_indexed_seq = Array.ofAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableExampleIndexedSeqType ImmutableExampleIndexedSeqType}.
     * @return An immutable instance of ExampleIndexedSeqType
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableExampleIndexedSeqType build() {
      return new ImmutableExampleIndexedSeqType(integers_build());
    }

    private IndexedSeq<Integer> integers_build() {
      return this.integers_indexed_seq;
    }
  }
}
