package org.immutables.vavr.examples;

import io.vavr.collection.LinearSeq;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ExampleLinearSeqType}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableExampleLinearSeqType.builder()}.
 */
@SuppressWarnings({"all"})
@Generated(from = "ExampleLinearSeqType", generator = "Immutables")
public final class ImmutableExampleLinearSeqType implements ExampleLinearSeqType {
  private final LinearSeq<Integer> integers;

  private ImmutableExampleLinearSeqType(LinearSeq<Integer> integers) {
    this.integers = integers;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  private final class InitShim {
    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      return "Cannot build ExampleLinearSeqType, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return Some data
   */
  @Override
  public LinearSeq<Integer> integers() {
    return integers;
  }

  public ImmutableExampleLinearSeqType withIntegers(LinearSeq<Integer> value) {
    LinearSeq<Integer> newValue = value;
    if (this.integers == newValue) return this;
    return new ImmutableExampleLinearSeqType(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableExampleLinearSeqType} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableExampleLinearSeqType
        && equalTo((ImmutableExampleLinearSeqType) another);
  }

  private boolean equalTo(ImmutableExampleLinearSeqType another) {
    return this.integers().equals(another.integers());
  }

  /**
   * Computes a hash code from attributes: {@code integers}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + (integers().hashCode());
    return h;
  }

  /**
   * Prints the immutable value {@code ExampleLinearSeqType} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ExampleLinearSeqType{"
        + "integers=" + (integers().toString())
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ExampleLinearSeqType} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ExampleLinearSeqType instance
   */
  public static ImmutableExampleLinearSeqType copyOf(ExampleLinearSeqType instance) {
    if (instance instanceof ImmutableExampleLinearSeqType) {
      return (ImmutableExampleLinearSeqType) instance;
    }
    return ImmutableExampleLinearSeqType.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableExampleLinearSeqType ImmutableExampleLinearSeqType}.
   * @return A new ImmutableExampleLinearSeqType builder
   */
  public static ImmutableExampleLinearSeqType.Builder builder() {
    return new ImmutableExampleLinearSeqType.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableExampleLinearSeqType ImmutableExampleLinearSeqType}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private LinearSeq<Integer> integers_linear_seq = io.vavr.collection.List.empty();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ExampleLinearSeqType} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ExampleLinearSeqType instance) {
      Objects.requireNonNull(instance, "instance");
      integers(instance.integers());
      return this;
    }

    public Builder addIntegers(Integer element) {
      this.integers_linear_seq = this.integers_linear_seq.append(element);
      return this;
    }

    @SafeVarargs
    public final Builder addIntegers(Integer... elements) {
      this.integers_linear_seq = this.integers_linear_seq.appendAll(Arrays.asList(elements));
      return this;
    }

    public Builder addAllIntegers(Iterable<Integer> element) {
      this.integers_linear_seq = this.integers_linear_seq.appendAll(element);
      return this;
    }

    public Builder integers(LinearSeq<Integer> elements) {
      this.integers_linear_seq = elements;
      return this;
    }

    public Builder setIterableIntegers(Iterable<Integer> elements) {
      this.integers_linear_seq = io.vavr.collection.List.ofAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableExampleLinearSeqType ImmutableExampleLinearSeqType}.
     * @return An immutable instance of ExampleLinearSeqType
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableExampleLinearSeqType build() {
      return new ImmutableExampleLinearSeqType(integers_build());
    }

    private LinearSeq<Integer> integers_build() {
      return this.integers_linear_seq;
    }
  }
}
