package org.immutables.vavr.examples;

import io.vavr.collection.LinkedHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ExampleLinkedHashSetType}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableExampleLinkedHashSetType.builder()}.
 */
@SuppressWarnings({"all"})
@Generated(from = "ExampleLinkedHashSetType", generator = "Immutables")
public final class ImmutableExampleLinkedHashSetType
    implements ExampleLinkedHashSetType {
  private final LinkedHashSet<Integer> integers;

  private ImmutableExampleLinkedHashSetType(LinkedHashSet<Integer> integers) {
    this.integers = integers;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  private final class InitShim {
    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      return "Cannot build ExampleLinkedHashSetType, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return Some data
   */
  @Override
  public LinkedHashSet<Integer> integers() {
    return integers;
  }

  public ImmutableExampleLinkedHashSetType withIntegers(LinkedHashSet<Integer> value) {
    LinkedHashSet<Integer> newValue = value;
    if (this.integers == newValue) return this;
    return new ImmutableExampleLinkedHashSetType(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableExampleLinkedHashSetType} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableExampleLinkedHashSetType
        && equalTo((ImmutableExampleLinkedHashSetType) another);
  }

  private boolean equalTo(ImmutableExampleLinkedHashSetType another) {
    return this.integers().equals(another.integers());
  }

  /**
   * Computes a hash code from attributes: {@code integers}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + (integers().hashCode());
    return h;
  }

  /**
   * Prints the immutable value {@code ExampleLinkedHashSetType} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ExampleLinkedHashSetType{"
        + "integers=" + (integers().toString())
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ExampleLinkedHashSetType} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ExampleLinkedHashSetType instance
   */
  public static ImmutableExampleLinkedHashSetType copyOf(ExampleLinkedHashSetType instance) {
    if (instance instanceof ImmutableExampleLinkedHashSetType) {
      return (ImmutableExampleLinkedHashSetType) instance;
    }
    return ImmutableExampleLinkedHashSetType.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableExampleLinkedHashSetType ImmutableExampleLinkedHashSetType}.
   * @return A new ImmutableExampleLinkedHashSetType builder
   */
  public static ImmutableExampleLinkedHashSetType.Builder builder() {
    return new ImmutableExampleLinkedHashSetType.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableExampleLinkedHashSetType ImmutableExampleLinkedHashSetType}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private LinkedHashSet<Integer> integers_set = LinkedHashSet.empty();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ExampleLinkedHashSetType} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ExampleLinkedHashSetType instance) {
      Objects.requireNonNull(instance, "instance");
      integers(instance.integers());
      return this;
    }

    public Builder addIntegers(Integer element) {
      this.integers_set = this.integers_set.add(element);
      return this;
    }

    @SafeVarargs
    public final Builder addIntegers(Integer... elements) {
      this.integers_set = this.integers_set.addAll(Arrays.asList(elements));
      return this;
    }

    public Builder addAllIntegers(Iterable<Integer> element) {
      this.integers_set = this.integers_set.addAll(element);
      return this;
    }

    public Builder integers(LinkedHashSet<Integer> elements) {
      this.integers_set = elements;
      return this;
    }

    public Builder setIterableIntegers(Iterable<Integer> elements) {
      this.integers_set = LinkedHashSet.ofAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableExampleLinkedHashSetType ImmutableExampleLinkedHashSetType}.
     * @return An immutable instance of ExampleLinkedHashSetType
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableExampleLinkedHashSetType build() {
      return new ImmutableExampleLinkedHashSetType(integers_build());
    }

    private LinkedHashSet<Integer> integers_build() {
      return this.integers_set;
    }
  }
}
