package org.immutables.vavr.examples;

import io.vavr.collection.List;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ExampleListType}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableExampleListType.builder()}.
 */
@SuppressWarnings({"all"})
@Generated(from = "ExampleListType", generator = "Immutables")
public final class ImmutableExampleListType implements ExampleListType {
  private final List<Integer> integers;

  private ImmutableExampleListType(List<Integer> integers) {
    this.integers = integers;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  private final class InitShim {
    private String formatInitCycleMessage() {
      java.util.List<String> attributes = new ArrayList<>();
      return "Cannot build ExampleListType, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return Some data
   */
  @Override
  public List<Integer> integers() {
    return integers;
  }

  public ImmutableExampleListType withIntegers(List<Integer> value) {
    List<Integer> newValue = value;
    if (this.integers == newValue) return this;
    return new ImmutableExampleListType(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableExampleListType} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableExampleListType
        && equalTo((ImmutableExampleListType) another);
  }

  private boolean equalTo(ImmutableExampleListType another) {
    return this.integers().equals(another.integers());
  }

  /**
   * Computes a hash code from attributes: {@code integers}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + (integers().hashCode());
    return h;
  }

  /**
   * Prints the immutable value {@code ExampleListType} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ExampleListType{"
        + "integers=" + (integers().toString())
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ExampleListType} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ExampleListType instance
   */
  public static ImmutableExampleListType copyOf(ExampleListType instance) {
    if (instance instanceof ImmutableExampleListType) {
      return (ImmutableExampleListType) instance;
    }
    return ImmutableExampleListType.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableExampleListType ImmutableExampleListType}.
   * @return A new ImmutableExampleListType builder
   */
  public static ImmutableExampleListType.Builder builder() {
    return new ImmutableExampleListType.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableExampleListType ImmutableExampleListType}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private List<Integer> integers_list = List.empty();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ExampleListType} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ExampleListType instance) {
      Objects.requireNonNull(instance, "instance");
      integers(instance.integers());
      return this;
    }

    public Builder addIntegers(Integer element) {
      this.integers_list = this.integers_list.append(element);
      return this;
    }

    @SafeVarargs
    public final Builder addIntegers(Integer... elements) {
      this.integers_list = this.integers_list.appendAll(Arrays.asList(elements));
      return this;
    }

    public Builder addAllIntegers(Iterable<Integer> element) {
      this.integers_list = this.integers_list.appendAll(element);
      return this;
    }

    public Builder integers(List<Integer> elements) {
      this.integers_list = elements;
      return this;
    }

    public Builder setIterableIntegers(Iterable<Integer> elements) {
      this.integers_list = List.ofAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableExampleListType ImmutableExampleListType}.
     * @return An immutable instance of ExampleListType
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableExampleListType build() {
      return new ImmutableExampleListType(integers_build());
    }

    private List<Integer> integers_build() {
      return this.integers_list;
    }
  }
}
