package org.immutables.vavr.examples;

import io.vavr.Tuple2;
import io.vavr.collection.HashMap;
import io.vavr.collection.Map;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ExampleMapType}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableExampleMapType.builder()}.
 */
@SuppressWarnings({"all"})
@Generated(from = "ExampleMapType", generator = "Immutables")
public final class ImmutableExampleMapType implements ExampleMapType {
  private final Map<String, Integer> integers;

  private ImmutableExampleMapType(Map<String, Integer> integers) {
    this.integers = integers;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  private final class InitShim {
    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      return "Cannot build ExampleMapType, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return Some data
   */
  @Override
  public Map<String, Integer> integers() {
    return integers;
  }

  public ImmutableExampleMapType withIntegers(Map<String, Integer> value) {
    Map<String, Integer> newValue = value;
    if (this.integers == newValue) return this;
    return new ImmutableExampleMapType(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableExampleMapType} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableExampleMapType
        && equalTo((ImmutableExampleMapType) another);
  }

  private boolean equalTo(ImmutableExampleMapType another) {
    return this.integers().equals(another.integers());
  }

  /**
   * Computes a hash code from attributes: {@code integers}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + (integers().hashCode());
    return h;
  }

  /**
   * Prints the immutable value {@code ExampleMapType} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ExampleMapType{"
        + "integers=" + (integers().toString())
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ExampleMapType} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ExampleMapType instance
   */
  public static ImmutableExampleMapType copyOf(ExampleMapType instance) {
    if (instance instanceof ImmutableExampleMapType) {
      return (ImmutableExampleMapType) instance;
    }
    return ImmutableExampleMapType.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableExampleMapType ImmutableExampleMapType}.
   * @return A new ImmutableExampleMapType builder
   */
  public static ImmutableExampleMapType.Builder builder() {
    return new ImmutableExampleMapType.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableExampleMapType ImmutableExampleMapType}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private Map<String, Integer> integers_map = HashMap.empty();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ExampleMapType} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ExampleMapType instance) {
      Objects.requireNonNull(instance, "instance");
      integers(instance.integers());
      return this;
    }

    public Builder putIntegers(String key, Integer value) {
      this.integers_map = this.integers_map.put(key, value);
      return this;
    }

    public Builder putEntryIntegers(Tuple2<String, Integer> entry) {
      this.integers_map = this.integers_map.put(entry);
      return this;
    }

    public Builder integers(Map<String, Integer> elements) {
      this.integers_map = elements;
      return this;
    }

    public Builder setJavaMapIntegers(java.util.Map<String, Integer> in_map) {
      this.integers_map = HashMap.ofAll(in_map);
      return this;
    }

    public Builder setEntriesIntegers(Iterable<Tuple2<String, Integer>> entries) {
      this.integers_map = HashMap.ofEntries(entries);
      return this;
    }

    /**
     * Builds a new {@link ImmutableExampleMapType ImmutableExampleMapType}.
     * @return An immutable instance of ExampleMapType
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableExampleMapType build() {
      return new ImmutableExampleMapType(integers_build());
    }

    private Map<String, Integer> integers_build() {
      return this.integers_map;
    }
  }
}
