package org.immutables.vavr.examples;

import io.vavr.Tuple2;
import io.vavr.collection.Array;
import io.vavr.collection.HashMap;
import io.vavr.collection.Map;
import io.vavr.control.Option;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ExampleMiscellaneousType}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableExampleMiscellaneousType.builder()}.
 */
@SuppressWarnings({"all"})
@Generated(from = "ExampleMiscellaneousType", generator = "Immutables")
public final class ImmutableExampleMiscellaneousType
    implements ExampleMiscellaneousType {
  private final Array<Integer> integers;
  private final Option<String> name;
  private final Map<String, Integer> table;

  private ImmutableExampleMiscellaneousType(
      Array<Integer> integers,
      Option<String> name,
      Map<String, Integer> table) {
    this.integers = integers;
    this.name = name;
    this.table = table;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  private final class InitShim {
    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      return "Cannot build ExampleMiscellaneousType, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return Some data
   */
  @Override
  public Array<Integer> integers() {
    return integers;
  }

  /**
   * @return An optional name
   */
  @Override
  public Option<String> name() {
    return name;
  }

  /**
   * @return A lookup table
   */
  @Override
  public Map<String, Integer> table() {
    return table;
  }

  public ImmutableExampleMiscellaneousType withIntegers(Array<Integer> value) {
    Array<Integer> newValue = value;
    if (this.integers == newValue) return this;
    return new ImmutableExampleMiscellaneousType(newValue, this.name, this.table);
  }

  public ImmutableExampleMiscellaneousType withName(Option<String> value) {
    Option<String> newValue = Objects.requireNonNull(value);
    if (this.name == newValue) return this;
    return new ImmutableExampleMiscellaneousType(this.integers, newValue, this.table);
  }

  public ImmutableExampleMiscellaneousType withName(String value) {
    Option<String> newValue = Option.some(Objects.requireNonNull(value));
    if (this.name == newValue) return this;
    return new ImmutableExampleMiscellaneousType(this.integers, newValue, this.table);
  }

  public ImmutableExampleMiscellaneousType withTable(Map<String, Integer> value) {
    Map<String, Integer> newValue = value;
    if (this.table == newValue) return this;
    return new ImmutableExampleMiscellaneousType(this.integers, this.name, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableExampleMiscellaneousType} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableExampleMiscellaneousType
        && equalTo((ImmutableExampleMiscellaneousType) another);
  }

  private boolean equalTo(ImmutableExampleMiscellaneousType another) {
    return this.integers().equals(another.integers())
        && this.name().equals(another.name())
        && this.table().equals(another.table());
  }

  /**
   * Computes a hash code from attributes: {@code integers}, {@code name}, {@code table}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + (integers().hashCode());
    h += (h << 5) + (name().hashCode());
    h += (h << 5) + (table().hashCode());
    return h;
  }

  /**
   * Prints the immutable value {@code ExampleMiscellaneousType} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ExampleMiscellaneousType{"
        + "integers=" + (integers().toString())
        + ", name=" + (name().toString())
        + ", table=" + (table().toString())
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ExampleMiscellaneousType} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ExampleMiscellaneousType instance
   */
  public static ImmutableExampleMiscellaneousType copyOf(ExampleMiscellaneousType instance) {
    if (instance instanceof ImmutableExampleMiscellaneousType) {
      return (ImmutableExampleMiscellaneousType) instance;
    }
    return ImmutableExampleMiscellaneousType.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableExampleMiscellaneousType ImmutableExampleMiscellaneousType}.
   * @return A new ImmutableExampleMiscellaneousType builder
   */
  public static ImmutableExampleMiscellaneousType.Builder builder() {
    return new ImmutableExampleMiscellaneousType.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableExampleMiscellaneousType ImmutableExampleMiscellaneousType}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private Array<Integer> integers_array = Array.empty();
    private Option<String> name_optional = Option.none();
    private Map<String, Integer> table_map = HashMap.empty();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ExampleMiscellaneousType} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ExampleMiscellaneousType instance) {
      Objects.requireNonNull(instance, "instance");
      integers(instance.integers());
      name(instance.name());
      table(instance.table());
      return this;
    }

    public Builder addIntegers(Integer element) {
      this.integers_array = this.integers_array.append(element);
      return this;
    }

    @SafeVarargs
    public final Builder addIntegers(Integer... elements) {
      this.integers_array = this.integers_array.appendAll(Arrays.asList(elements));
      return this;
    }

    public Builder addAllIntegers(Iterable<Integer> element) {
      this.integers_array = this.integers_array.appendAll(element);
      return this;
    }

    public Builder integers(Array<Integer> elements) {
      this.integers_array = elements;
      return this;
    }

    public Builder setIterableIntegers(Iterable<Integer> elements) {
      this.integers_array = Array.ofAll(elements);
      return this;
    }

    public Builder name(Option<String> opt) {
      this.name_optional = Objects.requireNonNull(opt);
      return this;
    }

    public Builder name(String x) {
      this.name_optional = Option.some(Objects.requireNonNull(x));
      return this;
    }

    public Builder unsetName() {
      this.name_optional = Option.none();
      return this;
    }

    public Builder putTable(String key, Integer value) {
      this.table_map = this.table_map.put(key, value);
      return this;
    }

    public Builder putEntryTable(Tuple2<String, Integer> entry) {
      this.table_map = this.table_map.put(entry);
      return this;
    }

    public Builder table(Map<String, Integer> elements) {
      this.table_map = elements;
      return this;
    }

    public Builder setJavaMapTable(java.util.Map<String, Integer> in_map) {
      this.table_map = HashMap.ofAll(in_map);
      return this;
    }

    public Builder setEntriesTable(Iterable<Tuple2<String, Integer>> entries) {
      this.table_map = HashMap.ofEntries(entries);
      return this;
    }

    /**
     * Builds a new {@link ImmutableExampleMiscellaneousType ImmutableExampleMiscellaneousType}.
     * @return An immutable instance of ExampleMiscellaneousType
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableExampleMiscellaneousType build() {
      return new ImmutableExampleMiscellaneousType(integers_build(), name_build(), table_build());
    }

    private Array<Integer> integers_build() {
      return this.integers_array;
    }

    private Option<String> name_build() {
      return this.name_optional;
    }

    private Map<String, Integer> table_build() {
      return this.table_map;
    }
  }
}
