package org.immutables.vavr.examples;

import io.vavr.Tuple2;
import io.vavr.collection.HashMap;
import io.vavr.collection.HashMultimap;
import io.vavr.collection.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ExampleMultimapType}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableExampleMultimapType.builder()}.
 */
@SuppressWarnings({"all"})
@Generated(from = "ExampleMultimapType", generator = "Immutables")
public final class ImmutableExampleMultimapType implements ExampleMultimapType {
  private final Multimap<String, Integer> integers;

  private ImmutableExampleMultimapType(Multimap<String, Integer> integers) {
    this.integers = integers;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  private final class InitShim {
    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      return "Cannot build ExampleMultimapType, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return Some data
   */
  @Override
  public Multimap<String, Integer> integers() {
    return integers;
  }

  public ImmutableExampleMultimapType withIntegers(Multimap<String, Integer> value) {
    Multimap<String, Integer> newValue = value;
    if (this.integers == newValue) return this;
    return new ImmutableExampleMultimapType(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableExampleMultimapType} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableExampleMultimapType
        && equalTo((ImmutableExampleMultimapType) another);
  }

  private boolean equalTo(ImmutableExampleMultimapType another) {
    return this.integers().equals(another.integers());
  }

  /**
   * Computes a hash code from attributes: {@code integers}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + (integers().hashCode());
    return h;
  }

  /**
   * Prints the immutable value {@code ExampleMultimapType} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ExampleMultimapType{"
        + "integers=" + (integers().toString())
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ExampleMultimapType} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ExampleMultimapType instance
   */
  public static ImmutableExampleMultimapType copyOf(ExampleMultimapType instance) {
    if (instance instanceof ImmutableExampleMultimapType) {
      return (ImmutableExampleMultimapType) instance;
    }
    return ImmutableExampleMultimapType.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableExampleMultimapType ImmutableExampleMultimapType}.
   * @return A new ImmutableExampleMultimapType builder
   */
  public static ImmutableExampleMultimapType.Builder builder() {
    return new ImmutableExampleMultimapType.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableExampleMultimapType ImmutableExampleMultimapType}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private Multimap<String, Integer> integers_map = HashMultimap.withSet().empty();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ExampleMultimapType} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ExampleMultimapType instance) {
      Objects.requireNonNull(instance, "instance");
      integers(instance.integers());
      return this;
    }

    public Builder putIntegers(String key, Integer value) {
      this.integers_map = this.integers_map.put(key, value);
      return this;
    }

    public Builder putEntryIntegers(Tuple2<String, Integer> entry) {
      this.integers_map = this.integers_map.put(entry);
      return this;
    }

    public Builder integers(Multimap<String, Integer> elements) {
      this.integers_map = elements;
      return this;
    }

    public Builder setJavaMultimapIntegers(Map<String, Integer> in_map) {
      this.integers_map = HashMultimap.withSet().ofEntries(HashMap.ofAll(in_map));
      return this;
    }

    public Builder setEntriesIntegers(Iterable<Tuple2<String, Integer>> entries) {
      this.integers_map = HashMultimap.withSet().ofEntries(entries);
      return this;
    }

    /**
     * Builds a new {@link ImmutableExampleMultimapType ImmutableExampleMultimapType}.
     * @return An immutable instance of ExampleMultimapType
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableExampleMultimapType build() {
      return new ImmutableExampleMultimapType(integers_build());
    }

    private Multimap<String, Integer> integers_build() {
      return this.integers_map;
    }
  }
}
