package org.immutables.vavr.examples;

import io.vavr.control.Option;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ExampleOptionType}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableExampleOptionType.builder()}.
 */
@SuppressWarnings({"all"})
@Generated(from = "ExampleOptionType", generator = "Immutables")
public final class ImmutableExampleOptionType implements ExampleOptionType {
  private final Option<Integer> optionalInteger;

  private ImmutableExampleOptionType(Option<Integer> optionalInteger) {
    this.optionalInteger = optionalInteger;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  private final class InitShim {
    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      return "Cannot build ExampleOptionType, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return Some data
   */
  @Override
  public Option<Integer> optionalInteger() {
    return optionalInteger;
  }

  public ImmutableExampleOptionType withOptionalInteger(Option<Integer> value) {
    Option<Integer> newValue = Objects.requireNonNull(value);
    if (this.optionalInteger == newValue) return this;
    return new ImmutableExampleOptionType(newValue);
  }

  public ImmutableExampleOptionType withOptionalInteger(Integer value) {
    Option<Integer> newValue = Option.some(Objects.requireNonNull(value));
    if (this.optionalInteger == newValue) return this;
    return new ImmutableExampleOptionType(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableExampleOptionType} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableExampleOptionType
        && equalTo((ImmutableExampleOptionType) another);
  }

  private boolean equalTo(ImmutableExampleOptionType another) {
    return this.optionalInteger().equals(another.optionalInteger());
  }

  /**
   * Computes a hash code from attributes: {@code optionalInteger}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + (optionalInteger().hashCode());
    return h;
  }

  /**
   * Prints the immutable value {@code ExampleOptionType} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ExampleOptionType{"
        + "optionalInteger=" + (optionalInteger().toString())
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ExampleOptionType} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ExampleOptionType instance
   */
  public static ImmutableExampleOptionType copyOf(ExampleOptionType instance) {
    if (instance instanceof ImmutableExampleOptionType) {
      return (ImmutableExampleOptionType) instance;
    }
    return ImmutableExampleOptionType.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableExampleOptionType ImmutableExampleOptionType}.
   * @return A new ImmutableExampleOptionType builder
   */
  public static ImmutableExampleOptionType.Builder builder() {
    return new ImmutableExampleOptionType.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableExampleOptionType ImmutableExampleOptionType}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private Option<Integer> optionalInteger_optional = Option.none();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ExampleOptionType} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ExampleOptionType instance) {
      Objects.requireNonNull(instance, "instance");
      optionalInteger(instance.optionalInteger());
      return this;
    }

    public Builder optionalInteger(Option<Integer> opt) {
      this.optionalInteger_optional = Objects.requireNonNull(opt);
      return this;
    }

    public Builder optionalInteger(Integer x) {
      this.optionalInteger_optional = Option.some(Objects.requireNonNull(x));
      return this;
    }

    public Builder unsetOptionalInteger() {
      this.optionalInteger_optional = Option.none();
      return this;
    }

    /**
     * Builds a new {@link ImmutableExampleOptionType ImmutableExampleOptionType}.
     * @return An immutable instance of ExampleOptionType
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableExampleOptionType build() {
      return new ImmutableExampleOptionType(optionalInteger_build());
    }

    private Option<Integer> optionalInteger_build() {
      return this.optionalInteger_optional;
    }
  }
}
