package org.immutables.vavr.examples;

import io.vavr.collection.Queue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ExampleQueueType}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableExampleQueueType.builder()}.
 */
@SuppressWarnings({"all"})
@Generated(from = "ExampleQueueType", generator = "Immutables")
public final class ImmutableExampleQueueType implements ExampleQueueType {
  private final Queue<Integer> integers;

  private ImmutableExampleQueueType(Queue<Integer> integers) {
    this.integers = integers;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  private final class InitShim {
    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      return "Cannot build ExampleQueueType, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return Some data
   */
  @Override
  public Queue<Integer> integers() {
    return integers;
  }

  public ImmutableExampleQueueType withIntegers(Queue<Integer> value) {
    Queue<Integer> newValue = value;
    if (this.integers == newValue) return this;
    return new ImmutableExampleQueueType(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableExampleQueueType} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableExampleQueueType
        && equalTo((ImmutableExampleQueueType) another);
  }

  private boolean equalTo(ImmutableExampleQueueType another) {
    return this.integers().equals(another.integers());
  }

  /**
   * Computes a hash code from attributes: {@code integers}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + (integers().hashCode());
    return h;
  }

  /**
   * Prints the immutable value {@code ExampleQueueType} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ExampleQueueType{"
        + "integers=" + (integers().toString())
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ExampleQueueType} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ExampleQueueType instance
   */
  public static ImmutableExampleQueueType copyOf(ExampleQueueType instance) {
    if (instance instanceof ImmutableExampleQueueType) {
      return (ImmutableExampleQueueType) instance;
    }
    return ImmutableExampleQueueType.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableExampleQueueType ImmutableExampleQueueType}.
   * @return A new ImmutableExampleQueueType builder
   */
  public static ImmutableExampleQueueType.Builder builder() {
    return new ImmutableExampleQueueType.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableExampleQueueType ImmutableExampleQueueType}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private Queue<Integer> integers_queue = Queue.empty();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ExampleQueueType} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ExampleQueueType instance) {
      Objects.requireNonNull(instance, "instance");
      integers(instance.integers());
      return this;
    }

    public Builder enqueueIntegers(Integer element) {
      this.integers_queue = this.integers_queue.enqueue(element);
      return this;
    }

    @SafeVarargs
    public final Builder enqueueIntegers(Integer... elements) {
      this.integers_queue = this.integers_queue.appendAll(Arrays.asList(elements));
      return this;
    }

    public Builder enqueueAllIntegers(Iterable<Integer> element) {
      this.integers_queue = this.integers_queue.enqueueAll(element);
      return this;
    }

    public Builder integers(Queue<Integer> elements) {
      this.integers_queue = elements;
      return this;
    }

    public Builder setIterableIntegers(Iterable<Integer> elements) {
      this.integers_queue = Queue.ofAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableExampleQueueType ImmutableExampleQueueType}.
     * @return An immutable instance of ExampleQueueType
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableExampleQueueType build() {
      return new ImmutableExampleQueueType(integers_build());
    }

    private Queue<Integer> integers_build() {
      return this.integers_queue;
    }
  }
}
