package org.immutables.vavr.examples;

import io.vavr.collection.HashSet;
import io.vavr.collection.Set;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ExampleSetType}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableExampleSetType.builder()}.
 */
@SuppressWarnings({"all"})
@Generated(from = "ExampleSetType", generator = "Immutables")
public final class ImmutableExampleSetType implements ExampleSetType {
  private final Set<Integer> integers;

  private ImmutableExampleSetType(Set<Integer> integers) {
    this.integers = integers;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  private final class InitShim {
    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      return "Cannot build ExampleSetType, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return Some data
   */
  @Override
  public Set<Integer> integers() {
    return integers;
  }

  public ImmutableExampleSetType withIntegers(Set<Integer> value) {
    Set<Integer> newValue = value;
    if (this.integers == newValue) return this;
    return new ImmutableExampleSetType(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableExampleSetType} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableExampleSetType
        && equalTo((ImmutableExampleSetType) another);
  }

  private boolean equalTo(ImmutableExampleSetType another) {
    return this.integers().equals(another.integers());
  }

  /**
   * Computes a hash code from attributes: {@code integers}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + (integers().hashCode());
    return h;
  }

  /**
   * Prints the immutable value {@code ExampleSetType} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ExampleSetType{"
        + "integers=" + (integers().toString())
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ExampleSetType} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ExampleSetType instance
   */
  public static ImmutableExampleSetType copyOf(ExampleSetType instance) {
    if (instance instanceof ImmutableExampleSetType) {
      return (ImmutableExampleSetType) instance;
    }
    return ImmutableExampleSetType.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableExampleSetType ImmutableExampleSetType}.
   * @return A new ImmutableExampleSetType builder
   */
  public static ImmutableExampleSetType.Builder builder() {
    return new ImmutableExampleSetType.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableExampleSetType ImmutableExampleSetType}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private Set<Integer> integers_set = HashSet.empty();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ExampleSetType} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ExampleSetType instance) {
      Objects.requireNonNull(instance, "instance");
      integers(instance.integers());
      return this;
    }

    public Builder addIntegers(Integer element) {
      this.integers_set = this.integers_set.add(element);
      return this;
    }

    @SafeVarargs
    public final Builder addIntegers(Integer... elements) {
      this.integers_set = this.integers_set.addAll(HashSet.of(elements));
      return this;
    }

    public Builder addAllIntegers(Iterable<Integer> element) {
      this.integers_set = this.integers_set.addAll(element);
      return this;
    }

    public Builder integers(Set<Integer> elements) {
      this.integers_set = elements;
      return this;
    }

    public Builder setIterableIntegers(Iterable<Integer> elements) {
      this.integers_set = HashSet.ofAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableExampleSetType ImmutableExampleSetType}.
     * @return An immutable instance of ExampleSetType
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableExampleSetType build() {
      return new ImmutableExampleSetType(integers_build());
    }

    private Set<Integer> integers_build() {
      return this.integers_set;
    }
  }
}
