package org.immutables.vavr.examples;

import io.vavr.collection.SortedSet;
import io.vavr.collection.TreeSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ExampleSortedSetType}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableExampleSortedSetType.builder()}.
 */
@SuppressWarnings({"all"})
@Generated(from = "ExampleSortedSetType", generator = "Immutables")
public final class ImmutableExampleSortedSetType implements ExampleSortedSetType {
  private final SortedSet<Integer> integers;

  private ImmutableExampleSortedSetType(SortedSet<Integer> integers) {
    this.integers = integers;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  private final class InitShim {
    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      return "Cannot build ExampleSortedSetType, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return Some data
   */
  @Override
  public SortedSet<Integer> integers() {
    return integers;
  }

  public ImmutableExampleSortedSetType withIntegers(SortedSet<Integer> value) {
    SortedSet<Integer> newValue = value;
    if (this.integers == newValue) return this;
    return new ImmutableExampleSortedSetType(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableExampleSortedSetType} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableExampleSortedSetType
        && equalTo((ImmutableExampleSortedSetType) another);
  }

  private boolean equalTo(ImmutableExampleSortedSetType another) {
    return this.integers().equals(another.integers());
  }

  /**
   * Computes a hash code from attributes: {@code integers}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + (integers().hashCode());
    return h;
  }

  /**
   * Prints the immutable value {@code ExampleSortedSetType} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ExampleSortedSetType{"
        + "integers=" + (integers().toString())
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ExampleSortedSetType} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ExampleSortedSetType instance
   */
  public static ImmutableExampleSortedSetType copyOf(ExampleSortedSetType instance) {
    if (instance instanceof ImmutableExampleSortedSetType) {
      return (ImmutableExampleSortedSetType) instance;
    }
    return ImmutableExampleSortedSetType.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableExampleSortedSetType ImmutableExampleSortedSetType}.
   * @return A new ImmutableExampleSortedSetType builder
   */
  public static ImmutableExampleSortedSetType.Builder builder() {
    return new ImmutableExampleSortedSetType.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableExampleSortedSetType ImmutableExampleSortedSetType}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private SortedSet<Integer> integers_set = TreeSet.empty();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ExampleSortedSetType} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ExampleSortedSetType instance) {
      Objects.requireNonNull(instance, "instance");
      integers(instance.integers());
      return this;
    }

    public Builder addIntegers(Integer element) {
      this.integers_set = this.integers_set.add(element);
      return this;
    }

    public Builder addAllIntegers(Iterable<Integer> element) {
      this.integers_set = this.integers_set.addAll(element);
      return this;
    }

    public Builder integers(SortedSet<Integer> elements) {
      this.integers_set = elements;
      return this;
    }

    public Builder setIterableIntegers(Iterable<Integer> elements) {
      this.integers_set = TreeSet.ofAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableExampleSortedSetType ImmutableExampleSortedSetType}.
     * @return An immutable instance of ExampleSortedSetType
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableExampleSortedSetType build() {
      return new ImmutableExampleSortedSetType(integers_build());
    }

    private SortedSet<Integer> integers_build() {
      return this.integers_set;
    }
  }
}
