package org.immutables.vavr.examples;

import io.vavr.Tuple2;
import io.vavr.collection.TreeMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ExampleTreeMapType}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableExampleTreeMapType.builder()}.
 */
@SuppressWarnings({"all"})
@Generated(from = "ExampleTreeMapType", generator = "Immutables")
public final class ImmutableExampleTreeMapType implements ExampleTreeMapType {
  private final TreeMap<String, Integer> integers;

  private ImmutableExampleTreeMapType(TreeMap<String, Integer> integers) {
    this.integers = integers;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  private final class InitShim {
    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      return "Cannot build ExampleTreeMapType, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return Some data
   */
  @Override
  public TreeMap<String, Integer> integers() {
    return integers;
  }

  public ImmutableExampleTreeMapType withIntegers(TreeMap<String, Integer> value) {
    TreeMap<String, Integer> newValue = value;
    if (this.integers == newValue) return this;
    return new ImmutableExampleTreeMapType(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableExampleTreeMapType} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableExampleTreeMapType
        && equalTo((ImmutableExampleTreeMapType) another);
  }

  private boolean equalTo(ImmutableExampleTreeMapType another) {
    return this.integers().equals(another.integers());
  }

  /**
   * Computes a hash code from attributes: {@code integers}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + (integers().hashCode());
    return h;
  }

  /**
   * Prints the immutable value {@code ExampleTreeMapType} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ExampleTreeMapType{"
        + "integers=" + (integers().toString())
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ExampleTreeMapType} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ExampleTreeMapType instance
   */
  public static ImmutableExampleTreeMapType copyOf(ExampleTreeMapType instance) {
    if (instance instanceof ImmutableExampleTreeMapType) {
      return (ImmutableExampleTreeMapType) instance;
    }
    return ImmutableExampleTreeMapType.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableExampleTreeMapType ImmutableExampleTreeMapType}.
   * @return A new ImmutableExampleTreeMapType builder
   */
  public static ImmutableExampleTreeMapType.Builder builder() {
    return new ImmutableExampleTreeMapType.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableExampleTreeMapType ImmutableExampleTreeMapType}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private TreeMap<String, Integer> integers_map = TreeMap.empty();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ExampleTreeMapType} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ExampleTreeMapType instance) {
      Objects.requireNonNull(instance, "instance");
      integers(instance.integers());
      return this;
    }

    public Builder putIntegers(String key, Integer value) {
      this.integers_map = this.integers_map.put(key, value);
      return this;
    }

    public Builder putEntryIntegers(Tuple2<String, Integer> entry) {
      this.integers_map = this.integers_map.put(entry);
      return this;
    }

    public Builder integers(TreeMap<String, Integer> elements) {
      this.integers_map = elements;
      return this;
    }

    public Builder setJavaMapIntegers(Map<String, Integer> in_map) {
      this.integers_map = TreeMap.ofAll(in_map);
      return this;
    }

    public Builder setMapIntegers(io.vavr.collection.Map<String, Integer> in_map) {
      this.integers_map = TreeMap.ofEntries(in_map.map(x -> x));
      return this;
    }

    public Builder setEntriesIntegers(Iterable<Tuple2<String, Integer>> entries) {
      this.integers_map = TreeMap.ofEntries(entries);
      return this;
    }

    /**
     * Builds a new {@link ImmutableExampleTreeMapType ImmutableExampleTreeMapType}.
     * @return An immutable instance of ExampleTreeMapType
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableExampleTreeMapType build() {
      return new ImmutableExampleTreeMapType(integers_build());
    }

    private TreeMap<String, Integer> integers_build() {
      return this.integers_map;
    }
  }
}
