package org.immutables.vavr.examples;

import io.vavr.collection.HashSet;
import io.vavr.collection.TreeSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ExampleTreeSetType}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableExampleTreeSetType.builder()}.
 */
@SuppressWarnings({"all"})
@Generated(from = "ExampleTreeSetType", generator = "Immutables")
public final class ImmutableExampleTreeSetType implements ExampleTreeSetType {
  private final TreeSet<Integer> integers;

  private ImmutableExampleTreeSetType(TreeSet<Integer> integers) {
    this.integers = integers;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  private final class InitShim {
    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      return "Cannot build ExampleTreeSetType, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return Some data
   */
  @Override
  public TreeSet<Integer> integers() {
    return integers;
  }

  public ImmutableExampleTreeSetType withIntegers(TreeSet<Integer> value) {
    TreeSet<Integer> newValue = value;
    if (this.integers == newValue) return this;
    return new ImmutableExampleTreeSetType(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableExampleTreeSetType} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableExampleTreeSetType
        && equalTo((ImmutableExampleTreeSetType) another);
  }

  private boolean equalTo(ImmutableExampleTreeSetType another) {
    return this.integers().equals(another.integers());
  }

  /**
   * Computes a hash code from attributes: {@code integers}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + (integers().hashCode());
    return h;
  }

  /**
   * Prints the immutable value {@code ExampleTreeSetType} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ExampleTreeSetType{"
        + "integers=" + (integers().toString())
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ExampleTreeSetType} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ExampleTreeSetType instance
   */
  public static ImmutableExampleTreeSetType copyOf(ExampleTreeSetType instance) {
    if (instance instanceof ImmutableExampleTreeSetType) {
      return (ImmutableExampleTreeSetType) instance;
    }
    return ImmutableExampleTreeSetType.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableExampleTreeSetType ImmutableExampleTreeSetType}.
   * @return A new ImmutableExampleTreeSetType builder
   */
  public static ImmutableExampleTreeSetType.Builder builder() {
    return new ImmutableExampleTreeSetType.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableExampleTreeSetType ImmutableExampleTreeSetType}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private TreeSet<Integer> integers_set = TreeSet.empty();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ExampleTreeSetType} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ExampleTreeSetType instance) {
      Objects.requireNonNull(instance, "instance");
      integers(instance.integers());
      return this;
    }

    public Builder addIntegers(Integer element) {
      this.integers_set = this.integers_set.add(element);
      return this;
    }

    @SafeVarargs
    public final Builder addIntegers(Integer... elements) {
      this.integers_set = this.integers_set.addAll(HashSet.of(elements));
      return this;
    }

    public Builder addAllIntegers(Iterable<Integer> element) {
      this.integers_set = this.integers_set.addAll(element);
      return this;
    }

    public Builder integers(TreeSet<Integer> elements) {
      this.integers_set = elements;
      return this;
    }

    public Builder setIterableIntegers(Iterable<Integer> elements) {
      this.integers_set = TreeSet.ofAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableExampleTreeSetType ImmutableExampleTreeSetType}.
     * @return An immutable instance of ExampleTreeSetType
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableExampleTreeSetType build() {
      return new ImmutableExampleTreeSetType(integers_build());
    }

    private TreeSet<Integer> integers_build() {
      return this.integers_set;
    }
  }
}
