package org.immutables.vavr.examples;

import io.vavr.collection.Vector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ExampleVectorType}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableExampleVectorType.builder()}.
 */
@SuppressWarnings({"all"})
@Generated(from = "ExampleVectorType", generator = "Immutables")
public final class ImmutableExampleVectorType implements ExampleVectorType {
  private final Vector<Integer> integers;

  private ImmutableExampleVectorType(Vector<Integer> integers) {
    this.integers = integers;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  private final class InitShim {
    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      return "Cannot build ExampleVectorType, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return Some data
   */
  @Override
  public Vector<Integer> integers() {
    return integers;
  }

  public ImmutableExampleVectorType withIntegers(Vector<Integer> value) {
    Vector<Integer> newValue = value;
    if (this.integers == newValue) return this;
    return new ImmutableExampleVectorType(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableExampleVectorType} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableExampleVectorType
        && equalTo((ImmutableExampleVectorType) another);
  }

  private boolean equalTo(ImmutableExampleVectorType another) {
    return this.integers().equals(another.integers());
  }

  /**
   * Computes a hash code from attributes: {@code integers}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + (integers().hashCode());
    return h;
  }

  /**
   * Prints the immutable value {@code ExampleVectorType} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ExampleVectorType{"
        + "integers=" + (integers().toString())
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ExampleVectorType} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ExampleVectorType instance
   */
  public static ImmutableExampleVectorType copyOf(ExampleVectorType instance) {
    if (instance instanceof ImmutableExampleVectorType) {
      return (ImmutableExampleVectorType) instance;
    }
    return ImmutableExampleVectorType.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableExampleVectorType ImmutableExampleVectorType}.
   * @return A new ImmutableExampleVectorType builder
   */
  public static ImmutableExampleVectorType.Builder builder() {
    return new ImmutableExampleVectorType.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableExampleVectorType ImmutableExampleVectorType}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private Vector<Integer> integers_vector = Vector.empty();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ExampleVectorType} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ExampleVectorType instance) {
      Objects.requireNonNull(instance, "instance");
      integers(instance.integers());
      return this;
    }

    public Builder addIntegers(Integer element) {
      this.integers_vector = this.integers_vector.append(element);
      return this;
    }

    @SafeVarargs
    public final Builder addIntegers(Integer... elements) {
      this.integers_vector = this.integers_vector.appendAll(Arrays.asList(elements));
      return this;
    }

    public Builder addAllIntegers(Iterable<Integer> element) {
      this.integers_vector = this.integers_vector.appendAll(element);
      return this;
    }

    public Builder integers(Vector<Integer> elements) {
      this.integers_vector = elements;
      return this;
    }

    public Builder setIterableIntegers(Iterable<Integer> elements) {
      this.integers_vector = Vector.ofAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableExampleVectorType ImmutableExampleVectorType}.
     * @return An immutable instance of ExampleVectorType
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableExampleVectorType build() {
      return new ImmutableExampleVectorType(integers_build());
    }

    private Vector<Integer> integers_build() {
      return this.integers_vector;
    }
  }
}
