/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api;

import java.time.Duration;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.infinispan.api.DemoEnumFlag;
import org.infinispan.api.DemoEnumFlags;
import org.infinispan.api.Infinispan;
import org.infinispan.api.common.CacheEntry;
import org.infinispan.api.common.CacheOptions;
import org.infinispan.api.common.CacheWriteOptions;
import org.infinispan.api.common.Flags;
import org.infinispan.api.common.events.cache.CacheEntryEvent;
import org.infinispan.api.common.process.CacheProcessorOptions;
import org.infinispan.api.sync.SyncCache;
import org.infinispan.api.sync.SyncContainer;
import org.infinispan.api.sync.events.cache.SyncCacheEntryCreatedListener;
import org.infinispan.api.sync.events.cache.SyncCacheEntryListener;
import org.infinispan.api.sync.events.cache.SyncCacheEntryRemovedListener;
import org.infinispan.api.sync.events.cache.SyncCacheEntryUpdatedListener;

public class SyncCacheAPIDemo {
    public void demo() {
        try (SyncContainer infinispan = Infinispan.create((String)"file:///path/to/infinispan.xml").sync();){
            SyncCache mycache = infinispan.caches().get("mycache");
            mycache.set((Object)"key", (Object)"value");
            String value = (String)mycache.get((Object)"key");
            CacheEntry previous = mycache.put((Object)"key", (Object)"newvalue");
            mycache.set((Object)"key", (Object)"anothervalue", CacheWriteOptions.writeOptions().lifespan(Duration.ofHours(1L)).timeout(Duration.ofMillis(500L)).build());
            DemoEnumFlags flags = DemoEnumFlags.of(DemoEnumFlag.skipLoad());
            value = (String)mycache.get((Object)"key", CacheOptions.options().timeout(Duration.ofMillis(500L)).flags((Flags)flags.add(DemoEnumFlag.skipNotification())).build());
            CacheEntry entry = mycache.getEntry((Object)"key");
            mycache.setIfAbsent((Object)"anotherkey", (Object)"value");
            CacheEntry existing = mycache.putIfAbsent((Object)"anotherkey", (Object)"anothervalue");
            boolean removed = mycache.remove((Object)"anotherkey");
            mycache.query("age > :age").param("age", (Object)5).skip(5L).limit(10).find().results().forEach(new NullConsumer());
            mycache.query("delete from person where age > :age").param("age", (Object)80).skip(5L).limit(10).execute();
            mycache.query("age > :age").param("age", (Object)80).skip(5L).limit(10).process((e, ctx) -> {
                e.setValue((Object)((String)e.value()).toLowerCase());
                return null;
            });
            mycache.putAll(Map.of("key1", "value1", "key2", "value2"));
            Map all = mycache.getAll(Set.of("key1", "key2"));
            mycache.keys().forEach(new NullConsumer());
            mycache.entries().forEach(e -> System.out.printf("key=%s, value=%s%n", e.key(), e.value()));
            mycache.listen((SyncCacheEntryListener)((SyncCacheEntryCreatedListener)event -> {}));
            mycache.listen((SyncCacheEntryListener)new NullListener());
            mycache.process(Set.of("key1", "key2"), (e, ctx) -> {
                e.setValue((Object)((String)e.value()).toLowerCase());
                return null;
            }, CacheProcessorOptions.processorOptions().flags((Flags)DemoEnumFlags.of(DemoEnumFlag.skipLoad())).build());
            infinispan.sync().batch(sync -> {
                SyncCache c = sync.caches().get("mycache");
                c.set((Object)"k1", (Object)"v1");
                c.set((Object)"k2", (Object)"v2");
                return null;
            });
        }
    }

    public static class NullConsumer<T>
    implements Consumer<T> {
        @Override
        public void accept(T t) {
        }
    }

    public static class NullListener
    implements SyncCacheEntryUpdatedListener,
    SyncCacheEntryRemovedListener {
        public void onRemove(CacheEntryEvent event) {
        }

        public void onUpdate(CacheEntryEvent event) {
        }
    }
}

