/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.stringbased;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.processors.FlowableProcessor;
import io.reactivex.rxjava3.processors.UnicastProcessor;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.infinispan.commons.configuration.ConfiguredBy;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.StreamAwareMarshaller;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.Version;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.marshall.persistence.PersistenceMarshaller;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.PrivateMetadata;
import org.infinispan.persistence.jdbc.common.JdbcUtil;
import org.infinispan.persistence.jdbc.common.TableOperations;
import org.infinispan.persistence.jdbc.common.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.common.impl.BaseJdbcStore;
import org.infinispan.persistence.jdbc.common.logging.Log;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfiguration;
import org.infinispan.persistence.jdbc.impl.table.TableManager;
import org.infinispan.persistence.jdbc.impl.table.TableManagerFactory;
import org.infinispan.persistence.keymappers.Key2StringMapper;
import org.infinispan.persistence.keymappers.TwoWayKey2StringMapper;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.MarshallableEntryFactory;
import org.infinispan.persistence.spi.MarshalledValue;
import org.infinispan.persistence.spi.NonBlockingStore;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.logging.LogFactory;
import org.reactivestreams.Publisher;

@ConfiguredBy(value=JdbcStringBasedStoreConfiguration.class)
public class JdbcStringBasedStore<K, V>
extends BaseJdbcStore<K, V, JdbcStringBasedStoreConfiguration> {
    private static final Log log = (Log)LogFactory.getLog(JdbcStringBasedStore.class, Log.class);
    private JdbcStringBasedStoreConfiguration configuration;
    private Key2StringMapper key2StringMapper;
    private MarshallableEntryFactory<K, V> marshalledEntryFactory;
    private PersistenceMarshaller marshaller;
    private TimeService timeService;
    private KeyPartitioner keyPartitioner;
    private IntSet sizeSegments;

    public Set<NonBlockingStore.Characteristic> characteristics() {
        return EnumSet.of(NonBlockingStore.Characteristic.BULK_READ, NonBlockingStore.Characteristic.EXPIRATION, NonBlockingStore.Characteristic.SEGMENTABLE, NonBlockingStore.Characteristic.TRANSACTIONAL, NonBlockingStore.Characteristic.SHAREABLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TableOperations<K, V> createTableOperations(InitializationContext ctx, JdbcStringBasedStoreConfiguration configuration) {
        TableManager tableManager;
        block18: {
            this.configuration = (JdbcStringBasedStoreConfiguration)ctx.getConfiguration();
            this.marshalledEntryFactory = ctx.getMarshallableEntryFactory();
            this.marshaller = ctx.getPersistenceMarshaller();
            this.timeService = ctx.getTimeService();
            this.keyPartitioner = configuration.segmented() ? ctx.getKeyPartitioner() : null;
            int numSegments = ctx.getCache().getCacheConfiguration().clustering().hash().numSegments();
            if (configuration.shared()) {
                this.sizeSegments = IntSets.immutableRangeSet((int)numSegments);
            } else {
                this.sizeSegments = IntSets.concurrentSet((int)numSegments);
                this.sizeSegments.addAll(IntSets.immutableRangeSet((int)numSegments));
            }
            String cacheName = ctx.getCache().getName();
            tableManager = TableManagerFactory.getManager(ctx, this.connectionFactory, configuration, ctx.getCache().getName());
            tableManager.start();
            if (!configuration.table().createOnStart()) {
                Connection connection = null;
                try {
                    connection = this.connectionFactory.getConnection();
                    if (tableManager.metaTableExists(connection)) {
                        TableManager.Metadata meta = tableManager.getMetadata(connection);
                        if (meta != null) {
                            String versionStr;
                            List versionParts;
                            int storedSegments = meta.getSegments();
                            if (!(configuration.segmented() || (Integer)(versionParts = Arrays.stream((versionStr = Version.decodeVersion((short)meta.getVersion())).split("\\.")).map(Integer::parseInt).collect(Collectors.toList())).get(0) <= 12 && (Integer)versionParts.get(2) <= 4 || storedSegments == -1)) {
                                throw log.existingStoreNoSegmentation();
                            }
                            int configuredSegments = numSegments;
                            if (configuration.segmented() && storedSegments != configuredSegments) {
                                throw log.existingStoreSegmentMismatch(storedSegments, configuredSegments);
                            }
                        }
                        tableManager.updateMetaTable(connection);
                        break block18;
                    }
                    org.infinispan.util.logging.Log.PERSISTENCE.startMigratingPersistenceData(cacheName);
                    try {
                        this.migrateFromV11(ctx, tableManager);
                    }
                    catch (SQLException e) {
                        throw org.infinispan.util.logging.Log.PERSISTENCE.persistedDataMigrationFailed(cacheName, (Throwable)e);
                    }
                    tableManager.createMetaTable(connection);
                    org.infinispan.util.logging.Log.PERSISTENCE.persistedDataSuccessfulMigrated(cacheName);
                }
                finally {
                    this.connectionFactory.releaseConnection(connection);
                }
            }
        }
        try {
            Object mapper = Util.loadClassStrict((String)configuration.key2StringMapper(), (ClassLoader)ctx.getGlobalConfiguration().classLoader()).newInstance();
            if (mapper instanceof Key2StringMapper) {
                this.key2StringMapper = (Key2StringMapper)mapper;
            }
        }
        catch (Exception e) {
            log.errorf("Trying to instantiate %s, however it failed due to %s", (Object)configuration.key2StringMapper(), (Object)e.getClass().getName());
            throw new IllegalStateException("This should not happen.", e);
        }
        if (log.isTraceEnabled()) {
            log.tracef("Using key2StringMapper: %s", (Object)this.key2StringMapper.getClass().getName());
        }
        if (configuration.preload()) {
            this.enforceTwoWayMapper("preload");
        }
        if (ctx.getCache().getCacheConfiguration() != null && ctx.getCache().getCacheConfiguration().clustering().cacheMode().isDistributed()) {
            this.enforceTwoWayMapper("distribution/rehashing");
        }
        return tableManager;
    }

    public TableManager<K, V> getTableManager() {
        return (TableManager)this.tableOperations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateFromV11(InitializationContext ctx, TableManager<K, V> tableManager) throws SQLException {
        if (ctx.getGlobalConfiguration().serialization().marshaller() != null) {
            return;
        }
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.connectionFactory.getConnection();
            conn.setAutoCommit(false);
            String sql = tableManager.getLoadNonExpiredAllRowsSql();
            ps = conn.prepareStatement(sql);
            ps.setLong(1, this.timeService.wallClockTime());
            rs = ps.executeQuery();
            Marshaller userMarshaller = this.marshaller.getUserMarshaller();
            try (PreparedStatement upsertBatch = conn.prepareStatement(tableManager.getUpdateRowSql());){
                int batchSize = 0;
                while (rs.next()) {
                    Metadata meta;
                    ++batchSize;
                    InputStream inputStream = rs.getBinaryStream(1);
                    String keyStr = rs.getString(2);
                    long timestamp = rs.getLong(3);
                    int segment = this.keyPartitioner == null ? -1 : rs.getInt(4);
                    MarshalledValue mv = (MarshalledValue)JdbcUtil.unmarshall((InputStream)inputStream, (StreamAwareMarshaller)this.marshaller);
                    Object value = JdbcUtil.unmarshall((ByteBuffer)mv.getValueBytes(), (Marshaller)userMarshaller);
                    try {
                        meta = (Metadata)JdbcUtil.unmarshall((ByteBuffer)mv.getMetadataBytes(), (Marshaller)userMarshaller);
                    }
                    catch (IllegalArgumentException e) {
                        meta = (Metadata)JdbcUtil.unmarshall((ByteBuffer)mv.getMetadataBytes(), (Marshaller)this.marshaller);
                    }
                    PrivateMetadata internalMeta = (PrivateMetadata)JdbcUtil.unmarshall((ByteBuffer)mv.getInternalMetadataBytes(), (Marshaller)this.marshaller);
                    MarshallableEntry entry = this.marshalledEntryFactory.create(null, value, meta, internalMeta, mv.getCreated(), mv.getLastUsed());
                    ByteBuffer byteBuffer = JdbcUtil.marshall((Object)entry.getMarshalledValue(), (Marshaller)this.marshaller);
                    tableManager.prepareUpdateStatement(upsertBatch, keyStr, timestamp, segment, byteBuffer);
                    upsertBatch.addBatch();
                    if (batchSize != this.configuration.maxBatchSize()) continue;
                    batchSize = 0;
                    upsertBatch.executeBatch();
                    upsertBatch.clearBatch();
                }
                if (batchSize != 0) {
                    upsertBatch.executeBatch();
                }
                conn.commit();
            }
        }
        catch (Throwable throwable) {
            JdbcUtil.safeClose(rs);
            JdbcUtil.safeClose(ps);
            this.connectionFactory.releaseConnection(conn);
            throw throwable;
        }
        JdbcUtil.safeClose((ResultSet)rs);
        JdbcUtil.safeClose((Statement)ps);
        this.connectionFactory.releaseConnection(conn);
    }

    protected void extraStopSteps() {
        try {
            TableManager<K, V> tableManager = this.getTableManager();
            if (tableManager != null) {
                tableManager.stop();
                this.tableOperations = null;
            }
        }
        catch (Throwable t) {
            log.debug((Object)"Exception while stopping", t);
        }
    }

    public CompletionStage<Long> size(IntSet segments) {
        return super.size(segments).thenApply(totalSize -> {
            IntSet matchingSegments = IntSets.mutableCopyFrom((Set)segments);
            matchingSegments.retainAll(this.sizeSegments);
            int totalSegments = this.sizeSegments.size();
            return totalSize * (long)matchingSegments.size() / (long)totalSegments;
        });
    }

    public CompletionStage<Long> approximateSize(IntSet segments) {
        return this.size(segments);
    }

    public CompletionStage<Void> addSegments(IntSet segments) {
        this.sizeSegments.addAll(segments);
        return CompletableFutures.completedNull();
    }

    public CompletionStage<Void> removeSegments(IntSet segments) {
        this.sizeSegments.removeAll(segments);
        return CompletableFutures.completedNull();
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public Publisher<MarshallableEntry<K, V>> purgeExpired() {
        return Flowable.defer(() -> {
            UnicastProcessor unicastProcessor = UnicastProcessor.create();
            this.blockingManager.runBlocking(() -> {
                TableManager<K, V> tableManager = this.getTableManager();
                Connection conn = null;
                PreparedStatement ps = null;
                ResultSet rs = null;
                try {
                    ArrayList<PossibleExpirationNotification> list;
                    String sql = tableManager.getSelectOnlyExpiredRowsSql();
                    conn = this.connectionFactory.getConnection();
                    conn.setAutoCommit(false);
                    ps = conn.prepareStatement(sql);
                    ps.setLong(1, this.timeService.wallClockTime());
                    rs = ps.executeQuery();
                    int batchSize = this.configuration.maxBatchSize();
                    if (this.key2StringMapper instanceof TwoWayKey2StringMapper) {
                        list = new ArrayList<PossibleExpirationNotification>(batchSize);
                    } else {
                        list = null;
                        Log.PERSISTENCE.twoWayKey2StringMapperIsMissing(TwoWayKey2StringMapper.class.getSimpleName());
                    }
                    long purgedAmount = 0L;
                    try (PreparedStatement batchDelete = conn.prepareStatement(tableManager.getDeleteRowWithExpirationSql());){
                        long possibleAmount = 0L;
                        while (rs.next()) {
                            String keyStr = rs.getString(2);
                            batchDelete.setString(1, keyStr);
                            long expiryTime = rs.getLong(3);
                            batchDelete.setLong(2, expiryTime);
                            batchDelete.addBatch();
                            if (list != null) {
                                InputStream inputStream = rs.getBinaryStream(1);
                                MarshalledValue value = (MarshalledValue)JdbcUtil.unmarshall((InputStream)inputStream, (StreamAwareMarshaller)this.marshaller);
                                list.add(new PossibleExpirationNotification(keyStr, value));
                            }
                            if (++possibleAmount != (long)batchSize) continue;
                            purgedAmount += this.runBatchAndNotify((List<PossibleExpirationNotification>)list, batchDelete, (FlowableProcessor<MarshallableEntry<K, V>>)unicastProcessor);
                            possibleAmount = 0L;
                        }
                        if (list == null || !list.isEmpty()) {
                            purgedAmount += this.runBatchAndNotify((List<PossibleExpirationNotification>)list, batchDelete, (FlowableProcessor<MarshallableEntry<K, V>>)unicastProcessor);
                        }
                        if (log.isTraceEnabled()) {
                            log.tracef("Successfully purged %d rows.", purgedAmount);
                        }
                        conn.commit();
                        unicastProcessor.onComplete();
                    }
                }
                catch (SQLException e) {
                    try {
                        log.failedClearingJdbcCacheStore((Exception)e);
                        try {
                            conn.rollback();
                        }
                        catch (SQLException ex) {
                            log.sqlFailureTxRollback(ex);
                        }
                        unicastProcessor.onError((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        JdbcUtil.safeClose(rs);
                        JdbcUtil.safeClose(ps);
                        this.connectionFactory.releaseConnection(conn);
                        throw throwable;
                    }
                    JdbcUtil.safeClose(rs);
                    JdbcUtil.safeClose((Statement)ps);
                    this.connectionFactory.releaseConnection(conn);
                }
                JdbcUtil.safeClose((ResultSet)rs);
                JdbcUtil.safeClose((Statement)ps);
                this.connectionFactory.releaseConnection(conn);
            }, (Object)"jdbcstringstore-purge");
            return unicastProcessor;
        });
    }

    private long runBatchAndNotify(List<PossibleExpirationNotification> possible, PreparedStatement batchDelete, FlowableProcessor<MarshallableEntry<K, V>> flowable) throws SQLException {
        long purgeAmount = 0L;
        int[] results = batchDelete.executeBatch();
        if (possible != null) {
            for (int i = 0; i < results.length; ++i) {
                PossibleExpirationNotification notification = possible.get(i);
                if (results[i] != -3) {
                    Object key = ((TwoWayKey2StringMapper)this.key2StringMapper).getKeyMapping(notification.key);
                    flowable.onNext((Object)this.marshalledEntryFactory.create(key, notification.is));
                    ++purgeAmount;
                    continue;
                }
                log.tracef("Unable to remove expired entry for key %s, most likely concurrent update", (Object)notification.key);
            }
            possible.clear();
        } else {
            purgeAmount += (long)results.length;
        }
        return purgeAmount;
    }

    private void enforceTwoWayMapper(String where) throws PersistenceException {
        if (!(this.key2StringMapper instanceof TwoWayKey2StringMapper)) {
            Log.PERSISTENCE.invalidKey2StringMapper(where, this.key2StringMapper.getClass().getName());
            throw new PersistenceException(String.format("Invalid key to string mapper : %s", this.key2StringMapper.getClass().getName()));
        }
    }

    class PossibleExpirationNotification {
        private final String key;
        private final MarshalledValue is;

        PossibleExpirationNotification(String key, MarshalledValue is) {
            this.key = key;
            this.is = is;
        }
    }
}

