/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cdi.embedded.test.cache.specific;

import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.infinispan.Cache;
import org.infinispan.cdi.embedded.InfinispanExtensionEmbedded;
import org.infinispan.cdi.embedded.test.DefaultTestEmbeddedCacheManagerProducer;
import org.infinispan.cdi.embedded.test.cache.specific.Large;
import org.infinispan.cdi.embedded.test.cache.specific.Small;
import org.infinispan.cdi.embedded.test.testutil.Deployments;
import org.infinispan.eviction.EvictionStrategy;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="cdi.test.cache.embedded.specific.SpecificCacheManagerTest")
public class SpecificCacheManagerTest
extends Arquillian {
    @Inject
    private Cache<?, ?> cache;
    @Inject
    @Large
    private Cache<?, ?> largeCache;
    @Inject
    @Small
    private Cache<?, ?> smallCache;
    @Inject
    private InfinispanExtensionEmbedded infinispanExtension;
    @Inject
    private BeanManager beanManager;

    @Deployment
    public static Archive<?> deployment() {
        return ((WebArchive)Deployments.baseDeployment().addPackage(SpecificCacheManagerTest.class.getPackage())).addClass(DefaultTestEmbeddedCacheManagerProducer.class);
    }

    public void testCorrectCacheManagersRegistered() {
        Assert.assertEquals((int)this.infinispanExtension.getInstalledEmbeddedCacheManagers(this.beanManager).size(), (int)2);
    }

    public void testSpecificCacheManager() throws Exception {
        Assert.assertEquals((long)this.largeCache.getCacheConfiguration().eviction().maxEntries(), (long)2000L);
        Assert.assertEquals((Object)this.largeCache.getCacheConfiguration().eviction().strategy(), (Object)EvictionStrategy.LIRS);
        Assert.assertEquals((long)this.largeCache.getCacheManager().getDefaultCacheConfiguration().eviction().maxEntries(), (long)4000L);
        Assert.assertEquals((Object)this.largeCache.getCacheManager().getDefaultCacheConfiguration().eviction().strategy(), (Object)EvictionStrategy.LIRS);
        Assert.assertEquals((long)this.smallCache.getCacheConfiguration().eviction().maxEntries(), (long)20L);
        Assert.assertEquals((Object)this.smallCache.getCacheConfiguration().eviction().strategy(), (Object)EvictionStrategy.LIRS);
        Assert.assertEquals((long)this.smallCache.getCacheManager().getDefaultCacheConfiguration().eviction().maxEntries(), (long)4000L);
        Assert.assertEquals((Object)this.smallCache.getCacheManager().getDefaultCacheConfiguration().eviction().strategy(), (Object)EvictionStrategy.LIRS);
        AssertJUnit.assertTrue((boolean)this.smallCache.getCacheManager().equals(this.largeCache.getCacheManager()));
        AssertJUnit.assertFalse((boolean)this.smallCache.getCacheManager().equals(this.cache.getCacheManager()));
        Assert.assertEquals((Object)this.cache.getCacheConfiguration().eviction().strategy(), (Object)EvictionStrategy.NONE);
        Assert.assertEquals((long)this.cache.getCacheConfiguration().eviction().maxEntries(), (long)-1L);
        Assert.assertEquals((Object)this.cache.getCacheManager().getDefaultCacheConfiguration().eviction().strategy(), (Object)EvictionStrategy.NONE);
    }
}

