/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cdi.embedded.test.cachemanager.programmatic;

import javax.inject.Inject;
import javax.inject.Named;
import org.infinispan.AdvancedCache;
import org.infinispan.cdi.embedded.test.cachemanager.programmatic.Small;
import org.infinispan.cdi.embedded.test.cachemanager.programmatic.SmallCacheObservers;
import org.infinispan.cdi.embedded.test.testutil.Deployments;
import org.infinispan.test.fwk.TestResourceTrackingListener;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.testng.Assert;
import org.testng.annotations.Listeners;
import org.testng.annotations.Test;

@Listeners(value={TestResourceTrackingListener.class})
@Test(groups={"functional"}, testName="cdi.test.cachemanager.embedded.programmatic.ProgrammaticCacheContainerTest")
public class ProgrammaticCacheContainerTest
extends Arquillian {
    @Inject
    @Small
    private AdvancedCache<?, ?> smallCache;
    @Inject
    @Named(value="large")
    private AdvancedCache<?, ?> largeCache;
    @Inject
    @Named(value="super-large")
    private AdvancedCache<?, ?> superLargeCache;
    @Inject
    private SmallCacheObservers observers;

    @Deployment
    public static Archive<?> deployment() {
        return Deployments.baseDeployment().addPackage(ProgrammaticCacheContainerTest.class.getPackage());
    }

    public void testSmallCache() {
        Assert.assertEquals((long)this.smallCache.getCacheConfiguration().eviction().maxEntries(), (long)7L);
        Assert.assertEquals((int)this.observers.getCacheStartedEventCount(), (int)1);
    }

    public void testLargeCache() {
        Assert.assertEquals((long)this.largeCache.getCacheConfiguration().memory().size(), (long)10L);
    }

    public void testSuperLargeCache() {
        Assert.assertEquals((long)this.superLargeCache.getCacheConfiguration().memory().size(), (long)20L);
    }
}

