/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cdi.embedded.test.distexec;

import java.io.Serializable;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.infinispan.Cache;
import org.infinispan.cdi.embedded.Input;
import org.infinispan.cdi.embedded.test.DefaultTestEmbeddedCacheManagerProducer;
import org.infinispan.cdi.embedded.test.distexec.MultipleCacheManagersArquillianTest;
import org.infinispan.cdi.embedded.test.testutil.Deployments;
import org.infinispan.distexec.DistributedExecutorTest;
import org.infinispan.marshall.core.ExternalPojo;
import org.infinispan.test.MultipleCacheManagersTest;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="cdi.test.distexec.DistributedExecutorCDITest")
public class DistributedExecutorCDITest
extends MultipleCacheManagersArquillianTest {
    DistributedExecutorTest delegate = new DistributedExecutorTest();

    @Override
    MultipleCacheManagersTest getDelegate() {
        return this.delegate;
    }

    @Deployment
    public static Archive<?> deployment() {
        return ((WebArchive)Deployments.baseDeployment().addClass(DistributedExecutorCDITest.class)).addClass(DefaultTestEmbeddedCacheManagerProducer.class);
    }

    public void testBasicInvocation() throws Exception {
        this.delegate.basicInvocation((Callable)new SimpleCallable());
    }

    public void testInvocationUsingImpliedInputCache() throws Exception {
        this.delegate.basicInvocation((Callable)new ImpliedInputCacheCallable());
    }

    public void testBasicInvocationRunnable() throws Exception {
        this.delegate.basicInvocation((Runnable)new SimpleRunnable());
    }

    public void testInvocationUsingImpliedInputCacheRunnable() throws Exception {
        this.delegate.basicInvocation((Runnable)new ImpliedInputCacheRunnable());
    }

    static class ImpliedInputCacheRunnable
    implements Runnable,
    Serializable,
    ExternalPojo {
        private static final long serialVersionUID = 5770069398989111268L;
        @Input
        @Inject
        private Cache<String, String> cache;

        ImpliedInputCacheRunnable() {
        }

        @Override
        public void run() {
            Assert.assertNotNull(this.cache, (String)("Cache not injected into " + this));
            Assert.assertTrue((boolean)this.cache.getName().equals("DistributedExecutorTest-DIST_SYNC"));
        }
    }

    static class ImpliedInputCacheCallable
    implements Callable<Integer>,
    Serializable,
    ExternalPojo {
        private static final long serialVersionUID = 5770069398989111268L;
        @Input
        @Inject
        private Cache<String, String> cache;

        ImpliedInputCacheCallable() {
        }

        @Override
        public Integer call() throws Exception {
            Assert.assertNotNull(this.cache, (String)("Cache not injected into " + this));
            Assert.assertTrue((boolean)this.cache.getName().equals("DistributedExecutorTest-DIST_SYNC"));
            return 1;
        }
    }

    static class SimpleRunnable
    implements Runnable,
    Serializable,
    ExternalPojo {
        private static final long serialVersionUID = -8589149500259272402L;
        @Inject
        private Cache<String, String> cache;

        SimpleRunnable() {
        }

        @Override
        public void run() {
            Assert.assertNotNull(this.cache, (String)("Cache not injected into " + this));
        }
    }

    static class SimpleCallable
    implements Callable<Integer>,
    Serializable,
    ExternalPojo {
        private static final long serialVersionUID = -8589149500259272402L;
        @Inject
        private Cache<String, String> cache;

        SimpleCallable() {
        }

        @Override
        public Integer call() throws Exception {
            Assert.assertNotNull(this.cache, (String)("Cache not injected into " + this));
            return 1;
        }
    }
}

