/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cdi.embedded.test.event;

import java.util.Arrays;
import javax.inject.Inject;
import org.infinispan.AdvancedCache;
import org.infinispan.cdi.embedded.test.DefaultTestEmbeddedCacheManagerProducer;
import org.infinispan.cdi.embedded.test.assertions.ObserverAssertion;
import org.infinispan.cdi.embedded.test.event.Cache1;
import org.infinispan.cdi.embedded.test.event.Cache2;
import org.infinispan.cdi.embedded.test.event.CacheObserver;
import org.infinispan.cdi.embedded.test.testutil.Deployments;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.NonTxInvocationContext;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.remoting.transport.Address;
import org.infinispan.topology.CacheTopology;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.mockito.Mockito;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="cdi.test.event.CacheEventTest")
public class CacheEventTest
extends Arquillian {
    private final NonTxInvocationContext invocationContext = new NonTxInvocationContext(null);
    @Inject
    @Cache1
    private AdvancedCache<String, String> cache1;
    @Inject
    @Cache2
    private AdvancedCache<String, String> cache2;
    @Inject
    private CacheObserver cacheObserver;
    private CacheNotifier<String, String> cache1Notifier;
    private CacheManagerNotifier cache1ManagerNotifier;

    @Deployment
    public static Archive<?> deployment() {
        return ((WebArchive)Deployments.baseDeployment().addPackage(CacheEventTest.class.getPackage())).addClass(DefaultTestEmbeddedCacheManagerProducer.class);
    }

    @AfterMethod
    public void afterMethod() {
        this.cache1.clear();
        this.cache2.clear();
        this.cacheObserver.clear();
    }

    @BeforeMethod
    public void beforeMethod() {
        this.cache1Notifier = (CacheNotifier)this.cache1.getComponentRegistry().getComponent(CacheNotifier.class);
        this.cache1ManagerNotifier = (CacheManagerNotifier)this.cache1.getComponentRegistry().getComponent(CacheManagerNotifier.class);
    }

    public void testFiringStartedEventOnNewlyStartedCache() throws Exception {
        this.cache1.stop();
        this.cache1.start();
        ObserverAssertion.assertThat(this.cacheObserver, Cache1.class).hasProperName("cache1").hasStartedEvent();
    }

    public void testFiringStoppedEventWhenStoppingCache() throws Exception {
        this.cache1.stop();
        this.cache1.start();
        ObserverAssertion.assertThat(this.cacheObserver, Cache1.class).hasProperName("cache1").hasStoppedEvent();
    }

    public void testFiringEntryCreatedEventWhenPuttingDataIntoCache() throws Exception {
        this.cache1.put((Object)"pete", (Object)"Edinburgh");
        ObserverAssertion.assertThat(this.cacheObserver, Cache1.class).hasEntryCreatedEvent("pete");
    }

    public void testFiringEntryRemovedEventWhenRemovingDataFromCache() throws Exception {
        this.cache1.put((Object)"pete", (Object)"Edinburgh");
        this.cache1.remove((Object)"pete");
        ObserverAssertion.assertThat(this.cacheObserver, Cache1.class).hasEntryRemovedEvent("pete");
    }

    public void testFiringEntryActivatedEventWhenUsingCacheNotifier() throws Exception {
        this.cache1Notifier.notifyCacheEntryActivated((Object)"pete", (Object)"Edinburgh", true, (InvocationContext)this.invocationContext, null);
        ObserverAssertion.assertThat(this.cacheObserver, Cache1.class).hasEntryActivatedEvent("pete");
    }

    public void testFiringEntriesEvictedWhenEvictingDataInCache() throws Exception {
        this.cache1.put((Object)"pete", (Object)"Edinburgh");
        this.cache1.evict((Object)"pete");
        ObserverAssertion.assertThat(this.cacheObserver, Cache1.class).hasEntriesEvictedEvent("pete");
    }

    public void testFiringEntryEvictedWhenEvictingDataInCache() throws Exception {
        this.cache1.put((Object)"pete", (Object)"Edinburgh");
        this.cache1.evict((Object)"pete");
        ObserverAssertion.assertThat(this.cacheObserver, Cache1.class).hasEntriesEvictedEvent("pete");
    }

    public void testFiringEntryModifiedEventWhenModifyingEntryInCache() throws Exception {
        this.cache1.put((Object)"pete", (Object)"Edinburgh");
        this.cache1.put((Object)"pete", (Object)"Edinburgh2");
        ObserverAssertion.assertThat(this.cacheObserver, Cache1.class).hasEntryModifiedEvent("pete");
    }

    public void testFiringEntryInvalidatedWhenUsingCacheNotifier() throws Exception {
        this.cache1Notifier.notifyCacheEntryInvalidated((Object)"pete", (Object)"Edinburgh", null, true, (InvocationContext)this.invocationContext, null);
        ObserverAssertion.assertThat(this.cacheObserver, Cache1.class).hasEntryInvalidatedEvent("pete");
    }

    public void testFiringEntryLoadedWhenUsingCacheNotifier() throws Exception {
        this.cache1Notifier.notifyCacheEntryLoaded((Object)"pete", (Object)"Edinburgh", true, (InvocationContext)this.invocationContext, null);
        ObserverAssertion.assertThat(this.cacheObserver, Cache1.class).hasEntryLoadedEvent("pete");
    }

    public void testFiringEntryPassivatedWhenUsingCacheNotifier() throws Exception {
        this.cache1Notifier.notifyCacheEntryPassivated((Object)"pete", (Object)"Edinburgh", true, (InvocationContext)this.invocationContext, null);
        ObserverAssertion.assertThat(this.cacheObserver, Cache1.class).hasEntryPassivatedEvent("pete");
    }

    public void testFiringEntryVisitedWhenUsingCacheNotifier() throws Exception {
        this.cache1Notifier.notifyCacheEntryVisited((Object)"pete", (Object)"Edinburgh", true, (InvocationContext)this.invocationContext, null);
        ObserverAssertion.assertThat(this.cacheObserver, Cache1.class).hasEntryVisitedEvent("pete");
    }

    public void testFiringDataRehashedWhenUsingCacheNotifier() throws Exception {
        ConsistentHash mockOldHash = (ConsistentHash)Mockito.mock(ConsistentHash.class);
        ConsistentHash mockNewHash = (ConsistentHash)Mockito.mock(ConsistentHash.class);
        ConsistentHash mockUnionHash = (ConsistentHash)Mockito.mock(ConsistentHash.class);
        this.cache1Notifier.notifyDataRehashed(mockOldHash, mockNewHash, mockUnionHash, 0, true);
        ObserverAssertion.assertThat(this.cacheObserver, Cache1.class).hasDataRehashEvent(mockNewHash);
    }

    public void testFiringTransactionCompletedWhenUsingCacheNotifier() throws Exception {
        GlobalTransaction mockGlobalTransaction = (GlobalTransaction)Mockito.mock(GlobalTransaction.class);
        this.cache1Notifier.notifyTransactionCompleted(mockGlobalTransaction, true, (InvocationContext)this.invocationContext);
        ObserverAssertion.assertThat(this.cacheObserver, Cache1.class).hasTransactionCompletedEvent(true);
    }

    public void testFiringTransactionRegisteredWhenUsingCacheNotifier() throws Exception {
        GlobalTransaction mockGlobalTransaction = (GlobalTransaction)Mockito.mock(GlobalTransaction.class);
        this.cache1Notifier.notifyTransactionRegistered(mockGlobalTransaction, true);
        ObserverAssertion.assertThat(this.cacheObserver, Cache1.class).hasTransactionRegisteredEvent(true);
    }

    public void testFiringViewChangedWhenUsingCacheManagerNotifier() throws Exception {
        Address mockMyAddress = (Address)Mockito.mock(Address.class);
        this.cache1ManagerNotifier.notifyViewChange(Arrays.asList(mockMyAddress), Arrays.asList(mockMyAddress), mockMyAddress, 0);
        ObserverAssertion.assertThat(this.cacheObserver, Cache1.class).hasViewChangedEvent(mockMyAddress);
    }

    public void testFiringTopologyChangedWhenUsingCacheManagerNotifier() throws Exception {
        CacheTopology mockCacheTopology = (CacheTopology)Mockito.mock(CacheTopology.class);
        this.cache1Notifier.notifyTopologyChanged(mockCacheTopology, mockCacheTopology, 0, true);
        ObserverAssertion.assertThat(this.cacheObserver, Cache1.class).hasTopologyChangedEvent(0);
    }

    public void testSendingEventToProperEventObservers() throws Exception {
        this.cache1.put((Object)"cache1", (Object)"for cache1");
        this.cache2.put((Object)"cache2", (Object)"for cache2");
        this.cache1.remove((Object)"cache1");
        ObserverAssertion.assertThat(this.cacheObserver, Cache1.class).hasEntryCreatedEvent("cache1").hasEntryRemovedEvent("cache1");
        ObserverAssertion.assertThat(this.cacheObserver, Cache2.class).hasEntryCreatedEvent("cache2");
    }
}

