/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.regex.Pattern;

public class ForbiddenMethodCheck
extends AbstractCheck {
    private Pattern methodPattern = null;
    private int argumentCount = -1;

    public int[] getDefaultTokens() {
        return new int[]{27};
    }

    public int[] getAcceptableTokens() {
        return this.getDefaultTokens();
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void init() {
        if (this.methodPattern == null) {
            throw new IllegalStateException("The methodPattern attribute is required!");
        }
    }

    public void setMethodPattern(String methodPatternString) {
        this.methodPattern = Pattern.compile(methodPatternString);
    }

    public void setArgumentCount(String argumentCountString) {
        this.argumentCount = Integer.parseInt(argumentCountString);
        if (this.argumentCount <= 0) {
            throw new IllegalArgumentException("Argument count " + this.argumentCount + " was 0 or negative");
        }
    }

    public void visitToken(DetailAST ast) {
        boolean nameMatches = false;
        block4: for (DetailAST child = ast.getFirstChild(); child != null; child = child.getNextSibling()) {
            int childType = child.getType();
            switch (childType) {
                case 59: {
                    String methodName;
                    DetailAST methodAST = child.getLastChild();
                    if (methodAST.getType() != 58 || !this.methodPattern.matcher(methodName = methodAST.getText()).matches()) continue block4;
                    if (this.argumentCount > 0) {
                        nameMatches = true;
                        continue block4;
                    }
                    this.log(ast, "Forbidden method invocation found that matches {0}", new Object[]{this.methodPattern.pattern()});
                    continue block4;
                }
                case 34: {
                    int count;
                    if (!nameMatches || this.argumentCount != (count = child.getChildCount(74) + 1)) continue block4;
                    this.log(ast, "Forbidden method invocation found that matches {0} with {1} number of arguments", new Object[]{this.methodPattern.pattern(), this.argumentCount});
                }
            }
        }
    }
}

