/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.checkstyle.checks.interceptors;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;

public abstract class AbstractInterceptorCheck
extends AbstractCheck {
    protected static Stream<DetailAST> stream(DetailAST ast, int type) {
        Stream.Builder<DetailAST> builder = Stream.builder();
        for (DetailAST child = ast.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getType() != type) continue;
            builder.accept(child);
        }
        return builder.build();
    }

    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    public int[] getAcceptableTokens() {
        return new int[]{14};
    }

    public int[] getRequiredTokens() {
        return this.getAcceptableTokens();
    }

    public void visitToken(DetailAST klass) {
        HashSet containsMethods = new HashSet();
        AbstractInterceptorCheck.stream(klass, 6).flatMap(objblock -> AbstractInterceptorCheck.stream(objblock, 9)).forEach(m -> {
            DetailAST identNode = m.findFirstToken(58);
            if (identNode != null && this.methods().contains(identNode.getText())) {
                containsMethods.add(identNode.getText());
            }
        });
        if (!containsMethods.isEmpty() && containsMethods.size() != this.methods().size()) {
            DetailAST modifiers = klass.findFirstToken(5);
            if (modifiers != null && AbstractInterceptorCheck.stream(modifiers, 159).anyMatch(annotation -> {
                DetailAST identNode = annotation.findFirstToken(58);
                return identNode != null && "Deprecated".equals(identNode.getText());
            })) {
                return;
            }
            HashSet<String> missingMethods = new HashSet<String>(this.methods());
            missingMethods.removeAll(containsMethods);
            this.log(klass.getLineNo(), klass.getColumnNo(), "Interceptor defines methods {0} but does not define {1} [not required for tests]", new Object[]{containsMethods, missingMethods});
        }
    }

    protected abstract Set<String> methods();
}

