/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.interpreter;

import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.cli.interpreter.Interpreter;
import org.infinispan.cli.interpreter.result.ResultKeys;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.TestHelper;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.jboss.GenericJBossMarshaller;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.ByteArrayKey;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterTest;
import org.testng.annotations.Test;

@Test(testName="cli-server.HotRodEncodingTest", groups={"functional"})
@CleanupAfterMethod
public class HotRodEncodingTest
extends SingleCacheManagerTest {
    HotRodServer hotrodServer;
    int port;
    Interpreter interpreter;
    private RemoteCacheManager remoteCacheManager;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder c = this.getDefaultStandaloneCacheConfig(false);
        c.jmxStatistics().enable();
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)c);
    }

    protected void setup() throws Exception {
        super.setup();
        this.hotrodServer = TestHelper.startHotRodServer((EmbeddedCacheManager)this.cacheManager);
        this.port = this.hotrodServer.getPort();
        this.remoteCacheManager = new RemoteCacheManager("localhost", this.hotrodServer.getPort());
        this.remoteCacheManager.start();
        GlobalComponentRegistry gcr = TestingUtil.extractGlobalComponentRegistry((CacheContainer)this.cacheManager);
        this.interpreter = (Interpreter)gcr.getComponent(Interpreter.class);
    }

    @AfterTest(alwaysRun=true)
    public void release() {
        try {
            HotRodClientTestingUtil.killRemoteCacheManager((RemoteCacheManager)this.remoteCacheManager);
            HotRodClientTestingUtil.killServers((HotRodServer[])new HotRodServer[]{this.hotrodServer});
            TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.cacheManager});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void testHotRodCodec() throws Exception {
        Cache cache = this.cacheManager.getCache();
        RemoteCache remoteCache = this.remoteCacheManager.getCache();
        remoteCache.put((Object)"k1", (Object)"v1");
        GenericJBossMarshaller marshaller = new GenericJBossMarshaller();
        ByteArrayKey k1 = new ByteArrayKey(marshaller.objectToByteBuffer((Object)"k1"));
        AssertJUnit.assertTrue((boolean)cache.containsKey((Object)k1));
        String sessionId = this.interpreter.createSessionId("___defaultcache");
        Map response = this.interpreter.execute(sessionId, "get --codec=hotrod k1;");
        AssertJUnit.assertEquals((String)"v1", (String)((String)response.get(ResultKeys.OUTPUT.toString())));
        this.interpreter.execute(sessionId, "put --codec=hotrod k2 v2;");
        String v2 = (String)remoteCache.get((Object)"k2");
        AssertJUnit.assertEquals((String)"v2", (String)v2);
    }

    public void testHotRodEncoding() throws Exception {
        Cache cache = this.cacheManager.getCache();
        RemoteCache remoteCache = this.remoteCacheManager.getCache();
        remoteCache.put((Object)"k1", (Object)"v1");
        GenericJBossMarshaller marshaller = new GenericJBossMarshaller();
        ByteArrayKey k1 = new ByteArrayKey(marshaller.objectToByteBuffer((Object)"k1"));
        AssertJUnit.assertTrue((boolean)cache.containsKey((Object)k1));
        String sessionId = this.interpreter.createSessionId("___defaultcache");
        this.interpreter.execute(sessionId, "encoding hotrod;");
        Map response = this.interpreter.execute(sessionId, "get k1;");
        AssertJUnit.assertEquals((String)"v1", (String)((String)response.get(ResultKeys.OUTPUT.toString())));
        this.interpreter.execute(sessionId, "put k2 v2;");
        String v2 = (String)remoteCache.get((Object)"k2");
        AssertJUnit.assertEquals((String)"v2", (String)v2);
    }
}

