/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.interpreter;

import java.util.Map;
import net.spy.memcached.MemcachedClient;
import org.infinispan.Cache;
import org.infinispan.cli.interpreter.Interpreter;
import org.infinispan.cli.interpreter.result.ResultKeys;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.memcached.MemcachedServer;
import org.infinispan.server.memcached.test.MemcachedTestingUtil;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(testName="cli-server.MemcachedEncodingTest", groups={"functional"})
@CleanupAfterMethod
public class MemcachedEncodingTest
extends SingleCacheManagerTest {
    private static final String MEMCACHED_CACHE = "memcachedCache";
    MemcachedServer memcachedServer;
    int port;
    Interpreter interpreter;
    MemcachedClient memcachedClient;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder c = this.getDefaultStandaloneCacheConfig(false);
        c.jmxStatistics().enable();
        this.cacheManager = TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)c);
        this.memcachedServer = MemcachedTestingUtil.startMemcachedTextServer((EmbeddedCacheManager)this.cacheManager);
        this.port = this.memcachedServer.getPort();
        this.memcachedClient = MemcachedTestingUtil.createMemcachedClient((long)60000L, (int)this.port);
        GlobalComponentRegistry gcr = TestingUtil.extractGlobalComponentRegistry((CacheContainer)this.cacheManager);
        this.interpreter = (Interpreter)gcr.getComponent(Interpreter.class);
        return this.cacheManager;
    }

    @AfterMethod(alwaysRun=true)
    public void release() {
        try {
            this.memcachedServer.stop();
            TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.cacheManager});
            this.memcachedClient.shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void testMemcachedCodec() throws Exception {
        Cache cache = this.cacheManager.getCache(MEMCACHED_CACHE);
        this.memcachedClient.set("k1", 3600, (Object)"v1").get();
        AssertJUnit.assertTrue((boolean)cache.containsKey((Object)"k1"));
        String sessionId = this.interpreter.createSessionId(MEMCACHED_CACHE);
        Map response = this.interpreter.execute(sessionId, "get --codec=memcached k1;");
        AssertJUnit.assertEquals((String)"v1", (String)((String)response.get(ResultKeys.OUTPUT.toString())));
        this.interpreter.execute(sessionId, "put --codec=memcached k2 v2;");
        String v2 = (String)this.memcachedClient.get("k2");
        AssertJUnit.assertEquals((String)"v2", (String)v2);
    }

    public void testMemcachedEncoding() throws Exception {
        Cache cache = this.cacheManager.getCache(MEMCACHED_CACHE);
        this.memcachedClient.set("k1", 3600, (Object)"v1").get();
        AssertJUnit.assertTrue((boolean)cache.containsKey((Object)"k1"));
        String sessionId = this.interpreter.createSessionId(MEMCACHED_CACHE);
        this.interpreter.execute(sessionId, "encoding memcached;");
        Map response = this.interpreter.execute(sessionId, "get k1;");
        AssertJUnit.assertEquals((String)"v1", (String)((String)response.get(ResultKeys.OUTPUT.toString())));
        this.interpreter.execute(sessionId, "put k2 v2;");
        String v2 = (String)this.memcachedClient.get("k2");
        AssertJUnit.assertEquals((String)"v2", (String)v2);
    }
}

