/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.interpreter;

import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.cli.interpreter.Interpreter;
import org.infinispan.cli.interpreter.result.ResultKeys;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.TestHelper;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.loaders.remote.configuration.RemoteCacheStoreConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.CacheValue;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.ByteArrayKey;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(testName="loaders.remote.RemoteCacheStoreMixedAccessTest", groups={"functional"})
public class UpgradeTest
extends AbstractInfinispanTest {
    private HotRodServer sourceServer;
    private HotRodServer targetServer;
    private EmbeddedCacheManager sourceContainer;
    private Cache<ByteArrayKey, CacheValue> sourceServerCache;
    private EmbeddedCacheManager targetContainer;
    private Cache<ByteArrayKey, CacheValue> targetServerCache;
    private RemoteCacheManager sourceRemoteCacheManager;
    private RemoteCache<String, String> sourceRemoteCache;
    private RemoteCacheManager targetRemoteCacheManager;
    private RemoteCache<String, String> targetRemoteCache;

    @BeforeClass
    public void setup() throws Exception {
        ConfigurationBuilder serverBuilder = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)true);
        this.sourceContainer = TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)serverBuilder);
        this.sourceServerCache = this.sourceContainer.getCache();
        this.sourceServer = TestHelper.startHotRodServer((EmbeddedCacheManager)this.sourceContainer);
        ConfigurationBuilder targetConfigurationBuilder = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false);
        ((RemoteCacheStoreConfigurationBuilder)targetConfigurationBuilder.loaders().addStore(RemoteCacheStoreConfigurationBuilder.class)).hotRodWrapping(true).addServer().host("localhost").port(this.sourceServer.getPort());
        this.targetContainer = TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)targetConfigurationBuilder);
        this.targetServerCache = this.targetContainer.getCache();
        this.targetServer = TestHelper.startHotRodServer((EmbeddedCacheManager)this.targetContainer);
        this.sourceRemoteCacheManager = new RemoteCacheManager("localhost", this.sourceServer.getPort());
        this.sourceRemoteCacheManager.start();
        this.sourceRemoteCache = this.sourceRemoteCacheManager.getCache();
        this.targetRemoteCacheManager = new RemoteCacheManager("localhost", this.targetServer.getPort());
        this.targetRemoteCacheManager.start();
        this.targetRemoteCache = this.targetRemoteCacheManager.getCache();
    }

    public void testSynchronization() throws Exception {
        for (char ch = 'A'; ch <= 'Z'; ch = (char)(ch + '\u0001')) {
            String s = Character.toString(ch);
            this.sourceRemoteCache.put((Object)s, (Object)s);
        }
        Interpreter sourceInterpreter = this.getInterpreter(this.sourceContainer);
        String sourceSessionId = sourceInterpreter.createSessionId("___defaultcache");
        Map dumpKeysResult = sourceInterpreter.execute(sourceSessionId, "upgrade --dumpkeys --all;");
        this.checkNoErrors(dumpKeysResult);
        Interpreter targetInterpreter = this.getInterpreter(this.targetContainer);
        String targetSessionId = targetInterpreter.createSessionId("___defaultcache");
        Map synchronizeResult = targetInterpreter.execute(targetSessionId, "upgrade --synchronize=hotrod --all;");
        this.checkNoErrors(synchronizeResult);
        Map disconnectResult = targetInterpreter.execute(targetSessionId, "upgrade --disconnectsource=hotrod --all;");
        this.checkNoErrors(disconnectResult);
        AssertJUnit.assertEquals((int)(this.sourceServerCache.size() - 1), (int)this.targetServerCache.size());
    }

    private Interpreter getInterpreter(EmbeddedCacheManager cm) {
        GlobalComponentRegistry gcr = TestingUtil.extractGlobalComponentRegistry((CacheContainer)cm);
        return (Interpreter)gcr.getComponent(Interpreter.class);
    }

    private void checkNoErrors(Map<String, String> result) {
        AssertJUnit.assertFalse((boolean)result.containsKey(ResultKeys.ERROR.toString()));
    }

    @BeforeMethod(alwaysRun=true)
    public void cleanup() {
        this.sourceServerCache.clear();
        this.targetServerCache.clear();
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        HotRodClientTestingUtil.killRemoteCacheManagers((RemoteCacheManager[])new RemoteCacheManager[]{this.sourceRemoteCacheManager, this.targetRemoteCacheManager});
        HotRodClientTestingUtil.killServers((HotRodServer[])new HotRodServer[]{this.sourceServer, this.targetServer});
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.targetContainer, this.sourceContainer});
    }
}

