/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.dataconversion;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Calendar;
import org.infinispan.commons.dataconversion.EncodingException;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.StandardConversions;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.ProtoStreamMarshaller;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class StandardConversionsTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void textToTextConversion() {
        String source = "All those moments will be lost in time, like tears in rain.";
        byte[] sourceAs8859 = source.getBytes(StandardCharsets.ISO_8859_1);
        byte[] sourceAsASCII = source.getBytes(StandardCharsets.US_ASCII);
        Object result = StandardConversions.convertTextToText((Object)sourceAs8859, (MediaType)MediaType.TEXT_PLAIN.withCharset(StandardCharsets.ISO_8859_1), (MediaType)MediaType.TEXT_PLAIN.withCharset(StandardCharsets.US_ASCII));
        Assert.assertArrayEquals((byte[])sourceAsASCII, (byte[])((byte[])result));
    }

    @Test
    public void testTextToOctetStreamConversion() {
        String source = "Like our owl?";
        byte[] result = StandardConversions.convertTextToOctetStream((Object)source, (MediaType)MediaType.TEXT_PLAIN);
        Assert.assertArrayEquals((byte[])source.getBytes(StandardCharsets.UTF_8), (byte[])result);
    }

    @Test
    public void testTextToObjectConversion() {
        String source = "Can the maker repair what he makes?";
        String source2 = "I had your job once. I was good at it.";
        byte[] sourceBytes = source2.getBytes(StandardCharsets.US_ASCII);
        String result = StandardConversions.convertTextToObject((Object)source, (MediaType)MediaType.APPLICATION_OBJECT);
        String result2 = StandardConversions.convertTextToObject((Object)sourceBytes, (MediaType)MediaType.TEXT_PLAIN.withCharset(StandardCharsets.US_ASCII));
        Assert.assertEquals((Object)source, (Object)result);
        Assert.assertEquals((Object)source2, (Object)result2);
    }

    @Test
    public void testTextToURLEncodedConversion() throws UnsupportedEncodingException {
        String source = "They're either a benefit or a hazard. If they're a benefit, it's not my problem.";
        String result = StandardConversions.convertTextToUrlEncoded((Object)source, (MediaType)MediaType.TEXT_PLAIN.withCharset(StandardCharsets.UTF_16));
        Assert.assertEquals((Object)URLEncoder.encode(source, "UTF-16"), (Object)result);
    }

    @Test
    public void testOctetStreamToTextConversion() {
        String text = "Have you ever retired a human by mistake?";
        byte[] bytes1 = text.getBytes();
        byte[] bytes2 = new byte[]{1, 2, 3};
        byte[] result1 = StandardConversions.convertOctetStreamToText((byte[])bytes1, (MediaType)MediaType.TEXT_PLAIN.withCharset(StandardCharsets.US_ASCII));
        byte[] result2 = StandardConversions.convertOctetStreamToText((byte[])bytes2, (MediaType)MediaType.TEXT_PLAIN);
        Assert.assertArrayEquals((byte[])text.getBytes(StandardCharsets.US_ASCII), (byte[])result1);
        Assert.assertArrayEquals((byte[])new String(bytes2).getBytes(StandardCharsets.UTF_8), (byte[])result2);
    }

    @Test
    public void testOctetStreamToJavaConversion() {
        String value = "It's not an easy thing to meet your maker.";
        byte[] textStream = value.getBytes(StandardCharsets.UTF_8);
        byte[] randomBytes = new byte[]{23, 23, 34, 1, -1, -123};
        ProtoStreamMarshaller marshaller = new ProtoStreamMarshaller();
        MediaType stringType = MediaType.APPLICATION_OBJECT.withParameter("type", "java.lang.String");
        Object result = StandardConversions.convertOctetStreamToJava((byte[])textStream, (MediaType)stringType, (Marshaller)marshaller);
        Assert.assertEquals((Object)value, (Object)result);
        MediaType byteArrayType = MediaType.APPLICATION_OBJECT.withParameter("type", "ByteArray");
        Object result2 = StandardConversions.convertOctetStreamToJava((byte[])textStream, (MediaType)byteArrayType, (Marshaller)marshaller);
        Assert.assertArrayEquals((byte[])textStream, (byte[])((byte[])result2));
        Object result3 = StandardConversions.convertOctetStreamToJava((byte[])randomBytes, (MediaType)byteArrayType, (Marshaller)marshaller);
        Assert.assertArrayEquals((byte[])randomBytes, (byte[])((byte[])result3));
        this.thrown.expect(EncodingException.class);
        MediaType doubleType = MediaType.APPLICATION_OBJECT.withParameter("type", "java.lang.Double");
        StandardConversions.convertOctetStreamToJava((byte[])randomBytes, (MediaType)doubleType, (Marshaller)marshaller);
        System.out.println(this.thrown);
    }

    @Test
    public void testJavaToTextConversion() {
        String string = "I've seen things you people wouldn't believe.";
        Double number = 12.1;
        Calendar complex = Calendar.getInstance();
        MediaType stringType = MediaType.APPLICATION_OBJECT.withParameter("type", "java.lang.String");
        byte[] result1 = StandardConversions.convertJavaToText((Object)string, (MediaType)stringType, (MediaType)MediaType.TEXT_PLAIN.withCharset(StandardCharsets.UTF_16BE));
        Assert.assertArrayEquals((byte[])string.getBytes(StandardCharsets.UTF_16BE), (byte[])result1);
        MediaType doubleType = MediaType.APPLICATION_OBJECT.withParameter("type", "java.lang.Double");
        byte[] result2 = StandardConversions.convertJavaToText((Object)number, (MediaType)doubleType, (MediaType)MediaType.TEXT_PLAIN.withCharset(StandardCharsets.US_ASCII));
        Assert.assertArrayEquals((byte[])"12.1".getBytes(StandardCharsets.US_ASCII), (byte[])result2);
        MediaType customType = MediaType.APPLICATION_OBJECT.withParameter("type", complex.getClass().getName());
        byte[] bytes = StandardConversions.convertJavaToText((Object)complex, (MediaType)customType, (MediaType)MediaType.TEXT_PLAIN.withCharset(StandardCharsets.US_ASCII));
        Assert.assertEquals((Object)complex.toString(), (Object)new String(bytes));
    }

    @Test
    public void testJavaToOctetStreamConversion() throws IOException, InterruptedException {
        ProtoStreamMarshaller marshaller = new ProtoStreamMarshaller();
        String string = "I've seen things you people wouldn't believe.";
        Double number = 12.1;
        Instant complex = Instant.now();
        byte[] binary = new byte[]{1, 2, 3};
        MediaType stringType = MediaType.APPLICATION_OBJECT.withParameter("type", "java.lang.String");
        byte[] result = StandardConversions.convertJavaToOctetStream((Object)string, (MediaType)stringType, (Marshaller)marshaller);
        Assert.assertArrayEquals((byte[])string.getBytes(StandardCharsets.UTF_8), (byte[])result);
        MediaType doubleType = MediaType.APPLICATION_OBJECT.withParameter("type", "java.lang.Double");
        result = StandardConversions.convertJavaToOctetStream((Object)number, (MediaType)doubleType, (Marshaller)marshaller);
        Assert.assertArrayEquals((byte[])marshaller.objectToByteBuffer((Object)number), (byte[])result);
        MediaType customType = MediaType.APPLICATION_OBJECT.withParameter("type", complex.getClass().getName());
        result = StandardConversions.convertJavaToOctetStream((Object)complex, (MediaType)customType, (Marshaller)marshaller);
        Assert.assertArrayEquals((byte[])marshaller.objectToByteBuffer((Object)complex), (byte[])result);
        MediaType byteArrayType = MediaType.APPLICATION_OBJECT.withParameter("type", "ByteArray");
        result = StandardConversions.convertJavaToOctetStream((Object)binary, (MediaType)byteArrayType, (Marshaller)marshaller);
        Assert.assertArrayEquals((byte[])result, (byte[])binary);
    }

    @Test
    public void testHexConversion() throws Exception {
        Assert.assertNull((Object)StandardConversions.bytesToHex(null));
        Assert.assertNull((Object)StandardConversions.hexToBytes(null));
        Assert.assertEquals((Object)"", (Object)StandardConversions.bytesToHex((byte[])new byte[0]));
        Assert.assertArrayEquals((byte[])new byte[0], (byte[])StandardConversions.hexToBytes((String)""));
        ProtoStreamMarshaller marshaller = new ProtoStreamMarshaller();
        byte[] before = marshaller.objectToByteBuffer((Object)Instant.now());
        byte[] after = StandardConversions.hexToBytes((String)StandardConversions.bytesToHex((byte[])before));
        Assert.assertArrayEquals((byte[])before, (byte[])after);
        Assert.assertEquals((Object)"0x010203", (Object)StandardConversions.bytesToHex((byte[])new byte[]{1, 2, 3}));
        Assert.assertEquals((Object)"0x808080", (Object)StandardConversions.bytesToHex((byte[])new byte[]{-128, -128, -128}));
    }
}

