/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.marshall;

import java.time.Instant;
import java.util.Date;
import org.infinispan.commons.marshall.ProtoStreamMarshaller;
import org.junit.Assert;
import org.junit.Test;

public class ProtoStreamMarshallerTest {
    @Test
    public void testBasicTypesAreMarshallable() throws Exception {
        this.roundtrip("a");
        this.roundtrip(Character.valueOf('a'));
        this.roundtrip(0);
        this.roundtrip(0L);
        this.roundtrip(0.0);
        this.roundtrip(Float.valueOf(0.0f));
        this.roundtrip((byte)0);
        this.roundtrip((short)0);
        this.roundtrip(true);
        this.roundtrip(new Date(0L));
        this.roundtrip(Instant.now());
        this.roundtrip(new byte[0]);
    }

    private void roundtrip(Object in) throws Exception {
        ProtoStreamMarshaller marshaller = new ProtoStreamMarshaller();
        Assert.assertTrue((boolean)marshaller.isMarshallable(in));
        byte[] buffer = marshaller.objectToByteBuffer(in);
        Assert.assertNotNull((Object)buffer);
        Object out = marshaller.objectFromByteBuffer(buffer);
        Assert.assertNotNull((Object)out);
        Assert.assertEquals(in.getClass(), out.getClass());
        if (in instanceof byte[]) {
            Assert.assertArrayEquals((byte[])((byte[])in), (byte[])((byte[])out));
        } else {
            Assert.assertEquals((Object)in, (Object)out);
        }
    }
}

