/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util.uberjar;

import java.util.Arrays;
import java.util.List;
import org.infinispan.commons.util.uberjar.ManifestUberJarDuplicatedJarsWarner;
import org.junit.Assert;
import org.junit.Test;

public class ManifestUberJarDuplicatedJarsWarnerTest {
    @Test
    public void shouldDetectBothUberJars() throws Exception {
        ManifestUberJarDuplicatedJarsWarner scanner = new ManifestUberJarDuplicatedJarsWarner(){

            List<String> getBundleSymbolicNames() {
                return Arrays.asList("org.infinispan.embedded", "org.infinispan.remote");
            }
        };
        Boolean isClasspathCorrect = scanner.isClasspathCorrect();
        Assert.assertFalse((boolean)isClasspathCorrect);
    }

    @Test
    public void shouldDetectCommonsAndUberJar() throws Exception {
        ManifestUberJarDuplicatedJarsWarner scanner = new ManifestUberJarDuplicatedJarsWarner(){

            List<String> getBundleSymbolicNames() {
                return Arrays.asList("org.infinispan.embedded", "org.infinispan.commons");
            }
        };
        Boolean isClasspathCorrect = scanner.isClasspathCorrect();
        Assert.assertFalse((boolean)isClasspathCorrect);
    }

    @Test
    public void shouldNotThrowExceptionOnEmptyClasspath() throws Exception {
        new ManifestUberJarDuplicatedJarsWarner(){

            List<String> getBundleSymbolicNames() {
                return Arrays.asList("org.infinispan.embedded", "org.infinispan.commons");
            }
        }.isClasspathCorrect();
    }

    @Test
    public void shouldPassOnNormalClasspath() throws Exception {
        ManifestUberJarDuplicatedJarsWarner scanner = new ManifestUberJarDuplicatedJarsWarner(){

            List<String> getBundleSymbolicNames() {
                return Arrays.asList("org.infinispan.embedded", "org.acme.DonaldDuck");
            }
        };
        Boolean isClasspathCorrect = scanner.isClasspathCorrect();
        Assert.assertTrue((boolean)isClasspathCorrect);
    }
}

