/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.jupiter;

import java.util.Collections;
import java.util.Map;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfiguration;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TestResourceTracker;
import org.junit.jupiter.api.extension.Extension;

public class InfinispanServerExtension
implements Extension {
    private HotRodServer hotRodServer;
    private RemoteCacheManager hotRodClient;

    public Map<String, String> start() {
        TestResourceTracker.setThreadTestName((String)"InfinispanServer");
        EmbeddedCacheManager ecm = TestCacheManagerFactory.createCacheManager((GlobalConfigurationBuilder)new GlobalConfigurationBuilder().nonClusteredDefault().defaultCacheName("default"), (org.infinispan.configuration.cache.ConfigurationBuilder)new org.infinispan.configuration.cache.ConfigurationBuilder());
        this.hotRodServer = HotRodTestingUtil.startHotRodServer((EmbeddedCacheManager)ecm, (int)11222);
        return Collections.emptyMap();
    }

    public void stop() {
        if (this.hotRodServer != null) {
            this.hotRodServer.stop();
        }
    }

    public RemoteCacheManager hotRodClient() {
        if (this.hotRodClient == null) {
            ConfigurationBuilder builder = new ConfigurationBuilder();
            HotRodServerConfiguration serverConfiguration = (HotRodServerConfiguration)this.hotRodServer.getConfiguration();
            builder.addServer().host(serverConfiguration.publicHost()).port(serverConfiguration.publicPort());
            this.hotRodClient = new RemoteCacheManager(builder.build());
        }
        return this.hotRodClient;
    }
}

