/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl.function.set;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.multimap.impl.ExternalizerIds;
import org.infinispan.multimap.impl.SetBucket;
import org.infinispan.multimap.impl.function.set.SetBucketBaseFunction;

public final class SSetFunction<K, V>
implements SetBucketBaseFunction<K, V, Long> {
    public static final AdvancedExternalizer<SSetFunction> EXTERNALIZER = new Externalizer();
    private final Collection<V> values;

    public SSetFunction(Collection<V> values) {
        this.values = values;
    }

    public Long apply(EntryView.ReadWriteEntryView<K, SetBucket<V>> entryView) {
        SetBucket<V> set = new SetBucket<V>(new HashSet<V>(this.values));
        entryView.set(set, new MetaParam.Writable[0]);
        return set.size();
    }

    private static class Externalizer
    implements AdvancedExternalizer<SSetFunction> {
        private Externalizer() {
        }

        public Set<Class<? extends SSetFunction>> getTypeClasses() {
            return Collections.singleton(SSetFunction.class);
        }

        public Integer getId() {
            return ExternalizerIds.SET_SET_FUNCTION;
        }

        public void writeObject(ObjectOutput output, SSetFunction object) throws IOException {
            output.writeInt(object.values.size());
            for (Object el : object.values) {
                output.writeObject(el);
            }
        }

        public SSetFunction readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            int size = input.readInt();
            HashSet<Object> values = new HashSet<Object>(size);
            for (int i = 0; i < size; ++i) {
                values.add(input.readObject());
            }
            return new SSetFunction(values);
        }
    }
}

