/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.core.impl;

import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.infinispan.commons.time.DefaultTimeService;
import org.infinispan.commons.time.TimeService;
import org.infinispan.query.SearchTimeoutException;

class TimedCollector<U, A, R>
implements Collector<U, A, R> {
    private final Collector<U, A, R> collector;
    private final long timeout;
    private static final TimeService TIME_SERVICE = DefaultTimeService.INSTANCE;

    public TimedCollector(Collector<U, A, R> collector, long timeout) {
        this.collector = collector;
        this.timeout = timeout;
    }

    @Override
    public Supplier<A> supplier() {
        return this.collector.supplier();
    }

    @Override
    public BiConsumer<A, U> accumulator() {
        final BiConsumer<A, U> accumulator = this.collector.accumulator();
        if (this.timeout < 0L) {
            return accumulator;
        }
        return new BiConsumer<A, U>(){
            int index = 0;
            long limit = TimedCollector.access$000().time() + TimedCollector.access$100(TimedCollector.this);

            boolean divBy32(int i) {
                return (i & 0x1F) == 0;
            }

            @Override
            public void accept(A a, U u) {
                if (this.divBy32(this.index++) && TIME_SERVICE.isTimeExpired(this.limit)) {
                    throw new SearchTimeoutException();
                }
                accumulator.accept(a, u);
            }
        };
    }

    @Override
    public BinaryOperator<A> combiner() {
        return this.collector.combiner();
    }

    @Override
    public Function<A, R> finisher() {
        return this.collector.finisher();
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return this.collector.characteristics();
    }

    static /* synthetic */ long access$100(TimedCollector x0) {
        return x0.timeout;
    }
}

