/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.core.impl;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.StreamSupport;
import org.infinispan.commons.util.Closeables;
import org.infinispan.query.core.impl.MappingIterator;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="query.core.impl.MappingIteratorTest")
public class MappingIteratorTest {
    private final List<Integer> integers = Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 9, 10);

    @Test
    public void testIteration() {
        MappingIterator mapIterator = this.createMappingIterator(this.integers);
        this.assertIterator(mapIterator, "1", "2", "3", "4", "5", "6", "7", "8", "9", "10");
        mapIterator = this.createMappingIterator(this.integers).limit(0L);
        this.assertIterator((MappingIterator<Integer, String>)mapIterator, new String[0]);
        mapIterator = this.createMappingIterator(this.integers).limit(2L);
        this.assertIterator((MappingIterator<Integer, String>)mapIterator, "1", "2");
        mapIterator = this.createMappingIterator(this.integers).limit(20L);
        this.assertIterator((MappingIterator<Integer, String>)mapIterator, "1", "2", "3", "4", "5", "6", "7", "8", "9", "10");
        mapIterator = this.createMappingIterator(this.integers).skip(4L);
        this.assertIterator((MappingIterator<Integer, String>)mapIterator, "5", "6", "7", "8", "9", "10");
        mapIterator = this.createMappingIterator(this.integers).skip(11L);
        this.assertIterator((MappingIterator<Integer, String>)mapIterator, new String[0]);
        mapIterator = this.createMappingIterator(this.integers).skip(0L).limit(10L);
        this.assertIterator((MappingIterator<Integer, String>)mapIterator, "1", "2", "3", "4", "5", "6", "7", "8", "9", "10");
        mapIterator = this.createMappingIterator(this.integers).skip(5L).limit(2L);
        this.assertIterator((MappingIterator<Integer, String>)mapIterator, "6", "7");
        mapIterator = this.createMappingIterator(this.integers).skip(1L).limit(1L);
        this.assertIterator((MappingIterator<Integer, String>)mapIterator, "2");
        mapIterator = this.createMappingIterator(this.integers).skip(50L).limit(2L);
        this.assertIterator((MappingIterator<Integer, String>)mapIterator, new String[0]);
        mapIterator = this.createMappingIterator(Arrays.asList(1, null, 3, null, 4));
        this.assertIterator(mapIterator, "1", "3", "4");
        mapIterator = this.createMappingIterator(Arrays.asList(1, null, 3, null, 4, 5, 6)).skip(1L).limit(3L);
        this.assertIterator((MappingIterator<Integer, String>)mapIterator, "3", "4", "5");
    }

    @Test
    public void testFiltering() {
        Function<Integer, String> EVEN = integer -> integer % 2 != 0 ? null : String.valueOf(integer);
        Function<Integer, String> LT5 = integer -> integer < 5 ? String.valueOf(integer) : null;
        Function<Integer, String> ALL = String::valueOf;
        Function<Integer, String> NONE = integer -> null;
        MappingIterator<Integer, String> mappingIterator = this.createMappingIterator(this.integers, EVEN).skip(1L);
        this.assertIterator(mappingIterator, "4", "6", "8", "10");
        mappingIterator = this.createMappingIterator(this.integers, EVEN);
        this.assertIterator(mappingIterator, "2", "4", "6", "8", "10");
        mappingIterator = this.createMappingIterator(this.integers, EVEN).skip(1L);
        this.assertIterator(mappingIterator, "4", "6", "8", "10");
        mappingIterator = this.createMappingIterator(this.integers, LT5);
        this.assertIterator(mappingIterator, "1", "2", "3", "4");
        mappingIterator = this.createMappingIterator(this.integers, ALL);
        this.assertIterator(mappingIterator, "1", "2", "3", "4", "5", "6", "7", "8", "9", "10");
        mappingIterator = this.createMappingIterator(this.integers, LT5).skip(1L).limit(1L);
        this.assertIterator(mappingIterator, "2");
        mappingIterator = this.createMappingIterator(this.integers, LT5).skip(5L).limit(10L);
        this.assertIterator(mappingIterator, new String[0]);
        mappingIterator = this.createMappingIterator(this.integers, NONE);
        this.assertIterator(mappingIterator, new String[0]);
    }

    private MappingIterator<Integer, String> createMappingIterator(List<Integer> data) {
        return new MappingIterator(Closeables.iterator(data.iterator()), String::valueOf);
    }

    private MappingIterator<Integer, String> createMappingIterator(List<Integer> data, Function<Integer, String> fn) {
        return new MappingIterator(Closeables.iterator(data.iterator()), fn);
    }

    private void assertIterator(MappingIterator<Integer, String> iterator, String ... expected) {
        Iterable iterable = () -> iterator;
        Object[] elements = StreamSupport.stream(iterable.spliterator(), false).toArray();
        Assert.assertEquals((Object[])elements, (Object[])expected);
    }
}

