/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.configuration;

import java.util.Map;
import javax.net.ssl.SSLContext;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.server.core.configuration.SslEngineConfiguration;

public class SslConfiguration
extends ConfigurationElement<SslConfiguration> {
    public static final String DEFAULT_SNI_DOMAIN = "*";
    static final AttributeDefinition<Boolean> ENABLED = AttributeDefinition.builder((String)"enabled", (Object)false).immutable().build();
    static final AttributeDefinition<Boolean> REQUIRE_CLIENT_AUTH = AttributeDefinition.builder((String)"require-client-auth", (Object)false).immutable().build();
    private final Map<String, SslEngineConfiguration> sniDomainsConfiguration;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(SslConfiguration.class, new AttributeDefinition[]{ENABLED, REQUIRE_CLIENT_AUTH});
    }

    SslConfiguration(AttributeSet attributes, Map<String, SslEngineConfiguration> sniDomainsConfiguration) {
        super("ssl", attributes, new ConfigurationElement[0]);
        this.sniDomainsConfiguration = sniDomainsConfiguration;
    }

    public boolean enabled() {
        return (Boolean)this.attributes.attribute(ENABLED).get();
    }

    public boolean requireClientAuth() {
        return (Boolean)this.attributes.attribute(REQUIRE_CLIENT_AUTH).get();
    }

    public String keyStoreFileName() {
        return this.sniDomainsConfiguration.get(DEFAULT_SNI_DOMAIN).keyStoreFileName();
    }

    public char[] keyStorePassword() {
        return this.sniDomainsConfiguration.get(DEFAULT_SNI_DOMAIN).keyStorePassword();
    }

    public char[] keyStoreCertificatePassword() {
        return this.sniDomainsConfiguration.get(DEFAULT_SNI_DOMAIN).keyStoreCertificatePassword();
    }

    public SSLContext sslContext() {
        return this.sniDomainsConfiguration.get(DEFAULT_SNI_DOMAIN).sslContext();
    }

    public String trustStoreFileName() {
        return this.sniDomainsConfiguration.get(DEFAULT_SNI_DOMAIN).trustStoreFileName();
    }

    public char[] trustStorePassword() {
        return this.sniDomainsConfiguration.get(DEFAULT_SNI_DOMAIN).trustStorePassword();
    }

    public Map<String, SslEngineConfiguration> sniDomainsConfiguration() {
        return this.sniDomainsConfiguration;
    }
}

