/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.transport;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.ipfilter.IpFilterRule;
import io.netty.handler.ipfilter.IpFilterRuleType;
import java.net.InetSocketAddress;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.logging.Log;

@ChannelHandler.Sharable
public class AccessControlFilter<A extends ProtocolServerConfiguration>
extends ChannelInboundHandlerAdapter {
    public static final AccessControlFilterEvent EVENT = new AccessControlFilterEvent();
    private final A configuration;
    private final boolean onRegistration;

    public AccessControlFilter(A configuration) {
        this(configuration, true);
    }

    public AccessControlFilter(A configuration, boolean onRegistration) {
        this.configuration = configuration;
        this.onRegistration = onRegistration;
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof AccessControlFilterEvent) {
            this.processRules(ctx);
        }
        ctx.fireUserEventTriggered(evt);
    }

    protected boolean accept(InetSocketAddress remoteAddress) throws Exception {
        if (!((ProtocolServerConfiguration)((Object)this.configuration)).isEnabled()) {
            return false;
        }
        for (IpFilterRule ipFilterRule : ((ProtocolServerConfiguration)((Object)this.configuration)).ipFilter().rules()) {
            if (!ipFilterRule.matches(remoteAddress)) continue;
            if (ipFilterRule.ruleType() == IpFilterRuleType.REJECT) {
                Log.SECURITY.ipFilterConnectionRejection(remoteAddress, ipFilterRule);
            }
            return ipFilterRule.ruleType() == IpFilterRuleType.ACCEPT;
        }
        return true;
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        if (this.onRegistration) {
            this.processRules(ctx);
        }
        ctx.fireChannelRegistered();
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        if (!this.processRules(ctx)) {
            throw new IllegalStateException("cannot determine to accept or reject a channel: " + ctx.channel());
        }
        ctx.fireChannelActive();
    }

    private boolean processRules(ChannelHandlerContext ctx) throws Exception {
        InetSocketAddress remoteAddress = (InetSocketAddress)ctx.channel().remoteAddress();
        if (remoteAddress == null) {
            return false;
        }
        ctx.pipeline().remove((ChannelHandler)this);
        if (!this.accept(remoteAddress)) {
            ctx.close();
        }
        return true;
    }

    public static class AccessControlFilterEvent {
        private AccessControlFilterEvent() {
        }
    }
}

