/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core;

import io.netty.channel.Channel;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOutboundHandler;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.core.configuration.MockServerConfigurationBuilder;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.test.AbstractInfinispanTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.core.AbstractProtocolServerTest")
public class AbstractProtocolServerTest
extends AbstractInfinispanTest {
    public void testValidateNegativeWorkerThreads() {
        MockServerConfigurationBuilder b = new MockServerConfigurationBuilder();
        b.workerThreads(-1);
        this.expectIllegalArgument(b, new MockProtocolServer());
    }

    public void testValidateNegativeIdleTimeout() {
        MockServerConfigurationBuilder b = new MockServerConfigurationBuilder();
        b.idleTimeout(-2);
        this.expectIllegalArgument(b, new MockProtocolServer());
    }

    public void testValidateNegativeSendBufSize() {
        MockServerConfigurationBuilder b = new MockServerConfigurationBuilder();
        b.sendBufSize(-1);
        this.expectIllegalArgument(b, new MockProtocolServer());
    }

    public void testValidateNegativeRecvBufSize() {
        MockServerConfigurationBuilder b = new MockServerConfigurationBuilder();
        b.recvBufSize(-1);
        this.expectIllegalArgument(b, new MockProtocolServer());
    }

    public void testStartingWithoutTransport() {
        MockServerConfigurationBuilder b = new MockServerConfigurationBuilder();
        b.startTransport(false);
        MockProtocolServer server = new MockProtocolServer();
        try {
            server.start(b.build(), (EmbeddedCacheManager)new DefaultCacheManager(new ConfigurationBuilder().build()));
            Assert.assertFalse((boolean)server.isTransportEnabled());
        }
        finally {
            server.stop();
        }
    }

    private void expectIllegalArgument(MockServerConfigurationBuilder builder, MockProtocolServer server) {
        server.stop();
    }

    class MockProtocolServer
    extends AbstractProtocolServer {
        protected MockProtocolServer() {
            super(null);
        }

        public ChannelOutboundHandler getEncoder() {
            return null;
        }

        public ChannelInboundHandler getDecoder() {
            return null;
        }

        public ProtocolServerConfiguration getConfiguration() {
            return this.configuration;
        }

        public ChannelInitializer<Channel> getInitializer() {
            return null;
        }
    }
}

