/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import org.infinispan.commons.util.Util;
import org.infinispan.server.core.transport.ExtendedByteBuf;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.hotrod.VariableLengthTest")
public class VariableLengthTest {
    public void test2pow7minus1() {
        this.writeReadInt(127, 1);
    }

    public void test2pow7() {
        this.writeReadInt(128, 2);
    }

    public void test2pow14minus1() {
        this.writeReadInt(16383, 2);
    }

    public void test2pow14() {
        this.writeReadInt(16384, 3);
    }

    public void test2pow21minus1() {
        this.writeReadInt(0x1FFFFF, 3);
    }

    public void test2pow21() {
        this.writeReadInt(0x200000, 4);
    }

    public void test2pow28minus1() {
        this.writeReadInt(0xFFFFFFF, 4);
    }

    public void test2pow28() {
        this.writeReadInt(0x10000000, 5);
    }

    public void test2pow35minus1() {
        this.writeReadLong(0x7FFFFFFFFL, 5);
    }

    public void test2pow35() {
        this.writeReadLong(0x800000000L, 6);
    }

    public void test2pow42minus1() {
        this.writeReadLong(0x3FFFFFFFFFFL, 6);
    }

    public void test2pow42() {
        this.writeReadLong(0x40000000000L, 7);
    }

    public void test2pow49minus1() {
        this.writeReadLong(0x1FFFFFFFFFFFFL, 7);
    }

    public void test2pow49() {
        this.writeReadLong(0x2000000000000L, 8);
    }

    public void test2pow56minus1() {
        this.writeReadLong(0xFFFFFFFFFFFFFFL, 8);
    }

    public void test2pow56() {
        this.writeReadLong(0x100000000000000L, 9);
    }

    public void test2pow63minus1() {
        this.writeReadLong(Long.MAX_VALUE, 9);
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testTooLongInt() {
        ByteBuf buffer = Unpooled.directBuffer((int)1024);
        assert (buffer.writerIndex() == 0);
        ExtendedByteBuf.writeUnsignedLong((long)Long.MAX_VALUE, (ByteBuf)buffer);
        ExtendedByteBuf.readUnsignedInt((ByteBuf)buffer);
        buffer.release();
    }

    @Test(groups={"unstable"})
    public void testPrintHexadecimalVint() {
        ByteBuf buffer = Unpooled.directBuffer((int)1024);
        assert (buffer.writerIndex() == 0);
        ExtendedByteBuf.writeUnsignedLong((long)512L, (ByteBuf)buffer);
        System.out.println(Util.hexDump((ByteBuffer)buffer.nioBuffer()));
        System.out.println();
        buffer.release();
    }

    private void writeReadInt(int num, int expected) {
        ByteBuf buffer = Unpooled.directBuffer((int)1024);
        assert (buffer.writerIndex() == 0);
        ExtendedByteBuf.writeUnsignedInt((int)num, (ByteBuf)buffer);
        AssertJUnit.assertEquals((int)buffer.writerIndex(), (int)expected);
        AssertJUnit.assertEquals((int)ExtendedByteBuf.readUnsignedInt((ByteBuf)buffer), (int)num);
        buffer.release();
    }

    private void writeReadLong(long num, int expected) {
        ByteBuf buffer = Unpooled.directBuffer((int)1024);
        assert (buffer.writerIndex() == 0);
        ExtendedByteBuf.writeUnsignedLong((long)num, (ByteBuf)buffer);
        AssertJUnit.assertEquals((int)buffer.writerIndex(), (int)expected);
        AssertJUnit.assertEquals((long)ExtendedByteBuf.readUnsignedLong((ByteBuf)buffer), (long)num);
        buffer.release();
    }
}

