/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.test;

import io.netty.channel.unix.Errors;
import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.util.function.Function;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.server.core.AbstractProtocolServer;

public class ServerTestingUtil {
    private static final int DEFAULT_PORT = 15232;
    private static Log LOG = LogFactory.getLog(ServerTestingUtil.class);

    public static void killServer(AbstractProtocolServer<?> server) {
        try {
            if (server != null) {
                server.stop();
            }
        }
        catch (Throwable t) {
            LOG.error((Object)"Error stopping server", t);
        }
    }

    private static boolean isBindException(Throwable e) {
        if (e instanceof BindException) {
            return true;
        }
        if (e instanceof Errors.NativeIoException) {
            Errors.NativeIoException nativeIoException = (Errors.NativeIoException)e;
            return nativeIoException.getMessage().contains("bind");
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int findFreePort() {
        try (ServerSocket socket = new ServerSocket(0);){
            int n = socket.getLocalPort();
            return n;
        }
        catch (IOException e) {
            LOG.debug((Object)"Error finding free port, using default of 15232");
            return 15232;
        }
    }

    public static <S extends AbstractProtocolServer<?>> S startProtocolServer(int initialPort, Function<Integer, S> serverStarter) {
        AbstractProtocolServer server = null;
        int maxTries = 10;
        int currentTries = 0;
        Throwable lastError = null;
        while (server == null && currentTries < maxTries) {
            try {
                server = (AbstractProtocolServer)serverStarter.apply(initialPort);
            }
            catch (Throwable t) {
                if (!ServerTestingUtil.isBindException(t)) {
                    throw t;
                }
                LOG.debug((Object)("Address already in use: [" + t.getMessage() + "], retrying"));
                ++currentTries;
                initialPort = ServerTestingUtil.findFreePort();
                lastError = t;
            }
        }
        if (server == null && lastError != null) {
            throw new AssertionError((Object)lastError);
        }
        return (S)server;
    }
}

