/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.time.Instant;
import java.time.temporal.Temporal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.MediaTypeIds;
import org.infinispan.commons.tx.XidImpl;
import org.infinispan.commons.util.Util;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterType;
import org.infinispan.counter.util.EncodeUtil;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.metadata.Metadata;
import org.infinispan.server.hotrod.AccessLoggingHeader;
import org.infinispan.server.hotrod.BaseDecoder;
import org.infinispan.server.hotrod.BitShift;
import org.infinispan.server.hotrod.HotRodConstants;
import org.infinispan.server.hotrod.HotRodHeader;
import org.infinispan.server.hotrod.HotRodOperation;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.HotRodUnknownOperationException;
import org.infinispan.server.hotrod.Intrinsics;
import org.infinispan.server.hotrod.InvalidMagicIdException;
import org.infinispan.server.hotrod.ProtocolFlag;
import org.infinispan.server.hotrod.RequestParsingException;
import org.infinispan.server.hotrod.TimeUnitValue;
import org.infinispan.server.hotrod.TransactionWrite;
import org.infinispan.server.hotrod.logging.HotRodAccessLogging;
import org.infinispan.server.hotrod.tx.ControlByte;

public class HotRodDecoder
extends BaseDecoder {
    private int state;
    private int requestBytes;
    private byte hr2x_timeUnits;
    private int hr2x_numEntries;
    private String hr2x_iterationId;
    private byte hr2x_controlByte;
    private byte[] hr2x_fixedArray;
    private byte[] hr2x_queryBytes;
    private byte hr2x_counterFlags;
    private long hr2x_expectValue;
    private ByteBuf hr2x_readable;
    private boolean hr2x_includeCurrentState;
    private String hr2x_taskParam;
    private String hr2x_cacheName;
    private int hr2x_vInt;
    private MediaType hr2x_valueType;
    private long hr2x_initialValue;
    private int hr2x_numModifications;
    private byte[] hr2x_param;
    private String hr2x_authMech;
    private byte[] hr2x_authResponse;
    private int hr2x_listenerInterests;
    private byte hr2x_numParams;
    private int hr2x_xidFormat;
    private String hr2x_filterFactory;
    private long hr2x_maxIdleLong;
    private HotRodOperation hr2x_operation;
    private long hr2x_upperBound;
    private byte hr2x_version;
    private String hr2x_converterFactory;
    private int hr2x_signedVInt;
    private MediaType hr2x_keyType;
    private String hr2x_filterConverterFactory;
    private Map<String, String> hr2x_mediaTypeParams;
    private long hr2x_versionRead;
    private int hr2x_lifespanInt;
    private String hr2x_mediaParamValue;
    private byte hr2x_intelligence;
    private long hr2x_long;
    private String hr2x_mediaParamName;
    private List<byte[]> hr2x_converterParams;
    private boolean hr2x_recoverable;
    private byte[] hr2x_value;
    private byte hr2x_branchLength;
    private String hr2x_optionalString;
    private byte[] hr2x_optionalArray;
    private boolean hr2x_bool;
    private byte hr2x_xidLength;
    private byte hr2x_mediaTypeDefinition;
    private Metadata.Builder hr2x_expiration;
    private List<byte[]> hr2x_filterParams;
    private int hr2x_offset;
    private ByteBuf hr2x_chunkBytes;
    private long hr2x_updateValue;
    private byte hr2x_txMarker;
    private boolean hr2x_useRawEvents;
    private int hr2x_chunkLength;
    private long hr2x_timeout;
    private String hr2x_taskName;
    private String hr2x_mediaTypeName;
    private long hr2x_lowerBound;
    private byte[] hr2x_taskParamValue;
    private ByteBuf hr2x_chunkedValue;
    private byte[] hr2x_key;
    private int hr2x_batchSize;
    private HotRodHeader hr2x_header;
    private int hr2x_scope;
    private long hr2x_lifespanLong;
    private Map<String, byte[]> hr2x_taskParams;
    private byte[] hr2x_array;
    private int hr2x_flags;
    private byte[] hr2x_listenerId;
    private byte[] hr2x_segmentMask;
    private byte hr2x_magic;
    private int hr2x_maxIdleInt;
    private boolean hr2x_onePhaseCommit;
    private long hr2x_entryVersion;
    private int hr2x_mediaTypeId;
    private boolean hr2x_includeMetadata;
    private byte hr2x_opCode;
    private Map<byte[], byte[]> hr2x_entryMap;
    private int hr2x_mediaTypeParamsNum;
    private long hr2x_messageId;
    private long hr2x_vLong;
    private List<byte[]> hr2x_filterConverterParams;
    private int hr2x_numKeys;
    private MediaType hr2x_mediaType;
    private byte[] hr2x_branchId;
    private String hr2x_string;
    private byte hr2x_byte;
    private byte[] hr2x_transactionId;
    private MediaType hr2x_mediaTypeDescription;
    private String hr2x_counterName;
    private TransactionWrite hr2x_modification;
    private CounterConfiguration.Builder hr2x_counterConfiguration;
    private int hr2x_topologyId;
    private Set<byte[]> hr2x_keys;
    private XidImpl hr2x_xid;
    private List<TransactionWrite> hr2x_modifications;
    private final boolean accessLogging;
    private Temporal requestStart;
    private boolean deadEnd = false;

    public HotRodDecoder(EmbeddedCacheManager cacheManager, Executor executor, HotRodServer server) {
        super(cacheManager, executor, server);
        server.accessLogging();
        this.accessLogging = HotRodAccessLogging.isEnabled();
    }

    @Override
    protected HotRodHeader getHeader() {
        if (this.accessLogging && this.hr2x_header != null) {
            return new AccessLoggingHeader(this.hr2x_header, null, this.hr2x_key != null ? this.hr2x_key : (byte[])this.hr2x_taskName, this.requestBytes, this.requestStart);
        }
        return this.hr2x_header;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decode(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
        int pos = buf.readerIndex();
        try {
            while (this.switch1_0(buf)) {
            }
        }
        catch (Throwable t) {
            this.exceptionally(t);
        }
        finally {
            this.requestBytes += buf.readerIndex() - pos;
        }
    }

    private boolean switch1_0(ByteBuf buf) throws Exception {
        switch (this.state >> 6) {
            case 0: {
                return this.switch0(buf);
            }
            case 1: {
                return this.switch1(buf);
            }
            case 2: {
                return this.switch2(buf);
            }
            case 3: {
                return this.switch3(buf);
            }
            case 4: {
                return this.switch4(buf);
            }
            case 5: {
                return this.switch5(buf);
            }
            case 6: {
                return this.switch6(buf);
            }
        }
        throw new IllegalStateException();
    }

    private boolean switch0(ByteBuf buf) throws Exception {
        switch (this.state) {
            case 0: {
                this.reset();
                this.state = 1;
            }
            case 1: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_magic = this.hr2x_byte;
                this.state = 2;
            }
            case 2: {
                if (this.accessLogging) {
                    this.requestStart = Instant.now();
                }
                this.state = 3;
            }
            case 3: {
                if (this.hr2x_magic != -96) {
                    this.state = 5;
                    return true;
                }
                this.deadEnd = false;
                this.state = 6;
                return true;
            }
            case 4: {
                if (trace) {
                    log.tracef("Parsed header: %s", this.hr2x_header);
                }
                this.state = 55;
                return true;
            }
            case 5: {
                throw new InvalidMagicIdException("Error reading magic byte or message id: " + this.hr2x_magic);
            }
            case 6: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_messageId = this.hr2x_vLong;
                this.state = 7;
            }
            case 7: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_version = this.hr2x_byte;
                this.state = 8;
            }
            case 8: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_opCode = this.hr2x_byte;
                this.hr2x_operation = HotRodOperation.fromRequestOpCode(this.hr2x_byte);
                this.state = 9;
            }
            case 9: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_cacheName = this.hr2x_string;
                this.state = 10;
            }
            case 10: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_flags = this.hr2x_vInt;
                this.state = 11;
            }
            case 11: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_intelligence = this.hr2x_byte;
                this.state = 12;
            }
            case 12: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_topologyId = this.hr2x_vInt;
                this.state = 13;
            }
            case 13: {
                if (this.hr2x_version < HotRodConstants.VERSION_20) {
                    this.state = 15;
                    return true;
                }
                this.hr2x_txMarker = 0;
                this.state = 14;
            }
            case 14: {
                if (this.hr2x_version >= HotRodConstants.VERSION_28) {
                    this.state = 17;
                    return true;
                }
                this.hr2x_keyType = this.hr2x_mediaType = null;
                this.state = 16;
                return true;
            }
            case 15: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_txMarker = this.hr2x_byte;
                this.state = 14;
                return true;
            }
            case 16: {
                if (this.hr2x_version >= HotRodConstants.VERSION_28) {
                    this.state = 36;
                    return true;
                }
                this.hr2x_valueType = this.hr2x_mediaType = null;
                this.hr2x_header = new HotRodHeader(this.hr2x_operation, this.hr2x_version, this.hr2x_messageId, this.hr2x_cacheName, this.hr2x_flags, this.hr2x_intelligence, this.hr2x_topologyId, this.hr2x_keyType, this.hr2x_valueType);
                this.state = 4;
                return true;
            }
            case 17: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaTypeDefinition = this.hr2x_byte;
                this.state = 18;
            }
            case 18: {
                switch (this.hr2x_mediaTypeDefinition) {
                    case 0: {
                        this.state = 19;
                        return true;
                    }
                    case 1: {
                        this.state = 20;
                        return true;
                    }
                    case 2: {
                        this.state = 28;
                        return true;
                    }
                }
                throw new RequestParsingException("Unknown MediaType definition: " + this.hr2x_mediaTypeDefinition, this.hr2x_version, this.hr2x_messageId);
            }
            case 19: {
                this.hr2x_keyType = this.hr2x_mediaType = (this.hr2x_mediaTypeDescription = MediaType.APPLICATION_UNKNOWN);
                this.state = 16;
                return true;
            }
            case 20: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaTypeId = this.hr2x_vInt;
                this.state = 21;
            }
            case 21: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaTypeParamsNum = this.hr2x_vInt;
                this.state = 23;
                return true;
            }
            case 22: {
                this.hr2x_keyType = this.hr2x_mediaType = (this.hr2x_mediaTypeDescription = MediaTypeIds.getMediaType((Short)((short)this.hr2x_mediaTypeId)).withParameters(this.hr2x_mediaTypeParams));
                this.state = 16;
                return true;
            }
            case 23: {
                this.hr2x_mediaTypeParams = this.allocMap(this.hr2x_mediaTypeParamsNum);
                this.state = 24;
            }
            case 24: {
                if (this.hr2x_mediaTypeParamsNum == 0) {
                    this.state = 22;
                    return true;
                }
                --this.hr2x_mediaTypeParamsNum;
                this.state = 25;
            }
            case 25: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaParamName = this.hr2x_string;
                this.state = 26;
            }
            case 26: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaParamValue = this.hr2x_string;
                this.state = 27;
            }
            case 27: {
                this.hr2x_mediaTypeParams.put(this.hr2x_mediaParamName, this.hr2x_mediaParamValue);
                this.state = 24;
                return true;
            }
            case 28: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaTypeName = this.hr2x_string;
                this.state = 29;
            }
            case 29: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaTypeParamsNum = this.hr2x_vInt;
                this.state = 31;
                return true;
            }
            case 30: {
                this.hr2x_keyType = this.hr2x_mediaType = (this.hr2x_mediaTypeDescription = MediaType.fromString((String)this.hr2x_mediaTypeName).withParameters(this.hr2x_mediaTypeParams));
                this.state = 16;
                return true;
            }
            case 31: {
                this.hr2x_mediaTypeParams = this.allocMap(this.hr2x_mediaTypeParamsNum);
                this.state = 32;
            }
            case 32: {
                if (this.hr2x_mediaTypeParamsNum == 0) {
                    this.state = 30;
                    return true;
                }
                --this.hr2x_mediaTypeParamsNum;
                this.state = 33;
            }
            case 33: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaParamName = this.hr2x_string;
                this.state = 34;
            }
            case 34: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaParamValue = this.hr2x_string;
                this.state = 35;
            }
            case 35: {
                this.hr2x_mediaTypeParams.put(this.hr2x_mediaParamName, this.hr2x_mediaParamValue);
                this.state = 32;
                return true;
            }
            case 36: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaTypeDefinition = this.hr2x_byte;
                this.state = 37;
            }
            case 37: {
                switch (this.hr2x_mediaTypeDefinition) {
                    case 0: {
                        this.state = 38;
                        return true;
                    }
                    case 1: {
                        this.state = 39;
                        return true;
                    }
                    case 2: {
                        this.state = 47;
                        return true;
                    }
                }
                throw new RequestParsingException("Unknown MediaType definition: " + this.hr2x_mediaTypeDefinition, this.hr2x_version, this.hr2x_messageId);
            }
            case 38: {
                this.hr2x_valueType = this.hr2x_mediaType = (this.hr2x_mediaTypeDescription = MediaType.APPLICATION_UNKNOWN);
                this.hr2x_header = new HotRodHeader(this.hr2x_operation, this.hr2x_version, this.hr2x_messageId, this.hr2x_cacheName, this.hr2x_flags, this.hr2x_intelligence, this.hr2x_topologyId, this.hr2x_keyType, this.hr2x_valueType);
                this.state = 4;
                return true;
            }
            case 39: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaTypeId = this.hr2x_vInt;
                this.state = 40;
            }
            case 40: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaTypeParamsNum = this.hr2x_vInt;
                this.state = 42;
                return true;
            }
            case 41: {
                this.hr2x_valueType = this.hr2x_mediaType = (this.hr2x_mediaTypeDescription = MediaTypeIds.getMediaType((Short)((short)this.hr2x_mediaTypeId)).withParameters(this.hr2x_mediaTypeParams));
                this.hr2x_header = new HotRodHeader(this.hr2x_operation, this.hr2x_version, this.hr2x_messageId, this.hr2x_cacheName, this.hr2x_flags, this.hr2x_intelligence, this.hr2x_topologyId, this.hr2x_keyType, this.hr2x_valueType);
                this.state = 4;
                return true;
            }
            case 42: {
                this.hr2x_mediaTypeParams = this.allocMap(this.hr2x_mediaTypeParamsNum);
                this.state = 43;
            }
            case 43: {
                if (this.hr2x_mediaTypeParamsNum == 0) {
                    this.state = 41;
                    return true;
                }
                --this.hr2x_mediaTypeParamsNum;
                this.state = 44;
            }
            case 44: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaParamName = this.hr2x_string;
                this.state = 45;
            }
            case 45: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaParamValue = this.hr2x_string;
                this.state = 46;
            }
            case 46: {
                this.hr2x_mediaTypeParams.put(this.hr2x_mediaParamName, this.hr2x_mediaParamValue);
                this.state = 43;
                return true;
            }
            case 47: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaTypeName = this.hr2x_string;
                this.state = 48;
            }
            case 48: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaTypeParamsNum = this.hr2x_vInt;
                this.state = 50;
                return true;
            }
            case 49: {
                this.hr2x_valueType = this.hr2x_mediaType = (this.hr2x_mediaTypeDescription = MediaType.fromString((String)this.hr2x_mediaTypeName).withParameters(this.hr2x_mediaTypeParams));
                this.hr2x_header = new HotRodHeader(this.hr2x_operation, this.hr2x_version, this.hr2x_messageId, this.hr2x_cacheName, this.hr2x_flags, this.hr2x_intelligence, this.hr2x_topologyId, this.hr2x_keyType, this.hr2x_valueType);
                this.state = 4;
                return true;
            }
            case 50: {
                this.hr2x_mediaTypeParams = this.allocMap(this.hr2x_mediaTypeParamsNum);
                this.state = 51;
            }
            case 51: {
                if (this.hr2x_mediaTypeParamsNum == 0) {
                    this.state = 49;
                    return true;
                }
                --this.hr2x_mediaTypeParamsNum;
                this.state = 52;
            }
            case 52: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaParamName = this.hr2x_string;
                this.state = 53;
            }
            case 53: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaParamValue = this.hr2x_string;
                this.state = 54;
            }
            case 54: {
                this.hr2x_mediaTypeParams.put(this.hr2x_mediaParamName, this.hr2x_mediaParamValue);
                this.state = 51;
                return true;
            }
            case 55: {
                return this.userSwitch55();
            }
            case 56: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 57;
            }
            case 57: {
                if (this.hr2x_version < HotRodConstants.VERSION_22) {
                    this.state = 59;
                    return true;
                }
                if (this.hr2x_version >= HotRodConstants.VERSION_30) {
                    this.state = 61;
                    return true;
                }
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 66;
                return true;
            }
            case 58: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_value = this.hr2x_array;
                this.state = 70;
                return true;
            }
            case 59: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanInt = this.hr2x_vInt;
                this.state = 60;
            }
            case 60: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleInt = this.hr2x_vInt;
                this.hr2x_expiration = this.server.buildMetadata2x(this.defaultExpiration(this.hr2x_lifespanInt, this.hr2x_flags, ProtocolFlag.DefaultLifespan), TimeUnitValue.SECONDS, this.defaultExpiration(this.hr2x_maxIdleInt, this.hr2x_flags, ProtocolFlag.DefaultMaxIdle), TimeUnitValue.SECONDS);
                this.state = 58;
                return true;
            }
            case 61: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 62;
            }
            case 62: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 64;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 63;
            }
            case 63: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 65;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 58;
                return true;
            }
        }
        return true;
    }

    private boolean switch1(ByteBuf buf) throws Exception {
        switch (this.state) {
            case 64: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 63;
                return true;
            }
            case 65: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 58;
                return true;
            }
            case 66: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 68;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 67;
            }
            case 67: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 69;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 58;
                return true;
            }
            case 68: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 67;
                return true;
            }
            case 69: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 58;
                return true;
            }
            case 70: {
                this.cacheProcessor.put(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key, this.hr2x_value, this.hr2x_expiration);
                this.state = 0;
                return true;
            }
            case 71: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 72;
            }
            case 72: {
                this.cacheProcessor.get(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key);
                this.state = 0;
                return true;
            }
            case 73: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 74;
            }
            case 74: {
                if (this.hr2x_version < HotRodConstants.VERSION_22) {
                    this.state = 76;
                    return true;
                }
                if (this.hr2x_version >= HotRodConstants.VERSION_30) {
                    this.state = 78;
                    return true;
                }
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 83;
                return true;
            }
            case 75: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_value = this.hr2x_array;
                this.state = 87;
                return true;
            }
            case 76: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanInt = this.hr2x_vInt;
                this.state = 77;
            }
            case 77: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleInt = this.hr2x_vInt;
                this.hr2x_expiration = this.server.buildMetadata2x(this.defaultExpiration(this.hr2x_lifespanInt, this.hr2x_flags, ProtocolFlag.DefaultLifespan), TimeUnitValue.SECONDS, this.defaultExpiration(this.hr2x_maxIdleInt, this.hr2x_flags, ProtocolFlag.DefaultMaxIdle), TimeUnitValue.SECONDS);
                this.state = 75;
                return true;
            }
            case 78: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 79;
            }
            case 79: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 81;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 80;
            }
            case 80: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 82;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 75;
                return true;
            }
            case 81: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 80;
                return true;
            }
            case 82: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 75;
                return true;
            }
            case 83: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 85;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 84;
            }
            case 84: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 86;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 75;
                return true;
            }
            case 85: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 84;
                return true;
            }
            case 86: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 75;
                return true;
            }
            case 87: {
                this.cacheProcessor.putIfAbsent(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key, this.hr2x_value, this.hr2x_expiration);
                this.state = 0;
                return true;
            }
            case 88: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 89;
            }
            case 89: {
                if (this.hr2x_version < HotRodConstants.VERSION_22) {
                    this.state = 91;
                    return true;
                }
                if (this.hr2x_version >= HotRodConstants.VERSION_30) {
                    this.state = 93;
                    return true;
                }
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 98;
                return true;
            }
            case 90: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_value = this.hr2x_array;
                this.state = 102;
                return true;
            }
            case 91: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanInt = this.hr2x_vInt;
                this.state = 92;
            }
            case 92: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleInt = this.hr2x_vInt;
                this.hr2x_expiration = this.server.buildMetadata2x(this.defaultExpiration(this.hr2x_lifespanInt, this.hr2x_flags, ProtocolFlag.DefaultLifespan), TimeUnitValue.SECONDS, this.defaultExpiration(this.hr2x_maxIdleInt, this.hr2x_flags, ProtocolFlag.DefaultMaxIdle), TimeUnitValue.SECONDS);
                this.state = 90;
                return true;
            }
            case 93: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 94;
            }
            case 94: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 96;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 95;
            }
            case 95: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 97;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 90;
                return true;
            }
            case 96: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 95;
                return true;
            }
            case 97: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 90;
                return true;
            }
            case 98: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 100;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 99;
            }
            case 99: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 101;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 90;
                return true;
            }
            case 100: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 99;
                return true;
            }
            case 101: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 90;
                return true;
            }
            case 102: {
                this.cacheProcessor.replace(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key, this.hr2x_value, this.hr2x_expiration);
                this.state = 0;
                return true;
            }
            case 103: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 104;
            }
            case 104: {
                if (this.hr2x_version < HotRodConstants.VERSION_22) {
                    this.state = 106;
                    return true;
                }
                if (this.hr2x_version >= HotRodConstants.VERSION_30) {
                    this.state = 108;
                    return true;
                }
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 113;
                return true;
            }
            case 105: {
                int pos = buf.readerIndex();
                this.hr2x_long = Intrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_entryVersion = this.hr2x_long;
                this.state = 117;
                return true;
            }
            case 106: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanInt = this.hr2x_vInt;
                this.state = 107;
            }
            case 107: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleInt = this.hr2x_vInt;
                this.hr2x_expiration = this.server.buildMetadata2x(this.defaultExpiration(this.hr2x_lifespanInt, this.hr2x_flags, ProtocolFlag.DefaultLifespan), TimeUnitValue.SECONDS, this.defaultExpiration(this.hr2x_maxIdleInt, this.hr2x_flags, ProtocolFlag.DefaultMaxIdle), TimeUnitValue.SECONDS);
                this.state = 105;
                return true;
            }
            case 108: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 109;
            }
            case 109: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 111;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 110;
            }
            case 110: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 112;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 105;
                return true;
            }
            case 111: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 110;
                return true;
            }
            case 112: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 105;
                return true;
            }
            case 113: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 115;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 114;
            }
            case 114: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 116;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 105;
                return true;
            }
            case 115: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 114;
                return true;
            }
            case 116: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 105;
                return true;
            }
            case 117: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_value = this.hr2x_array;
                this.state = 118;
            }
            case 118: {
                this.cacheProcessor.replaceIfUnmodified(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key, this.hr2x_entryVersion, this.hr2x_value, this.hr2x_expiration);
                this.state = 0;
                return true;
            }
            case 119: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 120;
            }
            case 120: {
                this.cacheProcessor.remove(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key);
                this.state = 0;
                return true;
            }
            case 121: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 122;
            }
            case 122: {
                int pos = buf.readerIndex();
                this.hr2x_long = Intrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_entryVersion = this.hr2x_long;
                this.state = 123;
            }
            case 123: {
                this.cacheProcessor.removeIfUnmodified(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key, this.hr2x_entryVersion);
                this.state = 0;
                return true;
            }
            case 124: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 125;
            }
            case 125: {
                this.cacheProcessor.containsKey(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key);
                this.state = 0;
                return true;
            }
            case 126: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 127;
            }
            case 127: {
                this.cacheProcessor.get(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key);
                this.state = 0;
                return true;
            }
        }
        return true;
    }

    private boolean switch2(ByteBuf buf) throws Exception {
        switch (this.state) {
            case 128: {
                this.cacheProcessor.clear(this.getHeader(), this.auth.getSubject(this.hr2x_operation));
                this.state = 0;
                return true;
            }
            case 129: {
                this.cacheProcessor.stats(this.getHeader(), this.auth.getSubject(this.hr2x_operation));
                this.state = 0;
                return true;
            }
            case 130: {
                this.cacheProcessor.ping(this.getHeader(), this.auth.getSubject(this.hr2x_operation));
                this.state = 0;
                return true;
            }
            case 131: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_numKeys = this.hr2x_vInt;
                this.state = 132;
            }
            case 132: {
                this.cacheProcessor.bulkGet(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_numKeys);
                this.state = 0;
                return true;
            }
            case 133: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 134;
            }
            case 134: {
                this.cacheProcessor.getWithMetadata(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key, 0);
                this.state = 0;
                return true;
            }
            case 135: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_scope = this.hr2x_vInt;
                this.state = 136;
            }
            case 136: {
                this.cacheProcessor.bulkGetKeys(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_scope);
                this.state = 0;
                return true;
            }
            case 137: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_queryBytes = this.hr2x_array;
                this.state = 138;
            }
            case 138: {
                this.cacheProcessor.query(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_queryBytes);
                this.state = 0;
                return true;
            }
            case 139: {
                this.auth.authMechList(this.hr2x_header);
                this.state = 0;
                return true;
            }
            case 140: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_authMech = this.hr2x_string;
                this.state = 141;
            }
            case 141: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_authResponse = this.hr2x_array;
                this.state = 142;
            }
            case 142: {
                this.auth.auth(this.hr2x_header, this.hr2x_authMech, this.hr2x_authResponse);
                this.state = 0;
                return true;
            }
            case 143: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_listenerId = this.hr2x_array;
                this.state = 144;
            }
            case 144: {
                int pos = buf.readerIndex();
                this.hr2x_bool = Intrinsics.bool(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_includeCurrentState = this.hr2x_bool;
                this.state = 145;
            }
            case 145: {
                if (this.hr2x_version >= HotRodConstants.VERSION_21) {
                    this.state = 147;
                    return true;
                }
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_filterFactory = this.hr2x_string;
                this.state = 162;
                return true;
            }
            case 146: {
                if (this.hr2x_version >= HotRodConstants.VERSION_26) {
                    this.state = 176;
                    return true;
                }
                this.hr2x_listenerInterests = 0;
                this.state = 175;
                return true;
            }
            case 147: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_filterFactory = this.hr2x_string;
                this.state = 148;
            }
            case 148: {
                if (!this.hr2x_filterFactory.isEmpty()) {
                    this.state = 150;
                    return true;
                }
                this.hr2x_filterParams = null;
                this.state = 149;
            }
            case 149: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_converterFactory = this.hr2x_string;
                this.state = 155;
                return true;
            }
            case 150: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_numParams = this.hr2x_byte;
                this.state = 151;
            }
            case 151: {
                this.hr2x_filterParams = this.allocList(this.hr2x_numParams);
                this.state = 152;
            }
            case 152: {
                if (this.hr2x_numParams == 0) {
                    this.state = 149;
                    return true;
                }
                this.hr2x_numParams = (byte)(this.hr2x_numParams - 1);
                this.state = 153;
            }
            case 153: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_param = this.hr2x_array;
                this.state = 154;
            }
            case 154: {
                this.hr2x_filterParams.add(this.hr2x_param);
                this.state = 152;
                return true;
            }
            case 155: {
                if (!this.hr2x_converterFactory.isEmpty()) {
                    this.state = 157;
                    return true;
                }
                this.hr2x_converterParams = null;
                this.state = 156;
            }
            case 156: {
                int pos = buf.readerIndex();
                this.hr2x_bool = Intrinsics.bool(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_useRawEvents = this.hr2x_bool;
                this.state = 146;
                return true;
            }
            case 157: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_numParams = this.hr2x_byte;
                this.state = 158;
            }
            case 158: {
                this.hr2x_converterParams = this.allocList(this.hr2x_numParams);
                this.state = 159;
            }
            case 159: {
                if (this.hr2x_numParams == 0) {
                    this.state = 156;
                    return true;
                }
                this.hr2x_numParams = (byte)(this.hr2x_numParams - 1);
                this.state = 160;
            }
            case 160: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_param = this.hr2x_array;
                this.state = 161;
            }
            case 161: {
                this.hr2x_converterParams.add(this.hr2x_param);
                this.state = 159;
                return true;
            }
            case 162: {
                if (!this.hr2x_filterFactory.isEmpty()) {
                    this.state = 164;
                    return true;
                }
                this.hr2x_filterParams = null;
                this.state = 163;
            }
            case 163: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_converterFactory = this.hr2x_string;
                this.state = 169;
                return true;
            }
            case 164: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_numParams = this.hr2x_byte;
                this.state = 165;
            }
            case 165: {
                this.hr2x_filterParams = this.allocList(this.hr2x_numParams);
                this.state = 166;
            }
            case 166: {
                if (this.hr2x_numParams == 0) {
                    this.state = 163;
                    return true;
                }
                this.hr2x_numParams = (byte)(this.hr2x_numParams - 1);
                this.state = 167;
            }
            case 167: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_param = this.hr2x_array;
                this.state = 168;
            }
            case 168: {
                this.hr2x_filterParams.add(this.hr2x_param);
                this.state = 166;
                return true;
            }
            case 169: {
                if (!this.hr2x_converterFactory.isEmpty()) {
                    this.state = 170;
                    return true;
                }
                this.hr2x_converterParams = null;
                this.state = 146;
                return true;
            }
            case 170: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_numParams = this.hr2x_byte;
                this.state = 171;
            }
            case 171: {
                this.hr2x_converterParams = this.allocList(this.hr2x_numParams);
                this.state = 172;
            }
            case 172: {
                if (this.hr2x_numParams == 0) {
                    this.state = 146;
                    return true;
                }
                this.hr2x_numParams = (byte)(this.hr2x_numParams - 1);
                this.state = 173;
            }
            case 173: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_param = this.hr2x_array;
                this.state = 174;
            }
            case 174: {
                this.hr2x_converterParams.add(this.hr2x_param);
                this.state = 172;
                return true;
            }
            case 175: {
                this.cacheProcessor.addClientListener(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_listenerId, this.hr2x_includeCurrentState, this.hr2x_filterFactory, this.hr2x_filterParams, this.hr2x_converterFactory, this.hr2x_converterParams, this.hr2x_useRawEvents, this.hr2x_listenerInterests);
                this.state = 0;
                return true;
            }
            case 176: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_listenerInterests = this.hr2x_vInt;
                this.state = 175;
                return true;
            }
            case 177: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_listenerId = this.hr2x_array;
                this.state = 178;
            }
            case 178: {
                this.cacheProcessor.removeClientListener(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_listenerId);
                this.state = 0;
                return true;
            }
            case 179: {
                this.cacheProcessor.size(this.getHeader(), this.auth.getSubject(this.hr2x_operation));
                this.state = 0;
                return true;
            }
            case 180: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_taskName = this.hr2x_string;
                this.state = 181;
            }
            case 181: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_numParams = this.hr2x_byte;
                this.state = 183;
                return true;
            }
            case 182: {
                this.taskProcessor.exec(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_taskName, this.hr2x_taskParams);
                this.state = 0;
                return true;
            }
            case 183: {
                this.hr2x_taskParams = this.allocMap(this.hr2x_numParams);
                this.state = 184;
            }
            case 184: {
                if (this.hr2x_numParams == 0) {
                    this.state = 182;
                    return true;
                }
                this.hr2x_numParams = (byte)(this.hr2x_numParams - 1);
                this.state = 185;
            }
            case 185: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_taskParam = this.hr2x_string;
                this.state = 186;
            }
            case 186: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_taskParamValue = this.hr2x_array;
                this.state = 187;
            }
            case 187: {
                this.hr2x_taskParams.put(this.hr2x_taskParam, this.hr2x_taskParamValue);
                this.state = 184;
                return true;
            }
            case 188: {
                if (this.hr2x_version < HotRodConstants.VERSION_22) {
                    this.state = 190;
                    return true;
                }
                if (this.hr2x_version >= HotRodConstants.VERSION_30) {
                    this.state = 192;
                    return true;
                }
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 197;
                return true;
            }
            case 189: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_numEntries = this.hr2x_vInt;
                this.state = 202;
                return true;
            }
            case 190: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanInt = this.hr2x_vInt;
                this.state = 191;
            }
            case 191: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleInt = this.hr2x_vInt;
                this.hr2x_expiration = this.server.buildMetadata2x(this.defaultExpiration(this.hr2x_lifespanInt, this.hr2x_flags, ProtocolFlag.DefaultLifespan), TimeUnitValue.SECONDS, this.defaultExpiration(this.hr2x_maxIdleInt, this.hr2x_flags, ProtocolFlag.DefaultMaxIdle), TimeUnitValue.SECONDS);
                this.state = 189;
                return true;
            }
        }
        return true;
    }

    private boolean switch3(ByteBuf buf) throws Exception {
        switch (this.state) {
            case 192: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 193;
            }
            case 193: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 195;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 194;
            }
            case 194: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 196;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 189;
                return true;
            }
            case 195: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 194;
                return true;
            }
            case 196: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 189;
                return true;
            }
            case 197: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 199;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 198;
            }
            case 198: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 200;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 189;
                return true;
            }
            case 199: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 198;
                return true;
            }
            case 200: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 189;
                return true;
            }
            case 201: {
                this.cacheProcessor.putAll(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_entryMap, this.hr2x_expiration);
                this.state = 0;
                return true;
            }
            case 202: {
                this.hr2x_entryMap = this.allocMap(this.hr2x_numEntries);
                this.state = 203;
            }
            case 203: {
                if (this.hr2x_numEntries == 0) {
                    this.state = 201;
                    return true;
                }
                --this.hr2x_numEntries;
                this.state = 204;
            }
            case 204: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 205;
            }
            case 205: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_value = this.hr2x_array;
                this.state = 206;
            }
            case 206: {
                this.hr2x_entryMap.put(this.hr2x_key, this.hr2x_value);
                this.state = 203;
                return true;
            }
            case 207: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_numKeys = this.hr2x_vInt;
                this.state = 209;
                return true;
            }
            case 208: {
                this.cacheProcessor.getAll(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_keys);
                this.state = 0;
                return true;
            }
            case 209: {
                this.hr2x_keys = this.allocSet(this.hr2x_numKeys);
                this.state = 210;
            }
            case 210: {
                if (this.hr2x_numKeys == 0) {
                    this.state = 208;
                    return true;
                }
                --this.hr2x_numKeys;
                this.state = 211;
            }
            case 211: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 212;
            }
            case 212: {
                this.hr2x_keys.add(this.hr2x_key);
                this.state = 210;
                return true;
            }
            case 213: {
                int pos = buf.readerIndex();
                this.hr2x_optionalArray = Intrinsics.optionalArray(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_segmentMask = this.hr2x_optionalArray;
                this.state = 214;
            }
            case 214: {
                int pos = buf.readerIndex();
                this.hr2x_optionalString = Intrinsics.optionalString(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_filterConverterFactory = this.hr2x_optionalString;
                this.state = 215;
            }
            case 215: {
                if (this.hr2x_filterConverterFactory != null) {
                    this.state = 217;
                    return true;
                }
                this.hr2x_filterConverterParams = null;
                this.state = 216;
            }
            case 216: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_batchSize = this.hr2x_vInt;
                this.state = 222;
                return true;
            }
            case 217: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_numParams = this.hr2x_byte;
                this.state = 218;
            }
            case 218: {
                this.hr2x_filterConverterParams = this.allocList(this.hr2x_numParams);
                this.state = 219;
            }
            case 219: {
                if (this.hr2x_numParams == 0) {
                    this.state = 216;
                    return true;
                }
                this.hr2x_numParams = (byte)(this.hr2x_numParams - 1);
                this.state = 220;
            }
            case 220: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_param = this.hr2x_array;
                this.state = 221;
            }
            case 221: {
                this.hr2x_filterConverterParams.add(this.hr2x_param);
                this.state = 219;
                return true;
            }
            case 222: {
                if (this.hr2x_version >= HotRodConstants.VERSION_24) {
                    this.state = 224;
                    return true;
                }
                this.hr2x_includeMetadata = false;
                this.state = 223;
            }
            case 223: {
                this.cacheProcessor.iterationStart(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_segmentMask, this.hr2x_filterConverterFactory, this.hr2x_filterConverterParams, this.hr2x_batchSize, this.hr2x_includeMetadata);
                this.state = 0;
                return true;
            }
            case 224: {
                int pos = buf.readerIndex();
                this.hr2x_bool = Intrinsics.bool(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_includeMetadata = this.hr2x_bool;
                this.state = 223;
                return true;
            }
            case 225: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_iterationId = this.hr2x_string;
                this.state = 226;
            }
            case 226: {
                this.cacheProcessor.iterationNext(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_iterationId);
                this.state = 0;
                return true;
            }
            case 227: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_iterationId = this.hr2x_string;
                this.state = 228;
            }
            case 228: {
                this.cacheProcessor.iterationEnd(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_iterationId);
                this.state = 0;
                return true;
            }
            case 229: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 230;
            }
            case 230: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_offset = this.hr2x_vInt;
                this.state = 231;
            }
            case 231: {
                this.cacheProcessor.getWithMetadata(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key, this.hr2x_offset);
                this.state = 0;
                return true;
            }
            case 232: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 233;
            }
            case 233: {
                if (this.hr2x_version < HotRodConstants.VERSION_22) {
                    this.state = 235;
                    return true;
                }
                if (this.hr2x_version >= HotRodConstants.VERSION_30) {
                    this.state = 237;
                    return true;
                }
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 242;
                return true;
            }
            case 234: {
                int pos = buf.readerIndex();
                this.hr2x_long = Intrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_entryVersion = this.hr2x_long;
                this.state = 246;
                return true;
            }
            case 235: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanInt = this.hr2x_vInt;
                this.state = 236;
            }
            case 236: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleInt = this.hr2x_vInt;
                this.hr2x_expiration = this.server.buildMetadata2x(this.defaultExpiration(this.hr2x_lifespanInt, this.hr2x_flags, ProtocolFlag.DefaultLifespan), TimeUnitValue.SECONDS, this.defaultExpiration(this.hr2x_maxIdleInt, this.hr2x_flags, ProtocolFlag.DefaultMaxIdle), TimeUnitValue.SECONDS);
                this.state = 234;
                return true;
            }
            case 237: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 238;
            }
            case 238: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 240;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 239;
            }
            case 239: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 241;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 234;
                return true;
            }
            case 240: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 239;
                return true;
            }
            case 241: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 234;
                return true;
            }
            case 242: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 244;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 243;
            }
            case 243: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 245;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 234;
                return true;
            }
            case 244: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 243;
                return true;
            }
            case 245: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 234;
                return true;
            }
            case 246: {
                this.hr2x_chunkedValue = this.cacheProcessor.channel().alloc().buffer();
                this.hr2x_chunkLength = 1;
                this.state = 248;
                return true;
            }
            case 247: {
                this.cacheProcessor.putStream(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key, this.hr2x_chunkedValue, this.hr2x_entryVersion, this.hr2x_expiration);
                this.state = 0;
                return true;
            }
            case 248: {
                if (this.hr2x_chunkLength == 0) {
                    this.state = 247;
                    return true;
                }
                --this.hr2x_chunkLength;
                this.state = 249;
            }
            case 249: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_chunkLength = this.hr2x_vInt;
                this.state = 250;
            }
            case 250: {
                if (this.hr2x_chunkLength > 0) {
                    this.state = 252;
                    return true;
                }
                this.hr2x_chunkBytes = this.cacheProcessor.channel().alloc().buffer(0, 0);
                this.state = 251;
            }
            case 251: {
                this.hr2x_chunkedValue.writeBytes(this.hr2x_chunkBytes, this.hr2x_chunkBytes.readerIndex() - this.hr2x_chunkLength, this.hr2x_chunkLength);
                this.state = 248;
                return true;
            }
            case 252: {
                int pos = buf.readerIndex();
                this.hr2x_readable = Intrinsics.readable(buf, this.hr2x_chunkLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_chunkBytes = this.hr2x_readable;
                this.state = 251;
                return true;
            }
            case 253: {
                int pos = buf.readerIndex();
                this.hr2x_signedVInt = Intrinsics.signedVInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_xidFormat = this.hr2x_signedVInt;
                this.state = 255;
                return true;
            }
            case 254: {
                int pos = buf.readerIndex();
                this.hr2x_bool = Intrinsics.bool(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_onePhaseCommit = this.hr2x_bool;
                this.state = 261;
                return true;
            }
            case 255: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_xidLength = this.hr2x_byte;
                this.state = 256;
            }
        }
        return true;
    }

    private boolean switch4(ByteBuf buf) throws Exception {
        switch (this.state) {
            case 256: {
                if (this.hr2x_xidLength > 0) {
                    this.state = 258;
                    return true;
                }
                this.hr2x_transactionId = Util.EMPTY_BYTE_ARRAY;
                this.state = 257;
            }
            case 257: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_branchLength = this.hr2x_byte;
                this.state = 259;
                return true;
            }
            case 258: {
                int pos = buf.readerIndex();
                this.hr2x_fixedArray = Intrinsics.fixedArray(buf, this.hr2x_xidLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_transactionId = this.hr2x_fixedArray;
                this.state = 257;
                return true;
            }
            case 259: {
                if (this.hr2x_branchLength > 0) {
                    this.state = 260;
                    return true;
                }
                this.hr2x_branchId = Util.EMPTY_BYTE_ARRAY;
                this.hr2x_xid = XidImpl.create((int)this.hr2x_xidFormat, (byte[])this.hr2x_transactionId, (byte[])this.hr2x_branchId);
                this.state = 254;
                return true;
            }
            case 260: {
                int pos = buf.readerIndex();
                this.hr2x_fixedArray = Intrinsics.fixedArray(buf, this.hr2x_branchLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_branchId = this.hr2x_fixedArray;
                this.hr2x_xid = XidImpl.create((int)this.hr2x_xidFormat, (byte[])this.hr2x_transactionId, (byte[])this.hr2x_branchId);
                this.state = 254;
                return true;
            }
            case 261: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_numModifications = this.hr2x_vInt;
                this.state = 263;
                return true;
            }
            case 262: {
                this.cacheProcessor.prepareTransaction(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_xid, this.hr2x_onePhaseCommit, this.hr2x_modifications, false, 60000L);
                this.state = 0;
                return true;
            }
            case 263: {
                this.hr2x_modifications = this.allocList(this.hr2x_numModifications);
                this.state = 264;
            }
            case 264: {
                if (this.hr2x_numModifications == 0) {
                    this.state = 262;
                    return true;
                }
                --this.hr2x_numModifications;
                this.state = 265;
            }
            case 265: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 267;
                return true;
            }
            case 266: {
                this.hr2x_modifications.add(this.hr2x_modification);
                this.state = 264;
                return true;
            }
            case 267: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_controlByte = this.hr2x_byte;
                this.state = 268;
            }
            case 268: {
                if (!ControlByte.NOT_READ.hasFlag(this.hr2x_controlByte) && !ControlByte.NON_EXISTING.hasFlag(this.hr2x_controlByte)) {
                    this.state = 270;
                    return true;
                }
                this.hr2x_versionRead = 0L;
                this.state = 269;
            }
            case 269: {
                if (!ControlByte.REMOVE_OP.hasFlag(this.hr2x_controlByte)) {
                    this.state = 271;
                    return true;
                }
                this.hr2x_modification = new TransactionWrite(this.hr2x_key, this.hr2x_versionRead, this.hr2x_controlByte, this.hr2x_value, this.hr2x_expiration);
                this.state = 266;
                return true;
            }
            case 270: {
                int pos = buf.readerIndex();
                this.hr2x_long = Intrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_versionRead = this.hr2x_entryVersion = this.hr2x_long;
                this.state = 269;
                return true;
            }
            case 271: {
                if (this.hr2x_version < HotRodConstants.VERSION_22) {
                    this.state = 273;
                    return true;
                }
                if (this.hr2x_version >= HotRodConstants.VERSION_30) {
                    this.state = 275;
                    return true;
                }
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 280;
                return true;
            }
            case 272: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_value = this.hr2x_array;
                this.hr2x_modification = new TransactionWrite(this.hr2x_key, this.hr2x_versionRead, this.hr2x_controlByte, this.hr2x_value, this.hr2x_expiration);
                this.state = 266;
                return true;
            }
            case 273: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanInt = this.hr2x_vInt;
                this.state = 274;
            }
            case 274: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleInt = this.hr2x_vInt;
                this.hr2x_expiration = this.server.buildMetadata2x(this.defaultExpiration(this.hr2x_lifespanInt, this.hr2x_flags, ProtocolFlag.DefaultLifespan), TimeUnitValue.SECONDS, this.defaultExpiration(this.hr2x_maxIdleInt, this.hr2x_flags, ProtocolFlag.DefaultMaxIdle), TimeUnitValue.SECONDS);
                this.state = 272;
                return true;
            }
            case 275: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 276;
            }
            case 276: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 278;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 277;
            }
            case 277: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 279;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 272;
                return true;
            }
            case 278: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 277;
                return true;
            }
            case 279: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 272;
                return true;
            }
            case 280: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 282;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 281;
            }
            case 281: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 283;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 272;
                return true;
            }
            case 282: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 281;
                return true;
            }
            case 283: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 272;
                return true;
            }
            case 284: {
                int pos = buf.readerIndex();
                this.hr2x_signedVInt = Intrinsics.signedVInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_xidFormat = this.hr2x_signedVInt;
                this.state = 286;
                return true;
            }
            case 285: {
                this.cacheProcessor.commitTransaction(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_xid);
                this.state = 0;
                return true;
            }
            case 286: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_xidLength = this.hr2x_byte;
                this.state = 287;
            }
            case 287: {
                if (this.hr2x_xidLength > 0) {
                    this.state = 289;
                    return true;
                }
                this.hr2x_transactionId = Util.EMPTY_BYTE_ARRAY;
                this.state = 288;
            }
            case 288: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_branchLength = this.hr2x_byte;
                this.state = 290;
                return true;
            }
            case 289: {
                int pos = buf.readerIndex();
                this.hr2x_fixedArray = Intrinsics.fixedArray(buf, this.hr2x_xidLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_transactionId = this.hr2x_fixedArray;
                this.state = 288;
                return true;
            }
            case 290: {
                if (this.hr2x_branchLength > 0) {
                    this.state = 291;
                    return true;
                }
                this.hr2x_branchId = Util.EMPTY_BYTE_ARRAY;
                this.hr2x_xid = XidImpl.create((int)this.hr2x_xidFormat, (byte[])this.hr2x_transactionId, (byte[])this.hr2x_branchId);
                this.state = 285;
                return true;
            }
            case 291: {
                int pos = buf.readerIndex();
                this.hr2x_fixedArray = Intrinsics.fixedArray(buf, this.hr2x_branchLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_branchId = this.hr2x_fixedArray;
                this.hr2x_xid = XidImpl.create((int)this.hr2x_xidFormat, (byte[])this.hr2x_transactionId, (byte[])this.hr2x_branchId);
                this.state = 285;
                return true;
            }
            case 292: {
                int pos = buf.readerIndex();
                this.hr2x_signedVInt = Intrinsics.signedVInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_xidFormat = this.hr2x_signedVInt;
                this.state = 294;
                return true;
            }
            case 293: {
                this.cacheProcessor.rollbackTransaction(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_xid);
                this.state = 0;
                return true;
            }
            case 294: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_xidLength = this.hr2x_byte;
                this.state = 295;
            }
            case 295: {
                if (this.hr2x_xidLength > 0) {
                    this.state = 297;
                    return true;
                }
                this.hr2x_transactionId = Util.EMPTY_BYTE_ARRAY;
                this.state = 296;
            }
            case 296: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_branchLength = this.hr2x_byte;
                this.state = 298;
                return true;
            }
            case 297: {
                int pos = buf.readerIndex();
                this.hr2x_fixedArray = Intrinsics.fixedArray(buf, this.hr2x_xidLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_transactionId = this.hr2x_fixedArray;
                this.state = 296;
                return true;
            }
            case 298: {
                if (this.hr2x_branchLength > 0) {
                    this.state = 299;
                    return true;
                }
                this.hr2x_branchId = Util.EMPTY_BYTE_ARRAY;
                this.hr2x_xid = XidImpl.create((int)this.hr2x_xidFormat, (byte[])this.hr2x_transactionId, (byte[])this.hr2x_branchId);
                this.state = 293;
                return true;
            }
            case 299: {
                int pos = buf.readerIndex();
                this.hr2x_fixedArray = Intrinsics.fixedArray(buf, this.hr2x_branchLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_branchId = this.hr2x_fixedArray;
                this.hr2x_xid = XidImpl.create((int)this.hr2x_xidFormat, (byte[])this.hr2x_transactionId, (byte[])this.hr2x_branchId);
                this.state = 293;
                return true;
            }
            case 300: {
                int pos = buf.readerIndex();
                this.hr2x_signedVInt = Intrinsics.signedVInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_xidFormat = this.hr2x_signedVInt;
                this.state = 302;
                return true;
            }
            case 301: {
                this.cacheProcessor.forgetTransaction(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_xid);
                this.state = 0;
                return true;
            }
            case 302: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_xidLength = this.hr2x_byte;
                this.state = 303;
            }
            case 303: {
                if (this.hr2x_xidLength > 0) {
                    this.state = 305;
                    return true;
                }
                this.hr2x_transactionId = Util.EMPTY_BYTE_ARRAY;
                this.state = 304;
            }
            case 304: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_branchLength = this.hr2x_byte;
                this.state = 306;
                return true;
            }
            case 305: {
                int pos = buf.readerIndex();
                this.hr2x_fixedArray = Intrinsics.fixedArray(buf, this.hr2x_xidLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_transactionId = this.hr2x_fixedArray;
                this.state = 304;
                return true;
            }
            case 306: {
                if (this.hr2x_branchLength > 0) {
                    this.state = 307;
                    return true;
                }
                this.hr2x_branchId = Util.EMPTY_BYTE_ARRAY;
                this.hr2x_xid = XidImpl.create((int)this.hr2x_xidFormat, (byte[])this.hr2x_transactionId, (byte[])this.hr2x_branchId);
                this.state = 301;
                return true;
            }
            case 307: {
                int pos = buf.readerIndex();
                this.hr2x_fixedArray = Intrinsics.fixedArray(buf, this.hr2x_branchLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_branchId = this.hr2x_fixedArray;
                this.hr2x_xid = XidImpl.create((int)this.hr2x_xidFormat, (byte[])this.hr2x_transactionId, (byte[])this.hr2x_branchId);
                this.state = 301;
                return true;
            }
            case 308: {
                this.cacheProcessor.getPreparedTransactions(this.getHeader(), this.auth.getSubject(this.hr2x_operation));
                this.state = 0;
                return true;
            }
            case 309: {
                int pos = buf.readerIndex();
                this.hr2x_signedVInt = Intrinsics.signedVInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_xidFormat = this.hr2x_signedVInt;
                this.state = 311;
                return true;
            }
            case 310: {
                int pos = buf.readerIndex();
                this.hr2x_bool = Intrinsics.bool(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_onePhaseCommit = this.hr2x_bool;
                this.state = 317;
                return true;
            }
            case 311: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_xidLength = this.hr2x_byte;
                this.state = 312;
            }
            case 312: {
                if (this.hr2x_xidLength > 0) {
                    this.state = 314;
                    return true;
                }
                this.hr2x_transactionId = Util.EMPTY_BYTE_ARRAY;
                this.state = 313;
            }
            case 313: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_branchLength = this.hr2x_byte;
                this.state = 315;
                return true;
            }
            case 314: {
                int pos = buf.readerIndex();
                this.hr2x_fixedArray = Intrinsics.fixedArray(buf, this.hr2x_xidLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_transactionId = this.hr2x_fixedArray;
                this.state = 313;
                return true;
            }
            case 315: {
                if (this.hr2x_branchLength > 0) {
                    this.state = 316;
                    return true;
                }
                this.hr2x_branchId = Util.EMPTY_BYTE_ARRAY;
                this.hr2x_xid = XidImpl.create((int)this.hr2x_xidFormat, (byte[])this.hr2x_transactionId, (byte[])this.hr2x_branchId);
                this.state = 310;
                return true;
            }
            case 316: {
                int pos = buf.readerIndex();
                this.hr2x_fixedArray = Intrinsics.fixedArray(buf, this.hr2x_branchLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_branchId = this.hr2x_fixedArray;
                this.hr2x_xid = XidImpl.create((int)this.hr2x_xidFormat, (byte[])this.hr2x_transactionId, (byte[])this.hr2x_branchId);
                this.state = 310;
                return true;
            }
            case 317: {
                int pos = buf.readerIndex();
                this.hr2x_bool = Intrinsics.bool(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_recoverable = this.hr2x_bool;
                this.state = 318;
            }
            case 318: {
                int pos = buf.readerIndex();
                this.hr2x_long = Intrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeout = this.hr2x_long;
                this.state = 319;
            }
            case 319: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_numModifications = this.hr2x_vInt;
                this.state = 321;
                return true;
            }
        }
        return true;
    }

    private boolean switch5(ByteBuf buf) throws Exception {
        switch (this.state) {
            case 320: {
                this.cacheProcessor.prepareTransaction(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_xid, this.hr2x_onePhaseCommit, this.hr2x_modifications, this.hr2x_recoverable, this.hr2x_timeout);
                this.state = 0;
                return true;
            }
            case 321: {
                this.hr2x_modifications = this.allocList(this.hr2x_numModifications);
                this.state = 322;
            }
            case 322: {
                if (this.hr2x_numModifications == 0) {
                    this.state = 320;
                    return true;
                }
                --this.hr2x_numModifications;
                this.state = 323;
            }
            case 323: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 325;
                return true;
            }
            case 324: {
                this.hr2x_modifications.add(this.hr2x_modification);
                this.state = 322;
                return true;
            }
            case 325: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_controlByte = this.hr2x_byte;
                this.state = 326;
            }
            case 326: {
                if (!ControlByte.NOT_READ.hasFlag(this.hr2x_controlByte) && !ControlByte.NON_EXISTING.hasFlag(this.hr2x_controlByte)) {
                    this.state = 328;
                    return true;
                }
                this.hr2x_versionRead = 0L;
                this.state = 327;
            }
            case 327: {
                if (!ControlByte.REMOVE_OP.hasFlag(this.hr2x_controlByte)) {
                    this.state = 329;
                    return true;
                }
                this.hr2x_modification = new TransactionWrite(this.hr2x_key, this.hr2x_versionRead, this.hr2x_controlByte, this.hr2x_value, this.hr2x_expiration);
                this.state = 324;
                return true;
            }
            case 328: {
                int pos = buf.readerIndex();
                this.hr2x_long = Intrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_versionRead = this.hr2x_entryVersion = this.hr2x_long;
                this.state = 327;
                return true;
            }
            case 329: {
                if (this.hr2x_version < HotRodConstants.VERSION_22) {
                    this.state = 331;
                    return true;
                }
                if (this.hr2x_version >= HotRodConstants.VERSION_30) {
                    this.state = 333;
                    return true;
                }
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 338;
                return true;
            }
            case 330: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_value = this.hr2x_array;
                this.hr2x_modification = new TransactionWrite(this.hr2x_key, this.hr2x_versionRead, this.hr2x_controlByte, this.hr2x_value, this.hr2x_expiration);
                this.state = 324;
                return true;
            }
            case 331: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanInt = this.hr2x_vInt;
                this.state = 332;
            }
            case 332: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleInt = this.hr2x_vInt;
                this.hr2x_expiration = this.server.buildMetadata2x(this.defaultExpiration(this.hr2x_lifespanInt, this.hr2x_flags, ProtocolFlag.DefaultLifespan), TimeUnitValue.SECONDS, this.defaultExpiration(this.hr2x_maxIdleInt, this.hr2x_flags, ProtocolFlag.DefaultMaxIdle), TimeUnitValue.SECONDS);
                this.state = 330;
                return true;
            }
            case 333: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 334;
            }
            case 334: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 336;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 335;
            }
            case 335: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 337;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 330;
                return true;
            }
            case 336: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 335;
                return true;
            }
            case 337: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 330;
                return true;
            }
            case 338: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 340;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 339;
            }
            case 339: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 341;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 330;
                return true;
            }
            case 340: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 339;
                return true;
            }
            case 341: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 330;
                return true;
            }
            case 342: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_counterName = this.hr2x_string;
                this.state = 343;
            }
            case 343: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_counterFlags = this.hr2x_byte;
                this.state = 345;
                return true;
            }
            case 344: {
                this.counterProcessor.createCounter(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_counterName, this.hr2x_counterConfiguration.build());
                this.state = 0;
                return true;
            }
            case 345: {
                this.hr2x_counterConfiguration = CounterConfiguration.builder((CounterType)EncodeUtil.decodeType((byte)this.hr2x_counterFlags)).storage(EncodeUtil.decodeStorage((byte)this.hr2x_counterFlags));
                this.state = 346;
            }
            case 346: {
                if ((this.hr2x_counterFlags & 1) == 1) {
                    this.state = 348;
                    return true;
                }
                this.state = 347;
            }
            case 347: {
                if ((this.hr2x_counterFlags & 2) == 2) {
                    this.state = 351;
                    return true;
                }
                this.state = 350;
                return true;
            }
            case 348: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.state = 349;
            }
            case 349: {
                this.hr2x_counterConfiguration.concurrencyLevel(this.hr2x_vInt);
                this.state = 347;
                return true;
            }
            case 350: {
                int pos = buf.readerIndex();
                this.hr2x_long = Intrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_initialValue = this.hr2x_long;
                this.hr2x_counterConfiguration = this.hr2x_counterConfiguration.initialValue(this.hr2x_initialValue);
                this.state = 344;
                return true;
            }
            case 351: {
                int pos = buf.readerIndex();
                this.hr2x_long = Intrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lowerBound = this.hr2x_long;
                this.state = 352;
            }
            case 352: {
                int pos = buf.readerIndex();
                this.hr2x_long = Intrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_upperBound = this.hr2x_long;
                this.state = 353;
            }
            case 353: {
                this.hr2x_counterConfiguration.lowerBound(this.hr2x_lowerBound).upperBound(this.hr2x_upperBound);
                this.state = 350;
                return true;
            }
            case 354: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_counterName = this.hr2x_string;
                this.state = 355;
            }
            case 355: {
                this.counterProcessor.getCounterConfiguration(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_counterName);
                this.state = 0;
                return true;
            }
            case 356: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_counterName = this.hr2x_string;
                this.state = 357;
            }
            case 357: {
                this.counterProcessor.isCounterDefined(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_counterName);
                this.state = 0;
                return true;
            }
            case 358: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_counterName = this.hr2x_string;
                this.state = 359;
            }
            case 359: {
                int pos = buf.readerIndex();
                this.hr2x_long = Intrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_updateValue = this.hr2x_long;
                this.state = 360;
            }
            case 360: {
                this.counterProcessor.counterAddAndGet(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_counterName, this.hr2x_updateValue);
                this.state = 0;
                return true;
            }
            case 361: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_counterName = this.hr2x_string;
                this.state = 362;
            }
            case 362: {
                this.counterProcessor.counterReset(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_counterName);
                this.state = 0;
                return true;
            }
            case 363: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_counterName = this.hr2x_string;
                this.state = 364;
            }
            case 364: {
                this.counterProcessor.counterGet(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_counterName);
                this.state = 0;
                return true;
            }
            case 365: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_counterName = this.hr2x_string;
                this.state = 366;
            }
            case 366: {
                int pos = buf.readerIndex();
                this.hr2x_long = Intrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_expectValue = this.hr2x_long;
                this.state = 367;
            }
            case 367: {
                int pos = buf.readerIndex();
                this.hr2x_long = Intrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_updateValue = this.hr2x_long;
                this.state = 368;
            }
            case 368: {
                this.counterProcessor.counterCompareAndSwap(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_counterName, this.hr2x_expectValue, this.hr2x_updateValue);
                this.state = 0;
                return true;
            }
            case 369: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_counterName = this.hr2x_string;
                this.state = 370;
            }
            case 370: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_listenerId = this.hr2x_array;
                this.state = 371;
            }
            case 371: {
                this.counterProcessor.addCounterListener(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_counterName, this.hr2x_listenerId);
                this.state = 0;
                return true;
            }
            case 372: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_counterName = this.hr2x_string;
                this.state = 373;
            }
            case 373: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_listenerId = this.hr2x_array;
                this.state = 374;
            }
            case 374: {
                this.counterProcessor.removeCounterListener(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_counterName, this.hr2x_listenerId);
                this.state = 0;
                return true;
            }
            case 375: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_counterName = this.hr2x_string;
                this.state = 376;
            }
            case 376: {
                this.counterProcessor.counterRemove(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_counterName);
                this.state = 0;
                return true;
            }
            case 377: {
                this.counterProcessor.getCounterNames(this.getHeader(), this.auth.getSubject(this.hr2x_operation));
                this.state = 0;
                return true;
            }
            case 378: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 379;
            }
            case 379: {
                this.multimapProcessor.get(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key);
                this.state = 0;
                return true;
            }
            case 380: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 381;
            }
            case 381: {
                this.multimapProcessor.getWithMetadata(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key);
                this.state = 0;
                return true;
            }
            case 382: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 383;
            }
            case 383: {
                if (this.hr2x_version < HotRodConstants.VERSION_22) {
                    this.state = 385;
                    return true;
                }
                if (this.hr2x_version >= HotRodConstants.VERSION_30) {
                    this.state = 387;
                    return true;
                }
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 392;
                return true;
            }
        }
        return true;
    }

    private boolean switch6(ByteBuf buf) throws Exception {
        switch (this.state) {
            case 384: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_value = this.hr2x_array;
                this.state = 396;
                return true;
            }
            case 385: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanInt = this.hr2x_vInt;
                this.state = 386;
            }
            case 386: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleInt = this.hr2x_vInt;
                this.hr2x_expiration = this.server.buildMetadata2x(this.defaultExpiration(this.hr2x_lifespanInt, this.hr2x_flags, ProtocolFlag.DefaultLifespan), TimeUnitValue.SECONDS, this.defaultExpiration(this.hr2x_maxIdleInt, this.hr2x_flags, ProtocolFlag.DefaultMaxIdle), TimeUnitValue.SECONDS);
                this.state = 384;
                return true;
            }
            case 387: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 388;
            }
            case 388: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 390;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 389;
            }
            case 389: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 391;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 384;
                return true;
            }
            case 390: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 389;
                return true;
            }
            case 391: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 384;
                return true;
            }
            case 392: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 394;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 393;
            }
            case 393: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 395;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 384;
                return true;
            }
            case 394: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 393;
                return true;
            }
            case 395: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 384;
                return true;
            }
            case 396: {
                this.multimapProcessor.put(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key, this.hr2x_value);
                this.state = 0;
                return true;
            }
            case 397: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 398;
            }
            case 398: {
                this.multimapProcessor.removeKey(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key);
                this.state = 0;
                return true;
            }
            case 399: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 400;
            }
            case 400: {
                if (this.hr2x_version < HotRodConstants.VERSION_22) {
                    this.state = 402;
                    return true;
                }
                if (this.hr2x_version >= HotRodConstants.VERSION_30) {
                    this.state = 404;
                    return true;
                }
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 409;
                return true;
            }
            case 401: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_value = this.hr2x_array;
                this.state = 413;
                return true;
            }
            case 402: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanInt = this.hr2x_vInt;
                this.state = 403;
            }
            case 403: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleInt = this.hr2x_vInt;
                this.hr2x_expiration = this.server.buildMetadata2x(this.defaultExpiration(this.hr2x_lifespanInt, this.hr2x_flags, ProtocolFlag.DefaultLifespan), TimeUnitValue.SECONDS, this.defaultExpiration(this.hr2x_maxIdleInt, this.hr2x_flags, ProtocolFlag.DefaultMaxIdle), TimeUnitValue.SECONDS);
                this.state = 401;
                return true;
            }
            case 404: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 405;
            }
            case 405: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 407;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 406;
            }
            case 406: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 408;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 401;
                return true;
            }
            case 407: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 406;
                return true;
            }
            case 408: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 401;
                return true;
            }
            case 409: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 411;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 410;
            }
            case 410: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 412;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 401;
                return true;
            }
            case 411: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 410;
                return true;
            }
            case 412: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 401;
                return true;
            }
            case 413: {
                this.multimapProcessor.removeEntry(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key, this.hr2x_value);
                this.state = 0;
                return true;
            }
            case 414: {
                this.multimapProcessor.size(this.getHeader(), this.auth.getSubject(this.hr2x_operation));
                this.state = 0;
                return true;
            }
            case 415: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 416;
            }
            case 416: {
                if (this.hr2x_version < HotRodConstants.VERSION_22) {
                    this.state = 418;
                    return true;
                }
                if (this.hr2x_version >= HotRodConstants.VERSION_30) {
                    this.state = 420;
                    return true;
                }
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 425;
                return true;
            }
            case 417: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_value = this.hr2x_array;
                this.state = 429;
                return true;
            }
            case 418: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanInt = this.hr2x_vInt;
                this.state = 419;
            }
            case 419: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleInt = this.hr2x_vInt;
                this.hr2x_expiration = this.server.buildMetadata2x(this.defaultExpiration(this.hr2x_lifespanInt, this.hr2x_flags, ProtocolFlag.DefaultLifespan), TimeUnitValue.SECONDS, this.defaultExpiration(this.hr2x_maxIdleInt, this.hr2x_flags, ProtocolFlag.DefaultMaxIdle), TimeUnitValue.SECONDS);
                this.state = 417;
                return true;
            }
            case 420: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 421;
            }
            case 421: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 423;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 422;
            }
            case 422: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 424;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 417;
                return true;
            }
            case 423: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 422;
                return true;
            }
            case 424: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 417;
                return true;
            }
            case 425: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 427;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 426;
            }
            case 426: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 428;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 417;
                return true;
            }
            case 427: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 426;
                return true;
            }
            case 428: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 417;
                return true;
            }
            case 429: {
                this.multimapProcessor.containsEntry(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key, this.hr2x_value);
                this.state = 0;
                return true;
            }
            case 430: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 431;
            }
            case 431: {
                this.multimapProcessor.containsKey(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key);
                this.state = 0;
                return true;
            }
            case 432: {
                if (this.hr2x_version < HotRodConstants.VERSION_22) {
                    this.state = 434;
                    return true;
                }
                if (this.hr2x_version >= HotRodConstants.VERSION_30) {
                    this.state = 436;
                    return true;
                }
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 441;
                return true;
            }
            case 433: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_value = this.hr2x_array;
                this.state = 445;
                return true;
            }
            case 434: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanInt = this.hr2x_vInt;
                this.state = 435;
            }
            case 435: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleInt = this.hr2x_vInt;
                this.hr2x_expiration = this.server.buildMetadata2x(this.defaultExpiration(this.hr2x_lifespanInt, this.hr2x_flags, ProtocolFlag.DefaultLifespan), TimeUnitValue.SECONDS, this.defaultExpiration(this.hr2x_maxIdleInt, this.hr2x_flags, ProtocolFlag.DefaultMaxIdle), TimeUnitValue.SECONDS);
                this.state = 433;
                return true;
            }
            case 436: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 437;
            }
            case 437: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 439;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 438;
            }
            case 438: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 440;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 433;
                return true;
            }
            case 439: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 438;
                return true;
            }
            case 440: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 433;
                return true;
            }
            case 441: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 443;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 442;
            }
            case 442: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 444;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 433;
                return true;
            }
            case 443: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 442;
                return true;
            }
            case 444: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 433;
                return true;
            }
            case 445: {
                this.multimapProcessor.containsValue(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_value);
                this.state = 0;
                return true;
            }
        }
        return true;
    }

    private void deadEnd() {
        if (!this.deadEnd) {
            this.cacheProcessor.writeException(this.getHeader(), (Throwable)((Object)new RequestParsingException("Invalid state of parsing", this.hr2x_version, this.hr2x_messageId)));
            this.deadEnd = true;
        }
        this.state = 0;
    }

    private void exceptionally(Throwable t) throws Exception {
        log.trace("Parsing error", t);
        this.cacheProcessor.writeException(this.getHeader(), t);
        this.state = 0;
    }

    private void reset() {
        this.requestBytes = 0;
        this.hr2x_timeUnits = 0;
        this.hr2x_numEntries = 0;
        this.hr2x_iterationId = null;
        this.hr2x_controlByte = 0;
        this.hr2x_fixedArray = null;
        this.hr2x_queryBytes = null;
        this.hr2x_counterFlags = 0;
        this.hr2x_expectValue = 0L;
        this.hr2x_readable = null;
        this.hr2x_includeCurrentState = false;
        this.hr2x_taskParam = null;
        this.hr2x_cacheName = null;
        this.hr2x_vInt = 0;
        this.hr2x_valueType = null;
        this.hr2x_initialValue = 0L;
        this.hr2x_numModifications = 0;
        this.hr2x_param = null;
        this.hr2x_authMech = null;
        this.hr2x_authResponse = null;
        this.hr2x_listenerInterests = 0;
        this.hr2x_numParams = 0;
        this.hr2x_xidFormat = 0;
        this.hr2x_filterFactory = null;
        this.hr2x_maxIdleLong = 0L;
        this.hr2x_operation = null;
        this.hr2x_upperBound = 0L;
        this.hr2x_version = 0;
        this.hr2x_converterFactory = null;
        this.hr2x_signedVInt = 0;
        this.hr2x_keyType = null;
        this.hr2x_filterConverterFactory = null;
        this.hr2x_mediaTypeParams = null;
        this.hr2x_versionRead = 0L;
        this.hr2x_lifespanInt = 0;
        this.hr2x_mediaParamValue = null;
        this.hr2x_intelligence = 0;
        this.hr2x_long = 0L;
        this.hr2x_mediaParamName = null;
        this.hr2x_converterParams = null;
        this.hr2x_recoverable = false;
        this.hr2x_value = null;
        this.hr2x_branchLength = 0;
        this.hr2x_optionalString = null;
        this.hr2x_optionalArray = null;
        this.hr2x_bool = false;
        this.hr2x_xidLength = 0;
        this.hr2x_mediaTypeDefinition = 0;
        this.hr2x_expiration = null;
        this.hr2x_filterParams = null;
        this.hr2x_offset = 0;
        this.hr2x_chunkBytes = null;
        this.hr2x_updateValue = 0L;
        this.hr2x_txMarker = 0;
        this.hr2x_useRawEvents = false;
        this.hr2x_chunkLength = 0;
        this.hr2x_timeout = 0L;
        this.hr2x_taskName = null;
        this.hr2x_mediaTypeName = null;
        this.hr2x_lowerBound = 0L;
        this.hr2x_taskParamValue = null;
        this.hr2x_chunkedValue = null;
        this.hr2x_key = null;
        this.hr2x_batchSize = 0;
        this.hr2x_header = null;
        this.hr2x_scope = 0;
        this.hr2x_lifespanLong = 0L;
        this.hr2x_taskParams = null;
        this.hr2x_array = null;
        this.hr2x_flags = 0;
        this.hr2x_listenerId = null;
        this.hr2x_segmentMask = null;
        this.hr2x_magic = 0;
        this.hr2x_maxIdleInt = 0;
        this.hr2x_onePhaseCommit = false;
        this.hr2x_entryVersion = 0L;
        this.hr2x_mediaTypeId = 0;
        this.hr2x_includeMetadata = false;
        this.hr2x_opCode = 0;
        this.hr2x_entryMap = null;
        this.hr2x_mediaTypeParamsNum = 0;
        this.hr2x_messageId = 0L;
        this.hr2x_vLong = 0L;
        this.hr2x_filterConverterParams = null;
        this.hr2x_numKeys = 0;
        this.hr2x_mediaType = null;
        this.hr2x_branchId = null;
        this.hr2x_string = null;
        this.hr2x_byte = 0;
        this.hr2x_transactionId = null;
        this.hr2x_mediaTypeDescription = null;
        this.hr2x_counterName = null;
        this.hr2x_modification = null;
        this.hr2x_counterConfiguration = null;
        this.hr2x_topologyId = 0;
        this.hr2x_keys = null;
        this.hr2x_xid = null;
        this.hr2x_modifications = null;
    }

    public int requestBytes() {
        return this.requestBytes;
    }

    private boolean userSwitch55() throws Exception {
        switch (this.hr2x_opCode) {
            case 1: {
                this.state = 56;
                return true;
            }
            case 3: {
                this.state = 71;
                return true;
            }
            case 5: {
                this.state = 73;
                return true;
            }
            case 7: {
                this.state = 88;
                return true;
            }
            case 9: {
                this.state = 103;
                return true;
            }
            case 11: {
                this.state = 119;
                return true;
            }
            case 13: {
                this.state = 121;
                return true;
            }
            case 15: {
                this.state = 124;
                return true;
            }
            case 17: {
                this.state = 126;
                return true;
            }
            case 19: {
                this.state = 128;
                return true;
            }
            case 21: {
                this.state = 129;
                return true;
            }
            case 23: {
                this.state = 130;
                return true;
            }
            case 25: {
                this.state = 131;
                return true;
            }
            case 27: {
                this.state = 133;
                return true;
            }
            case 29: {
                this.state = 135;
                return true;
            }
            case 31: {
                this.state = 137;
                return true;
            }
            case 33: {
                this.state = 139;
                return true;
            }
            case 35: {
                this.state = 140;
                return true;
            }
            case 37: {
                this.state = 143;
                return true;
            }
            case 39: {
                this.state = 177;
                return true;
            }
            case 41: {
                this.state = 179;
                return true;
            }
            case 43: {
                this.state = 180;
                return true;
            }
            case 45: {
                this.state = 188;
                return true;
            }
            case 47: {
                this.state = 207;
                return true;
            }
            case 49: {
                this.state = 213;
                return true;
            }
            case 51: {
                this.state = 225;
                return true;
            }
            case 53: {
                this.state = 227;
                return true;
            }
            case 55: {
                this.state = 229;
                return true;
            }
            case 57: {
                this.state = 232;
                return true;
            }
            case 59: {
                this.state = 253;
                return true;
            }
            case 61: {
                this.state = 284;
                return true;
            }
            case 63: {
                this.state = 292;
                return true;
            }
            case 121: {
                this.state = 300;
                return true;
            }
            case 123: {
                this.state = 308;
                return true;
            }
            case 125: {
                this.state = 309;
                return true;
            }
            case 75: {
                this.state = 342;
                return true;
            }
            case 77: {
                this.state = 354;
                return true;
            }
            case 79: {
                this.state = 356;
                return true;
            }
            case 82: {
                this.state = 358;
                return true;
            }
            case 84: {
                this.state = 361;
                return true;
            }
            case 86: {
                this.state = 363;
                return true;
            }
            case 88: {
                this.state = 365;
                return true;
            }
            case 90: {
                this.state = 369;
                return true;
            }
            case 92: {
                this.state = 372;
                return true;
            }
            case 94: {
                this.state = 375;
                return true;
            }
            case 100: {
                this.state = 377;
                return true;
            }
            case 103: {
                this.state = 378;
                return true;
            }
            case 105: {
                this.state = 380;
                return true;
            }
            case 107: {
                this.state = 382;
                return true;
            }
            case 109: {
                this.state = 397;
                return true;
            }
            case 111: {
                this.state = 399;
                return true;
            }
            case 113: {
                this.state = 414;
                return true;
            }
            case 115: {
                this.state = 415;
                return true;
            }
            case 117: {
                this.state = 430;
                return true;
            }
            case 119: {
                this.state = 432;
                return true;
            }
        }
        throw new HotRodUnknownOperationException("Unknown operation " + this.hr2x_opCode, this.hr2x_version, this.hr2x_messageId);
    }
}

