/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import javax.security.auth.Subject;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.tx.XidImpl;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.VersionGenerator;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.security.actions.SecurityActions;
import org.infinispan.server.hotrod.CacheRequestProcessor;
import org.infinispan.server.hotrod.HotRodHeader;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.MetadataUtils;
import org.infinispan.server.hotrod.TransactionWrite;
import org.infinispan.server.hotrod.logging.Log;
import org.infinispan.server.hotrod.tracing.HotRodTelemetryService;
import org.infinispan.server.hotrod.tx.PrepareCoordinator;
import org.infinispan.server.hotrod.tx.operation.CommitTransactionOperation;
import org.infinispan.server.hotrod.tx.operation.RollbackTransactionOperation;
import org.infinispan.server.hotrod.tx.table.GlobalTxTable;
import org.infinispan.server.hotrod.tx.table.TxState;
import org.infinispan.transaction.tm.EmbeddedTransactionManager;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.util.logging.LogFactory;

class TransactionRequestProcessor
extends CacheRequestProcessor {
    private static final Log log = (Log)LogFactory.getLog(TransactionRequestProcessor.class, Log.class);

    TransactionRequestProcessor(Channel channel, Executor executor, HotRodServer server, HotRodTelemetryService telemetryService) {
        super(channel, executor, server, telemetryService);
    }

    private void writeTransactionResponse(HotRodHeader header, int value) {
        this.writeResponse(header, this.createTransactionResponse(header, value));
    }

    void rollbackTransaction(HotRodHeader header, Subject subject, XidImpl xid) {
        RollbackTransactionOperation operation = new RollbackTransactionOperation(header, this.server, subject, xid, this::writeTransactionResponse);
        this.executor.execute(operation);
    }

    void commitTransaction(HotRodHeader header, Subject subject, XidImpl xid) {
        CommitTransactionOperation operation = new CommitTransactionOperation(header, this.server, subject, xid, this::writeTransactionResponse);
        this.executor.execute(operation);
    }

    void prepareTransaction(HotRodHeader header, Subject subject, XidImpl xid, boolean onePhaseCommit, List<TransactionWrite> writes, boolean recoverable, long timeout) {
        HotRodServer.ExtendedCacheInfo cacheInfo = this.server.getCacheInfo(header);
        AdvancedCache<byte[], byte[]> cache = this.server.cache(cacheInfo, header, subject);
        this.validateConfiguration(cache);
        this.executor.execute(() -> this.prepareTransactionInternal(header, cache, cacheInfo.versionGenerator, xid, onePhaseCommit, writes, recoverable, timeout));
    }

    void forgetTransaction(HotRodHeader header, Subject subject, XidImpl xid) {
        GlobalTxTable txTable = (GlobalTxTable)SecurityActions.getGlobalComponentRegistry((EmbeddedCacheManager)this.server.getCacheManager()).getComponent(GlobalTxTable.class);
        this.executor.execute(() -> {
            try {
                txTable.forgetTransaction(xid);
                this.writeSuccess(header);
            }
            catch (Throwable t) {
                this.writeException(header, t);
            }
        });
    }

    void getPreparedTransactions(HotRodHeader header, Subject subject) {
        if (log.isTraceEnabled()) {
            log.trace("Fetching transactions for recovery");
        }
        this.executor.execute(() -> {
            try {
                GlobalTxTable txTable = (GlobalTxTable)SecurityActions.getGlobalComponentRegistry((EmbeddedCacheManager)this.server.getCacheManager()).getComponent(GlobalTxTable.class);
                Collection<XidImpl> preparedTx = txTable.getPreparedTransactions();
                this.writeResponse(header, this.createRecoveryResponse(header, preparedTx));
            }
            catch (Throwable t) {
                this.writeException(header, t);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareTransactionInternal(HotRodHeader header, AdvancedCache<byte[], byte[]> cache, VersionGenerator versionGenerator, XidImpl xid, boolean onePhaseCommit, List<TransactionWrite> writes, boolean recoverable, long timeout) {
        try {
            if (writes.isEmpty()) {
                if (log.isTraceEnabled()) {
                    log.tracef("Transaction %s is read only.", xid);
                }
                this.writeResponse(header, this.createTransactionResponse(header, 3));
                return;
            }
            PrepareCoordinator prepareCoordinator = new PrepareCoordinator(cache, xid, recoverable, timeout);
            if (this.checkExistingTxForPrepare(header, prepareCoordinator)) {
                if (log.isTraceEnabled()) {
                    log.tracef("Transaction %s conflicts with another node.", xid);
                }
                return;
            }
            if (!prepareCoordinator.startTransaction()) {
                if (log.isTraceEnabled()) {
                    log.tracef("Unable to start transaction %s", xid);
                }
                this.writeNotExecuted(header);
                return;
            }
            AdvancedCache<byte[], byte[]> txCache = prepareCoordinator.decorateCache(cache);
            try {
                boolean rollback = false;
                for (TransactionWrite write : writes) {
                    if (this.isValid(write, txCache)) {
                        if (write.isRemove()) {
                            txCache.remove((Object)write.key);
                            continue;
                        }
                        write.metadata.version((EntryVersion)versionGenerator.generateNew());
                        txCache.put((Object)write.key, (Object)write.value, write.metadata.build());
                        continue;
                    }
                    prepareCoordinator.setRollbackOnly();
                    rollback = true;
                    break;
                }
                int xaCode = rollback ? prepareCoordinator.rollback() : prepareCoordinator.prepare(onePhaseCommit);
                this.writeResponse(header, this.createTransactionResponse(header, xaCode));
            }
            catch (Exception e) {
                this.writeResponse(header, this.createTransactionResponse(header, prepareCoordinator.rollback()));
            }
            finally {
                EmbeddedTransactionManager.dissociateTransaction();
            }
        }
        catch (Throwable t) {
            log.debugf(t, "Exception while replaying transaction %s for cache %s", xid, cache.getName());
            this.writeException(header, t);
        }
    }

    private void validateConfiguration(AdvancedCache<byte[], byte[]> cache) {
        Configuration configuration = cache.getCacheConfiguration();
        if (!configuration.transaction().transactionMode().isTransactional()) {
            throw log.expectedTransactionalCache(cache.getName());
        }
        if (configuration.locking().isolationLevel() != IsolationLevel.REPEATABLE_READ) {
            throw log.unexpectedIsolationLevel(cache.getName());
        }
    }

    private boolean checkExistingTxForPrepare(HotRodHeader header, PrepareCoordinator txCoordinator) {
        TxState txState = txCoordinator.getTxState();
        if (txState == null) {
            return false;
        }
        if (txCoordinator.isAlive(txState.getOriginator())) {
            this.writeNotExecuted(header);
            return true;
        }
        switch (txState.getStatus()) {
            case ACTIVE: 
            case PREPARING: {
                txCoordinator.rollbackRemoteTransaction(txState.getGlobalTransaction());
                return false;
            }
            case PREPARED: 
            case COMMITTED: {
                this.writeResponse(header, this.createTransactionResponse(header, 0));
                return true;
            }
            case MARK_ROLLBACK: {
                txCoordinator.rollbackRemoteTransaction(txState.getGlobalTransaction());
            }
            case ROLLED_BACK: {
                this.writeResponse(header, this.createTransactionResponse(header, 100));
                return true;
            }
            case MARK_COMMIT: {
                this.writeResponse(header, this.createTransactionResponse(header, txCoordinator.onePhaseCommitRemoteTransaction(txState.getGlobalTransaction(), txState.getModifications())));
                return true;
            }
        }
        throw new IllegalStateException();
    }

    private boolean isValid(TransactionWrite write, AdvancedCache<byte[], byte[]> readCache) {
        if (write.skipRead()) {
            if (log.isTraceEnabled()) {
                log.tracef("Operation %s wasn't read.", write);
            }
            return true;
        }
        CacheEntry entry = readCache.getCacheEntry((Object)write.key);
        if (write.wasNonExisting()) {
            if (log.isTraceEnabled()) {
                log.tracef("Key didn't exist for operation %s. Entry is %s", write, entry);
            }
            return entry == null || entry.getValue() == null;
        }
        if (log.isTraceEnabled()) {
            log.tracef("Checking version for operation %s. Entry is %s", write, entry);
        }
        return entry != null && write.versionRead == MetadataUtils.extractVersion(entry);
    }

    private ByteBuf createTransactionResponse(HotRodHeader header, int xaReturnCode) {
        return header.encoder().transactionResponse(header, this.server, this.channel, xaReturnCode);
    }

    private ByteBuf createRecoveryResponse(HotRodHeader header, Collection<XidImpl> xids) {
        return header.encoder().recoveryResponse(header, this.server, this.channel, xids);
    }
}

