/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import org.infinispan.commons.util.ByRef;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.server.memcached.logging.Header;
import org.infinispan.server.memcached.logging.MemcachedAccessLogging;
import org.infinispan.util.concurrent.AggregateCompletionStage;
import org.infinispan.util.concurrent.CompletionStages;

public abstract class MemcachedResponse
implements BiConsumer<Object, Throwable>,
Runnable {
    private volatile Object response;
    private volatile Throwable throwable;
    protected Header header;
    private CompletionStage<Void> responseSent;
    private final ByRef<MemcachedResponse> current;
    protected final Channel ch;
    private GenericFutureListener<? extends Future<? super Void>> listener;

    protected MemcachedResponse(ByRef<MemcachedResponse> current, Channel ch) {
        this.current = current;
        this.ch = ch;
    }

    public void queueResponse(Header header, CompletionStage<?> response) {
        this.queueResponse(header, response, null);
    }

    public void queueResponse(Header header, CompletionStage<?> operationResponse, GenericFutureListener<? extends Future<? super Void>> listener) {
        assert (this.ch.eventLoop().inEventLoop());
        AggregateCompletionStage all = CompletionStages.aggregateCompletionStage();
        MemcachedResponse c = (MemcachedResponse)this.current.get();
        if (c != null) {
            all.dependsOn(c.responseSent);
        }
        all.dependsOn(operationResponse.whenComplete(this));
        this.listener = listener;
        this.header = header;
        this.responseSent = all.freeze().exceptionally(CompletableFutures.toNullFunction()).thenRunAsync(this, (Executor)this.ch.eventLoop());
        this.current.set((Object)this);
    }

    @Override
    public void accept(Object response, Throwable throwable) {
        this.response = response;
        this.throwable = throwable;
    }

    @Override
    public void run() {
        ChannelFuture future;
        ChannelFuture channelFuture = future = this.throwable != null ? this.writeThrowable(this.header, this.throwable) : this.writeResponse(this.header, this.response);
        if (this.listener != null) {
            future.addListener(this.listener);
        }
    }

    protected abstract ChannelFuture writeThrowable(Header var1, Throwable var2);

    protected ChannelFuture writeResponse(Header header, Object response) {
        if (response != null) {
            ChannelFuture future = null;
            int responseBytes = 0;
            if (response instanceof ByteBuf[]) {
                for (ByteBuf buf : (ByteBuf[])response) {
                    responseBytes += buf.readableBytes();
                    future = this.ch.writeAndFlush((Object)buf);
                }
            } else if (response instanceof byte[]) {
                responseBytes = ((byte[])response).length;
                future = this.ch.writeAndFlush((Object)this.ch.alloc().buffer(((byte[])response).length).writeBytes((byte[])response));
            } else if (response instanceof CharSequence) {
                responseBytes = ((CharSequence)response).length();
                future = this.ch.writeAndFlush((Object)ByteBufUtil.writeAscii((ByteBufAllocator)this.ch.alloc(), (CharSequence)((CharSequence)response)));
            } else {
                responseBytes = ((ByteBuf)response).readableBytes();
                future = this.ch.writeAndFlush(response);
            }
            if (header != null) {
                MemcachedAccessLogging.logOK(future, header, responseBytes);
            }
            return future;
        }
        return null;
    }
}

