/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached.binary;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.security.auth.Subject;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.infinispan.commons.util.Util;
import org.infinispan.server.core.configuration.SaslConfiguration;
import org.infinispan.server.core.security.sasl.SaslAuthenticator;
import org.infinispan.server.core.transport.SaslQopHandler;
import org.infinispan.server.memcached.MemcachedServer;
import org.infinispan.server.memcached.MemcachedStatus;
import org.infinispan.server.memcached.binary.BinaryDecoder;
import org.infinispan.server.memcached.binary.BinaryHeader;
import org.infinispan.server.memcached.binary.BinaryOpDecoderImpl;
import org.infinispan.server.memcached.configuration.MemcachedAuthenticationConfiguration;
import org.infinispan.server.memcached.configuration.MemcachedServerConfiguration;

abstract class BinaryAuthDecoder
extends BinaryDecoder {
    private SaslServer saslServer;

    protected BinaryAuthDecoder(MemcachedServer server) {
        super(server, ANONYMOUS);
    }

    protected void saslListMechs(BinaryHeader header) {
        byte[] mechs = String.join((CharSequence)" ", ((MemcachedAuthenticationConfiguration)((MemcachedServerConfiguration)this.server.getConfiguration()).authentication()).sasl().mechanisms()).getBytes(StandardCharsets.US_ASCII);
        ByteBuf r = this.response(header, MemcachedStatus.NO_ERROR, mechs);
        this.send(header, CompletableFuture.completedFuture(r));
    }

    protected void saslAuth(BinaryHeader header, byte[] mech, byte[] data) {
        CompletionStage r = this.server.getBlockingManager().supplyBlocking(() -> {
            try {
                this.saslServer = SaslAuthenticator.createSaslServer((SaslConfiguration)((MemcachedAuthenticationConfiguration)((MemcachedServerConfiguration)this.server.getConfiguration()).authentication()).sasl(), (Channel)this.channel, (String)new String(mech, StandardCharsets.US_ASCII), (String)"memcached");
                return this.doSasl(header, data);
            }
            catch (Throwable t) {
                return this.response(header, MemcachedStatus.AUTHN_ERROR, t);
            }
        }, (Object)"memcached-sasl-auth");
        this.send(header, r);
    }

    protected void saslStep(BinaryHeader header, byte[] mech, byte[] data) {
        CompletionStage r = this.server.getBlockingManager().supplyBlocking(() -> this.doSasl(header, data), (Object)"memcached-sasl-step");
        this.send(header, r);
    }

    private ByteBuf doSasl(BinaryHeader header, byte[] data) {
        try {
            byte[] serverChallenge = this.saslServer.evaluateResponse(data);
            if (this.saslServer.isComplete()) {
                Subject subject = (Subject)this.saslServer.getNegotiatedProperty("org.infinispan.security.Subject");
                String qop = (String)this.saslServer.getNegotiatedProperty("javax.security.sasl.qop");
                if ("auth-int".equals(qop) || "auth-conf".equals(qop)) {
                    this.channel.eventLoop().submit(() -> {
                        this.channel.writeAndFlush((Object)this.response(header, MemcachedStatus.NO_ERROR));
                        SaslQopHandler qopHandler = new SaslQopHandler(this.saslServer);
                        this.channel.pipeline().addBefore("decoder", "saslQop", (ChannelHandler)qopHandler);
                    });
                } else {
                    this.channel.eventLoop().submit(() -> {
                        this.channel.writeAndFlush((Object)this.response(header, MemcachedStatus.NO_ERROR, serverChallenge == null ? Util.EMPTY_BYTE_ARRAY : serverChallenge));
                        this.channel.pipeline().replace("decoder", "decoder", (ChannelHandler)new BinaryOpDecoderImpl(this.server, subject));
                        this.disposeSaslServer();
                    });
                }
                return null;
            }
            return this.response(header, MemcachedStatus.AUTHN_CONTINUE, serverChallenge);
        }
        catch (Throwable t) {
            return this.response(header, MemcachedStatus.AUTHN_ERROR, t);
        }
    }

    private void disposeSaslServer() {
        try {
            if (this.saslServer != null) {
                this.saslServer.dispose();
            }
        }
        catch (SaslException e) {
            log.debug("Exception while disposing SaslServer", e);
        }
        finally {
            this.saslServer = null;
        }
    }
}

