/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached.binary;

import io.netty.buffer.ByteBuf;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.util.SimpleImmutableEntry;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.Version;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.versioning.NumericVersion;
import org.infinispan.context.Flag;
import org.infinispan.metadata.Metadata;
import org.infinispan.server.memcached.MemcachedMetadata;
import org.infinispan.server.memcached.MemcachedServer;
import org.infinispan.server.memcached.MemcachedStats;
import org.infinispan.server.memcached.MemcachedStatus;
import org.infinispan.server.memcached.ParseUtil;
import org.infinispan.server.memcached.binary.BinaryCommand;
import org.infinispan.server.memcached.binary.BinaryDecoder;
import org.infinispan.server.memcached.binary.BinaryHeader;
import org.infinispan.util.function.SerializableBiFunction;
import org.jgroups.util.CompletableFutures;

abstract class BinaryOpDecoder
extends BinaryDecoder {
    protected BinaryOpDecoder(MemcachedServer server, Subject subject) {
        super(server, subject);
    }

    protected void get(BinaryHeader header, byte[] key, boolean quiet) {
        CompletionStage response = this.cache.getCacheEntryAsync((Object)key).thenApply(e -> {
            boolean withKey;
            boolean bl = withKey = header.op == BinaryCommand.GETK || header.op == BinaryCommand.GETKQ;
            if (e == null) {
                if (quiet) {
                    return null;
                }
                return this.response(header, MemcachedStatus.KEY_NOT_FOUND, withKey ? key : Util.EMPTY_BYTE_ARRAY, Util.EMPTY_BYTE_ARRAY);
            }
            MemcachedMetadata metadata = (MemcachedMetadata)e.getMetadata();
            header.cas = ((NumericVersion)metadata.version()).getVersion();
            return this.response(header, MemcachedStatus.NO_ERROR, metadata.flags, withKey ? key : Util.EMPTY_BYTE_ARRAY, (byte[])e.getValue());
        });
        this.send(header, response);
    }

    protected void set(BinaryHeader header, byte[] key, byte[] value, int flags, int expiration, boolean quiet) {
        Metadata metadata = this.metadata(flags, expiration);
        CompletionStage response = header.cas == 0L ? this.cache.withFlags(Flag.IGNORE_RETURN_VALUES).putAsync((Object)key, (Object)value, metadata).thenApply(ignore -> this.storeResponse(header, quiet, metadata)) : this.cache.getCacheEntryAsync((Object)key).thenCompose(e -> {
            if (e == null) {
                return CompletableFuture.completedFuture(this.response(header, MemcachedStatus.KEY_NOT_FOUND));
            }
            long version = ((NumericVersion)e.getMetadata().version()).getVersion();
            if (version == header.cas) {
                return this.cache.replaceAsync((Object)key, (Object)((byte[])e.getValue()), (Object)value, metadata).thenApply(ignore -> this.storeResponse(header, quiet, metadata));
            }
            return CompletableFuture.completedFuture(this.response(header, MemcachedStatus.KEY_EXISTS));
        });
        this.send(header, response);
    }

    protected void add(BinaryHeader header, byte[] key, byte[] value, int flags, int expiration, boolean quiet) {
        Metadata metadata = this.metadata(flags, expiration);
        CompletionStage response = this.cache.putIfAbsentAsyncEntry((Object)key, (Object)value, metadata).thenApply(e -> {
            if (e != null) {
                return this.response(header, MemcachedStatus.KEY_EXISTS);
            }
            return this.storeResponse(header, quiet, metadata);
        });
        this.send(header, response);
    }

    protected void replace(BinaryHeader header, byte[] key, byte[] value, int flags, int expiration, boolean quiet) {
        Metadata metadata = this.metadata(flags, expiration);
        CompletionStage response = header.cas == 0L ? this.cache.replaceAsync((Object)key, (Object)value, metadata).thenApply(e -> {
            if (e == null) {
                return this.response(header, MemcachedStatus.KEY_NOT_FOUND);
            }
            return this.storeResponse(header, quiet, metadata);
        }) : this.cache.getCacheEntryAsync((Object)key).thenCompose(e -> {
            if (e == null) {
                MemcachedStats.CAS_MISSES.incrementAndGet(this.statistics);
                return CompletableFuture.completedFuture(this.response(header, MemcachedStatus.KEY_NOT_FOUND));
            }
            long version = ((NumericVersion)metadata.version()).getVersion();
            if (header.cas == version) {
                return this.cache.replaceAsync((Object)key, (Object)((byte[])e.getValue()), (Object)value, metadata).thenApply(ignore -> {
                    MemcachedStats.CAS_HITS.incrementAndGet(this.statistics);
                    return this.storeResponse(header, quiet, metadata);
                });
            }
            MemcachedStats.CAS_BADVAL.incrementAndGet(this.statistics);
            return CompletableFuture.completedFuture(this.response(header, MemcachedStatus.ITEM_NOT_STORED));
        });
        this.send(header, response);
    }

    private ByteBuf storeResponse(BinaryHeader header, boolean quiet, Metadata metadata) {
        if (quiet) {
            return null;
        }
        header.cas = ((NumericVersion)metadata.version()).getVersion();
        return this.response(header, MemcachedStatus.NO_ERROR);
    }

    protected void delete(BinaryHeader header, byte[] key, boolean quiet) {
        CompletionStage response = header.cas == 0L ? this.cache.removeAsync((Object)key).thenApply(v -> {
            if (v != null && quiet) {
                return null;
            }
            return this.response(header, v == null ? MemcachedStatus.KEY_NOT_FOUND : MemcachedStatus.DELETED);
        }) : this.cache.getCacheEntryAsync((Object)key).thenCompose(e -> {
            if (e == null) {
                return CompletableFuture.completedFuture(this.response(header, MemcachedStatus.KEY_NOT_FOUND));
            }
            long version = ((NumericVersion)e.getMetadata().version()).getVersion();
            if (header.cas == version) {
                return this.cache.removeAsync((Object)key, e.getValue()).thenApply(d -> {
                    if (d.booleanValue()) {
                        return quiet ? null : this.response(header, MemcachedStatus.DELETED);
                    }
                    return this.response(header, MemcachedStatus.KEY_EXISTS);
                });
            }
            return CompletableFuture.completedFuture(this.response(header, MemcachedStatus.KEY_EXISTS));
        });
        this.send(header, response);
    }

    protected void increment(BinaryHeader header, byte[] key, long delta, long initial, int expiration, boolean quiet) {
        Metadata metadata = this.metadata(0, expiration);
        CompletableFuture f = expiration == -1 ? this.cache.computeIfPresentAsync((Object)key, (SerializableBiFunction & Serializable)(k, v) -> BinaryOpDecoder.increment(delta, v), metadata) : this.cache.mergeAsync((Object)key, (Object)ParseUtil.writeAsciiLong(initial), (SerializableBiFunction & Serializable)(v1, v2) -> BinaryOpDecoder.increment(delta, v1), metadata);
        CompletionStage response = f.thenApply(v -> {
            if (v == null) {
                if (this.statsEnabled) {
                    if (delta > 0L) {
                        MemcachedStats.INCR_MISSES.incrementAndGet(this.statistics);
                    } else {
                        MemcachedStats.DECR_MISSES.incrementAndGet(this.statistics);
                    }
                }
                return this.response(header, MemcachedStatus.KEY_NOT_FOUND);
            }
            if (this.statsEnabled) {
                if (delta > 0L) {
                    MemcachedStats.INCR_HITS.incrementAndGet(this.statistics);
                } else {
                    MemcachedStats.DECR_HITS.incrementAndGet(this.statistics);
                }
            }
            if (quiet) {
                return null;
            }
            header.cas = ((NumericVersion)metadata.version()).getVersion();
            return this.response(header, MemcachedStatus.NO_ERROR, ParseUtil.readLong(v));
        });
        this.send(header, response);
    }

    private static byte[] increment(long delta, byte[] v1) {
        long l = ParseUtil.readLong(v1);
        if ((l += delta) < 0L) {
            l = 0L;
        }
        return ParseUtil.writeAsciiLong(l);
    }

    protected void append(BinaryHeader header, byte[] key, byte[] value, boolean quiet) {
        CompletionStage response = this.cache.computeIfPresentAsync((Object)key, (SerializableBiFunction & Serializable)(k, v) -> {
            byte[] r = Arrays.copyOf(v, ((byte[])v).length + value.length);
            System.arraycopy(value, 0, r, ((byte[])v).length, value.length);
            return r;
        }, null).thenApply(v -> {
            if (quiet) {
                return null;
            }
            return this.response(header, v == null ? MemcachedStatus.KEY_NOT_FOUND : MemcachedStatus.NO_ERROR);
        });
        this.send(header, response);
    }

    protected void prepend(BinaryHeader header, byte[] key, byte[] value, boolean quiet) {
        CompletionStage response = this.cache.computeIfPresentAsync((Object)key, (SerializableBiFunction & Serializable)(k, v) -> {
            byte[] r = Arrays.copyOf(value, ((byte[])v).length + value.length);
            System.arraycopy(v, 0, r, value.length, ((byte[])v).length);
            return r;
        }, null).thenApply(v -> {
            if (quiet) {
                return null;
            }
            return this.response(header, v == null ? MemcachedStatus.KEY_NOT_FOUND : MemcachedStatus.NO_ERROR);
        });
        this.send(header, response);
    }

    protected void quit(BinaryHeader header, boolean quiet) {
        if (quiet) {
            this.channel.close();
        } else {
            ByteBuf buf = this.response(header, MemcachedStatus.NO_ERROR);
            this.send(header, CompletableFuture.completedFuture(buf), (GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener)v -> this.channel.close()));
        }
    }

    protected void version(BinaryHeader header) {
        ByteBuf r = this.response(header, MemcachedStatus.NO_ERROR, Version.getVersion().getBytes(StandardCharsets.US_ASCII));
        this.send(header, CompletableFuture.completedFuture(r));
    }

    protected void noop(BinaryHeader header) {
        this.send(header, CompletableFuture.completedFuture(this.response(header, MemcachedStatus.NO_ERROR)));
    }

    protected void touch(BinaryHeader header, byte[] key, int expiration) {
        CompletionStage r = this.cache.getCacheEntryAsync((Object)key).thenCompose(e -> {
            if (e == null) {
                return CompletableFuture.completedFuture(this.response(header, MemcachedStatus.KEY_NOT_FOUND));
            }
            return this.cache.replaceAsync((Object)((byte[])e.getKey()), (Object)((byte[])e.getValue()), this.touchMetadata((CacheEntry<?, ?>)e, expiration)).thenApply(ignore -> this.response(header, MemcachedStatus.NO_ERROR));
        });
        this.send(header, r);
    }

    protected void gat(BinaryHeader header, byte[] key, int expiration, boolean quiet) {
        CompletionStage r = this.cache.getCacheEntryAsync((Object)key).thenCompose(e -> {
            boolean withKey;
            boolean bl = withKey = header.op == BinaryCommand.GATK || header.op == BinaryCommand.GATKQ;
            if (e == null) {
                if (quiet) {
                    return CompletableFutures.completedNull();
                }
                return CompletableFuture.completedFuture(this.response(header, MemcachedStatus.KEY_NOT_FOUND, withKey ? key : Util.EMPTY_BYTE_ARRAY, Util.EMPTY_BYTE_ARRAY));
            }
            MemcachedMetadata metadata = (MemcachedMetadata)e.getMetadata();
            header.cas = ((NumericVersion)metadata.version()).getVersion();
            return this.cache.replaceAsync((Object)((byte[])e.getKey()), (Object)((byte[])e.getValue()), this.touchMetadata((CacheEntry<?, ?>)e, expiration)).thenApply(x -> this.response(header, MemcachedStatus.NO_ERROR, metadata.flags, withKey ? (byte[])e.getKey() : Util.EMPTY_BYTE_ARRAY, (byte[])e.getValue()));
        });
        this.send(header, r);
    }

    protected void stat(BinaryHeader header, byte[] key) {
        CompletionStage s = this.server.getBlockingManager().supplyBlocking(() -> {
            Map<byte[], byte[]> map = this.statsMap();
            if (key != null) {
                if (!map.containsKey(key)) {
                    return this.response(header, MemcachedStatus.KEY_NOT_FOUND);
                }
                return this.singleStat(header, (Map.Entry<byte[], byte[]>)new SimpleImmutableEntry((Object)key, (Object)map.get(key)));
            }
            ByteBuf buf = this.channel.alloc().buffer();
            for (Map.Entry<byte[], byte[]> e : map.entrySet()) {
                buf.writeBytes(this.singleStat(header, e));
            }
            buf.writeBytes(this.response(header, MemcachedStatus.NO_ERROR));
            return buf;
        }, (Object)"memcached-stats");
        this.send(header, s);
    }

    private ByteBuf singleStat(BinaryHeader header, Map.Entry<byte[], byte[]> e) {
        return this.response(header, MemcachedStatus.NO_ERROR, e.getKey(), e.getValue());
    }

    protected void flush(BinaryHeader header, int expiration, boolean quiet) {
        CompletableFuture<Object> future;
        if (expiration == 0) {
            future = this.cache.clearAsync();
        } else {
            this.server.getBlockingManager().scheduleRunBlocking(() -> ((AdvancedCache)this.cache).clear(), this.toMillis(expiration), TimeUnit.MILLISECONDS, (Object)"memcached-flush");
            future = CompletableFuture.completedFuture(null);
        }
        if (quiet) {
            return;
        }
        this.send(header, future.thenApply(ignore -> this.response(header, MemcachedStatus.NO_ERROR)));
    }

    protected void verbosityLevel(BinaryHeader header, int verbosity) {
        this.send(header, CompletableFuture.completedFuture(this.response(header, MemcachedStatus.NO_ERROR)));
    }
}

