/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached.configuration;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.server.core.admin.AdminOperationsHandler;
import org.infinispan.server.core.configuration.EncryptionConfigurationBuilder;
import org.infinispan.server.core.configuration.ProtocolServerConfigurationBuilder;
import org.infinispan.server.core.configuration.ProtocolServerConfigurationChildBuilder;
import org.infinispan.server.memcached.configuration.MemcachedAuthenticationConfiguration;
import org.infinispan.server.memcached.configuration.MemcachedAuthenticationConfigurationBuilder;
import org.infinispan.server.memcached.configuration.MemcachedProtocol;
import org.infinispan.server.memcached.configuration.MemcachedServerConfiguration;

public class MemcachedServerConfigurationBuilder
extends ProtocolServerConfigurationBuilder<MemcachedServerConfiguration, MemcachedServerConfigurationBuilder, MemcachedAuthenticationConfiguration>
implements Builder<MemcachedServerConfiguration> {
    private final MemcachedAuthenticationConfigurationBuilder authentication = new MemcachedAuthenticationConfigurationBuilder((ProtocolServerConfigurationChildBuilder<?, ?, ?>)this);
    private final EncryptionConfigurationBuilder encryption = new EncryptionConfigurationBuilder(this.ssl());

    public MemcachedServerConfigurationBuilder() {
        super(11211, MemcachedServerConfiguration.attributeDefinitionSet());
        this.defaultCacheName("memcachedCache");
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public MemcachedServerConfigurationBuilder self() {
        return this;
    }

    @Deprecated
    public MemcachedServerConfigurationBuilder cache(String cache) {
        this.defaultCacheName(cache);
        return this;
    }

    public MemcachedAuthenticationConfigurationBuilder authentication() {
        return this.authentication;
    }

    public EncryptionConfigurationBuilder encryption() {
        return this.encryption;
    }

    public MemcachedServerConfigurationBuilder adminOperationsHandler(AdminOperationsHandler handler) {
        return this;
    }

    public MemcachedServerConfigurationBuilder clientEncoding(MediaType payloadType) {
        this.attributes.attribute(MemcachedServerConfiguration.CLIENT_ENCODING).set((Object)payloadType);
        return this;
    }

    public MemcachedServerConfigurationBuilder protocol(MemcachedProtocol protocol) {
        this.attributes.attribute(MemcachedServerConfiguration.PROTOCOL).set((Object)protocol);
        return this;
    }

    public MemcachedProtocol protocol() {
        return (MemcachedProtocol)((Object)this.attributes.attribute(MemcachedServerConfiguration.PROTOCOL).get());
    }

    public MemcachedServerConfiguration create() {
        return new MemcachedServerConfiguration(this.attributes.protect(), this.authentication().create(), this.ssl.create(), this.encryption.create(), this.ipFilter.create());
    }

    public void validate() {
        super.validate();
        this.authentication.validate();
        this.encryption.validate();
    }

    public MemcachedServerConfiguration build(boolean validate) {
        if (validate) {
            this.validate();
        }
        return this.create();
    }

    public MemcachedServerConfiguration build() {
        return this.build(true);
    }

    public Builder<?> read(MemcachedServerConfiguration template) {
        this.authentication.read((MemcachedAuthenticationConfiguration)template.authentication());
        this.encryption.read(template.encryption());
        return this;
    }
}

