/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached.text;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import java.nio.charset.StandardCharsets;
import javax.security.auth.Subject;
import org.infinispan.server.core.security.UsernamePasswordAuthenticator;
import org.infinispan.server.memcached.MemcachedServer;
import org.infinispan.server.memcached.configuration.MemcachedAuthenticationConfiguration;
import org.infinispan.server.memcached.configuration.MemcachedServerConfiguration;
import org.infinispan.server.memcached.text.TextConstants;
import org.infinispan.server.memcached.text.TextDecoder;
import org.infinispan.server.memcached.text.TextOpDecoderImpl;

public abstract class TextAuthDecoder
extends TextDecoder {
    private final UsernamePasswordAuthenticator authenticator;

    protected TextAuthDecoder(MemcachedServer server) {
        super(server, ANONYMOUS);
        this.authenticator = ((MemcachedAuthenticationConfiguration)((MemcachedServerConfiguration)server.getConfiguration()).authentication()).text().authenticator();
    }

    protected void auth(byte[] token) {
        String s = new String(token, StandardCharsets.US_ASCII);
        String[] parts = s.split(" ");
        if (parts.length != 2) {
            this.authFailure("Wrong credentials");
        } else {
            this.authenticator.authenticate(parts[0], parts[1].toCharArray()).handle((subject, t) -> {
                if (t != null) {
                    this.authFailure(t.getMessage());
                } else {
                    this.channel.eventLoop().submit(() -> {
                        ByteBuf buf = this.channel.alloc().ioBuffer();
                        buf.writeBytes(TextConstants.STORED);
                        this.channel.writeAndFlush((Object)buf);
                        this.channel.pipeline().replace("decoder", "decoder", (ChannelHandler)new TextOpDecoderImpl(this.server, (Subject)subject));
                    });
                }
                return null;
            });
        }
    }

    private void authFailure(String message) {
        this.channel.eventLoop().submit(() -> {
            ByteBuf buf = this.channel.alloc().ioBuffer();
            buf.writeCharSequence((CharSequence)("CLIENT_ERROR authentication failed: " + message), StandardCharsets.US_ASCII);
            this.channel.writeAndFlush((Object)buf);
        });
    }
}

