/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached.text;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.CompletionStage;
import javax.security.auth.Subject;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.util.ByRef;
import org.infinispan.server.core.transport.ConnectionMetadata;
import org.infinispan.server.memcached.MemcachedBaseDecoder;
import org.infinispan.server.memcached.MemcachedResponse;
import org.infinispan.server.memcached.MemcachedServer;
import org.infinispan.server.memcached.configuration.MemcachedServerConfiguration;
import org.infinispan.server.memcached.logging.Header;
import org.infinispan.server.memcached.text.TextResponse;

abstract class TextDecoder
extends MemcachedBaseDecoder {
    protected TextDecoder(MemcachedServer server, Subject subject) {
        super(server, subject, (AdvancedCache<byte[], byte[]>)server.getCache().getAdvancedCache().withMediaType(MediaType.TEXT_PLAIN, ((MemcachedServerConfiguration)server.getConfiguration()).clientEncoding()));
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) {
        super.handlerAdded(ctx);
        ConnectionMetadata metadata = ConnectionMetadata.getInstance((Channel)this.channel);
        metadata.subject(this.subject);
        metadata.protocolVersion("MCTXT");
    }

    @Override
    public void send(Header header, CompletionStage<?> response) {
        new TextResponse((ByRef<MemcachedResponse>)this.current, this.channel).queueResponse(this.accessLogging ? header : null, response);
    }

    @Override
    public void send(Header header, CompletionStage<?> response, GenericFutureListener<? extends Future<? super Void>> listener) {
        new TextResponse((ByRef<MemcachedResponse>)this.current, this.channel).queueResponse(this.accessLogging ? header : null, response, listener);
    }
}

