/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached.text;

import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import java.io.IOException;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.infinispan.commons.util.ByRef;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.server.memcached.MemcachedResponse;
import org.infinispan.server.memcached.logging.Header;
import org.infinispan.server.memcached.logging.MemcachedAccessLogging;

public class TextResponse
extends MemcachedResponse {
    public TextResponse(ByRef<MemcachedResponse> current, Channel ch) {
        super(current, ch);
    }

    @Override
    protected ChannelFuture writeThrowable(Header header, Throwable throwable) {
        Throwable cause = CompletableFutures.extractException((Throwable)throwable);
        Object error = cause instanceof IOException || cause instanceof IllegalArgumentException ? "CLIENT_ERROR bad command line format:  " + cause.getMessage() + "\r\n" : (cause instanceof UnsupportedOperationException ? "ERROR\r\n" : "SERVER_ERROR  " + cause.getMessage() + "\r\n");
        ChannelFuture future = this.ch.writeAndFlush((Object)ByteBufUtil.encodeString((ByteBufAllocator)this.ch.alloc(), (CharBuffer)CharBuffer.wrap((CharSequence)error), (Charset)StandardCharsets.US_ASCII));
        if (header != null) {
            MemcachedAccessLogging.logException(future, header, (String)error, ((String)error).length());
        }
        return future;
    }
}

