/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import java.util.Collections;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.configuration.Protocol;
import org.infinispan.client.rest.configuration.RestClientConfiguration;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.commons.test.TestResourceTracker;
import org.infinispan.commons.test.security.TestCertificates;
import org.infinispan.rest.authentication.RestAuthenticator;
import org.infinispan.rest.authentication.impl.ClientCertAuthenticator;
import org.infinispan.rest.helper.RestServerHelper;
import org.infinispan.test.AbstractInfinispanTest;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="rest.CertificateTest")
public class CertificateTest
extends AbstractInfinispanTest {
    private RestClient client;
    private RestServerHelper restServer;

    @AfterSuite
    public void afterSuite() {
        this.restServer.stop();
    }

    @AfterMethod
    public void afterMethod() throws Exception {
        if (this.restServer != null) {
            this.restServer.stop();
        }
        this.client.close();
    }

    @Test
    public void shouldAllowProperCertificate() throws Exception {
        this.restServer = RestServerHelper.defaultRestServer(new String[0]).withAuthenticator((RestAuthenticator)new ClientCertAuthenticator()).withKeyStore(TestCertificates.certificate((String)"server"), TestCertificates.KEY_PASSWORD, TestCertificates.KEYSTORE_TYPE).withTrustStore(TestCertificates.certificate((String)"trust"), TestCertificates.KEY_PASSWORD, TestCertificates.KEYSTORE_TYPE).withClientAuth().start(TestResourceTracker.getCurrentTestShortName());
        RestClientConfigurationBuilder config = new RestClientConfigurationBuilder();
        config.security().ssl().enable().trustStoreFileName(TestCertificates.certificate((String)"ca")).trustStorePassword(TestCertificates.KEY_PASSWORD).trustStoreType(TestCertificates.KEYSTORE_TYPE).keyStoreFileName(TestCertificates.certificate((String)"client")).keyStorePassword(TestCertificates.KEY_PASSWORD).keyStoreType(TestCertificates.KEYSTORE_TYPE).hostnameVerifier((hostname, session) -> true).addServer().host("localhost").port(this.restServer.getPort()).protocol(Protocol.HTTP_11);
        this.client = RestClient.forConfiguration((RestClientConfiguration)config.build());
        CompletionStage response = this.client.raw().get("/rest/v2/caches/default/test", Collections.emptyMap());
        AssertJUnit.assertEquals((int)404, (int)((RestResponse)response.toCompletableFuture().get(10L, TimeUnit.MINUTES)).status());
    }
}

