/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import io.netty.util.CharsetUtil;
import java.util.concurrent.CompletionStage;
import org.assertj.core.api.Assertions;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.configuration.Protocol;
import org.infinispan.client.rest.configuration.RestClientConfiguration;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.test.TestResourceTracker;
import org.infinispan.commons.test.security.TestCertificates;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.rest.assertion.ResponseAssertion;
import org.infinispan.rest.helper.RestServerHelper;
import org.infinispan.test.AbstractInfinispanTest;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="rest.Http2Test")
public final class Http2Test
extends AbstractInfinispanTest {
    private RestClient client;
    private RestServerHelper restServer;

    @AfterMethod(alwaysRun=true)
    public void afterMethod() {
        if (this.restServer != null) {
            this.restServer.stop();
        }
        Util.close((AutoCloseable)this.client);
    }

    @Test
    public void shouldUseHTTP1WithALPN() {
        this.secureUpgradeTest(Protocol.HTTP_11);
    }

    @Test
    public void shouldUseHTTP2WithALPN() {
        this.secureUpgradeTest(Protocol.HTTP_20);
    }

    @Test
    public void shouldUseHTTP2WithUpgrade() {
        this.clearTextUpgrade(false);
    }

    @Test
    public void shouldUseHTTP2WithPriorKnowledge() {
        this.clearTextUpgrade(true);
    }

    @Test
    public void shouldReportErrorCorrectly() {
        this.restServer = RestServerHelper.defaultRestServer(new String[0]).withKeyStore(TestCertificates.certificate((String)"server"), TestCertificates.KEY_PASSWORD, TestCertificates.KEYSTORE_TYPE).withTrustStore(TestCertificates.certificate((String)"trust"), TestCertificates.KEY_PASSWORD, TestCertificates.KEYSTORE_TYPE).start(TestResourceTracker.getCurrentTestShortName());
        RestClientConfigurationBuilder config = new RestClientConfigurationBuilder();
        config.addServer().host(this.restServer.getHost()).port(this.restServer.getPort()).protocol(Protocol.HTTP_20).priorKnowledge(true).security().ssl().enable().trustStoreFileName(TestCertificates.certificate((String)"ca")).trustStorePassword(TestCertificates.KEY_PASSWORD).trustStoreType(TestCertificates.KEYSTORE_TYPE).keyStoreFileName(TestCertificates.certificate((String)"client")).keyStorePassword(TestCertificates.KEY_PASSWORD).keyStoreType(TestCertificates.KEYSTORE_TYPE).hostnameVerifier((hostname, session) -> true);
        this.client = RestClient.forConfiguration((RestClientConfiguration)config.build());
        CompletionStage response = this.client.raw().get("/invalid");
        ResponseAssertion.assertThat(response).isNotFound();
    }

    @Test
    public void shouldUseHTTP1() {
        this.restServer = RestServerHelper.defaultRestServer(new String[0]).start(TestResourceTracker.getCurrentTestShortName());
        RestClientConfigurationBuilder builder = new RestClientConfigurationBuilder();
        builder.addServer().host(this.restServer.getHost()).port(this.restServer.getPort()).protocol(Protocol.HTTP_11);
        this.client = RestClient.forConfiguration((RestClientConfiguration)builder.build());
        CompletionStage response = this.client.container().info();
        ResponseAssertion.assertThat(response).isOk();
        RestEntity value = RestEntity.create((MediaType)MediaType.APPLICATION_OCTET_STREAM, (byte[])"test".getBytes(CharsetUtil.UTF_8));
        response = this.client.cache("defaultcache").put("test", value);
        Assertions.assertThat((int)((RestResponse)CompletionStages.join((CompletionStage)response)).status()).isEqualTo(204);
        Assertions.assertThat((int)this.restServer.getCacheManager().getCache().size()).isEqualTo(1);
    }

    private void clearTextUpgrade(boolean previousKnowledge) {
        this.restServer = RestServerHelper.defaultRestServer(new String[0]).start(TestResourceTracker.getCurrentTestShortName());
        RestClientConfigurationBuilder builder = new RestClientConfigurationBuilder();
        builder.addServer().host(this.restServer.getHost()).port(this.restServer.getPort()).priorKnowledge(previousKnowledge).protocol(Protocol.HTTP_20);
        this.client = RestClient.forConfiguration((RestClientConfiguration)builder.build());
        CompletionStage response = this.client.container().info();
        ResponseAssertion.assertThat(response).isOk();
        RestEntity value = RestEntity.create((MediaType)MediaType.APPLICATION_OCTET_STREAM, (byte[])"test".getBytes(CharsetUtil.UTF_8));
        response = this.client.cache("defaultcache").post("test", value);
        Assertions.assertThat((int)((RestResponse)CompletionStages.join((CompletionStage)response)).status()).isEqualTo(204);
        Assertions.assertThat((int)this.restServer.getCacheManager().getCache().size()).isEqualTo(1);
    }

    private void secureUpgradeTest(Protocol choice) {
        this.restServer = RestServerHelper.defaultRestServer(new String[0]).withKeyStore(TestCertificates.certificate((String)"server"), TestCertificates.KEY_PASSWORD, TestCertificates.KEYSTORE_TYPE).start(TestResourceTracker.getCurrentTestShortName());
        RestClientConfigurationBuilder builder = new RestClientConfigurationBuilder();
        builder.addServer().host(this.restServer.getHost()).port(this.restServer.getPort()).protocol(choice).security().ssl().trustStoreFileName(TestCertificates.certificate((String)"ca")).trustStorePassword(TestCertificates.KEY_PASSWORD).trustStoreType(TestCertificates.KEYSTORE_TYPE).hostnameVerifier((hostname, session) -> true);
        this.client = RestClient.forConfiguration((RestClientConfiguration)builder.build());
        RestEntity value = RestEntity.create((MediaType)MediaType.APPLICATION_OCTET_STREAM, (byte[])"test".getBytes(CharsetUtil.UTF_8));
        CompletionStage response = this.client.cache("defaultcache").post("test", value);
        ResponseAssertion.assertThat(response).isOk();
        Assertions.assertThat((int)this.restServer.getCacheManager().getCache().size()).isEqualTo(1);
    }
}

