/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.assertion;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.rest.DateUtils;
import org.infinispan.rest.RequestHeader;
import org.infinispan.rest.ResponseHeader;
import org.infinispan.rest.assertion.JsonAssertion;
import org.testng.AssertJUnit;

public class ResponseAssertion {
    private final RestResponse response;

    private ResponseAssertion(RestResponse response) {
        this.response = Objects.requireNonNull(response, "RestResponse cannot be null!");
    }

    public static ResponseAssertion assertThat(CompletionStage<RestResponse> response) {
        CompletableFuture<RestResponse> future = response.toCompletableFuture();
        boolean completed = CompletableFutures.uncheckedAwait(future, (long)30L, (TimeUnit)TimeUnit.SECONDS);
        if (!completed) {
            Assertions.fail((String)"Timeout obtaining responses");
        }
        return ResponseAssertion.assertThat(future.getNow(null));
    }

    public static ResponseAssertion assertThat(RestResponse response) {
        return new ResponseAssertion(response);
    }

    public ResponseAssertion isOk() {
        if (this.response.status() >= HttpResponseStatus.OK.code() && this.response.status() <= HttpResponseStatus.NO_CONTENT.code()) {
            return this;
        }
        Assertions.fail((String)("Unexpected error code " + this.response.status() + ": " + this.response.body()));
        return this;
    }

    public ResponseAssertion isRedirect() {
        Assertions.assertThat((int)this.response.status()).isIn(new Object[]{HttpResponseStatus.MOVED_PERMANENTLY.code(), HttpResponseStatus.FOUND.code(), HttpResponseStatus.TEMPORARY_REDIRECT.code(), HttpResponseStatus.PERMANENT_REDIRECT.code()});
        return this;
    }

    public ResponseAssertion doesntExist() {
        Assertions.assertThat((int)this.response.status()).isEqualTo(HttpResponseStatus.NOT_FOUND.code());
        return this;
    }

    public ResponseAssertion hasReturnedText(String text) {
        Assertions.assertThat((String)this.response.body()).isEqualTo(text);
        return this;
    }

    public ResponseAssertion containsInAnyOrderReturnedText(String ... text) {
        String body = this.response.body();
        Assertions.assertThat((String)body).matches(s -> {
            for (String possible : text) {
                if (s == null || s.contains(possible)) continue;
                return false;
            }
            return true;
        }, "Content: " + body + " doesn't contain all of " + Arrays.toString(text));
        return this;
    }

    public ResponseAssertion hasReturnedText(String ... textPossibilities) {
        String body = this.response.body();
        Assertions.assertThat((String)body).matches(s -> {
            for (String possible : textPossibilities) {
                if (s == null || !s.equals(possible)) continue;
                return true;
            }
            return false;
        }, "Content: " + body + " doesn't match any of " + Arrays.toString(textPossibilities));
        return this;
    }

    public ResponseAssertion containsReturnedText(String text) {
        Assertions.assertThat((String)this.response.body()).contains(new CharSequence[]{text});
        return this;
    }

    public ResponseAssertion bodyNotEmpty() {
        Assertions.assertThat((String)this.response.body()).isNotEmpty();
        return this;
    }

    public ResponseAssertion hasEtag() {
        ((ListAssert)Assertions.assertThat((List)((List)this.response.headers().get(ResponseHeader.ETAG_HEADER.getValue()))).isNotNull()).isNotEmpty();
        return this;
    }

    public ResponseAssertion hasNoContent() {
        Assertions.assertThat((String)this.response.body()).isEmpty();
        return this;
    }

    public ResponseAssertion hasNoContentType() {
        Assertions.assertThat((List)((List)this.response.headers().get(ResponseHeader.CONTENT_TYPE_HEADER.getValue()))).isNull();
        return this;
    }

    public ResponseAssertion hasNoContentEncoding() {
        Assertions.assertThat((List)((List)this.response.headers().get(RequestHeader.CONTENT_ENCODING_HEADER.getValue()))).isNull();
        return this;
    }

    public ResponseAssertion hasContentType(String contentType) {
        Assertions.assertThat((String)this.response.header(ResponseHeader.CONTENT_TYPE_HEADER.getValue()).replace(" ", "")).contains(new CharSequence[]{contentType.replace(" ", "")});
        return this;
    }

    public ResponseAssertion hasContentLength(Integer value) {
        Assertions.assertThat((String)this.response.header(ResponseHeader.CONTENT_LENGTH_HEADER.getValue())).isEqualTo(value.toString());
        return this;
    }

    public ResponseAssertion hasContentLength(Long value) {
        Assertions.assertThat((String)this.response.header(ResponseHeader.CONTENT_LENGTH_HEADER.getValue())).isEqualTo(value.toString());
        return this;
    }

    public ResponseAssertion hasContentEncoding(String encoding) {
        Assertions.assertThat((String)this.response.header(RequestHeader.CONTENT_ENCODING_HEADER.getValue())).isEqualTo(encoding);
        return this;
    }

    public ResponseAssertion hasHeaderMatching(String header, String regexp) {
        Assertions.assertThat((String)this.response.header(header)).matches((CharSequence)regexp);
        return this;
    }

    public ResponseAssertion hasHeaderWithValues(String header, String ... headers) {
        List<String> expected = Arrays.stream(headers).map(String::toLowerCase).sorted().toList();
        List<String> actual = ((List)this.response.headers().get(header)).stream().flatMap(s -> Arrays.stream(s.split(","))).map(String::toLowerCase).sorted().toList();
        AssertJUnit.assertEquals(expected, actual);
        return this;
    }

    public ResponseAssertion containsAllHeaders(String ... headers) {
        Object[] expected = (String[])Arrays.stream(headers).map(String::toLowerCase).sorted().toArray(String[]::new);
        Assertions.assertThat(this.response.headers().keySet()).contains(expected);
        return this;
    }

    public ResponseAssertion hasCacheControlHeaders(String ... directives) {
        List valueList = (List)this.response.headers().get(ResponseHeader.CACHE_CONTROL_HEADER.getValue());
        Assertions.assertThat((List)valueList).isEqualTo(Arrays.asList(directives));
        return this;
    }

    public ResponseAssertion hasExtendedHeaders() {
        ((ListAssert)Assertions.assertThat((List)((List)this.response.headers().get("Cluster-Primary-Owner"))).isNotNull()).isNotEmpty();
        ((ListAssert)Assertions.assertThat((List)((List)this.response.headers().get("Cluster-Node-Name"))).isNotNull()).isNotEmpty();
        ((ListAssert)Assertions.assertThat((List)((List)this.response.headers().get("Cluster-Server-Address"))).isNotNull()).isNotEmpty();
        return this;
    }

    public ResponseAssertion hasTransferEncoding(String encoding) {
        Assertions.assertThat((List)((List)this.response.headers().get(ResponseHeader.TRANSFER_ENCODING.getValue()))).contains((Object[])new String[]{encoding});
        return this;
    }

    public ResponseAssertion isConflicted() {
        Assertions.assertThat((int)this.response.status()).isEqualTo(HttpResponseStatus.CONFLICT.code());
        return this;
    }

    public ResponseAssertion isError() {
        Assertions.assertThat((int)this.response.status()).isEqualTo(HttpResponseStatus.INTERNAL_SERVER_ERROR.code());
        return this;
    }

    public ResponseAssertion isUnauthorized() {
        Assertions.assertThat((int)this.response.status()).isEqualTo(HttpResponseStatus.UNAUTHORIZED.code());
        ((ListAssert)Assertions.assertThat((List)((List)this.response.headers().get(ResponseHeader.WWW_AUTHENTICATE_HEADER.getValue()))).isNotNull()).isNotEmpty();
        return this;
    }

    public ResponseAssertion isForbidden() {
        Assertions.assertThat((int)this.response.status()).isEqualTo(HttpResponseStatus.FORBIDDEN.code());
        return this;
    }

    public ResponseAssertion isNotFound() {
        Assertions.assertThat((int)this.response.status()).isEqualTo(HttpResponseStatus.NOT_FOUND.code());
        return this;
    }

    public ResponseAssertion isPayloadTooLarge() {
        Assertions.assertThat((int)this.response.status()).isEqualTo(HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE.code());
        return this;
    }

    public ResponseAssertion isNotModified() {
        Assertions.assertThat((int)this.response.status()).isEqualTo(HttpResponseStatus.NOT_MODIFIED.code());
        return this;
    }

    public ResponseAssertion hasContentEqualToFile(String fileName) {
        try {
            Path path = Paths.get(this.getClass().getClassLoader().getResource(fileName).toURI());
            String loadedFile = Files.readString(path);
            Assertions.assertThat((String)this.response.body()).isEqualTo(loadedFile);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        return this;
    }

    public ResponseAssertion isNotAcceptable() {
        Assertions.assertThat((int)this.response.status()).isEqualTo(HttpResponseStatus.NOT_ACCEPTABLE.code());
        return this;
    }

    public ResponseAssertion isBadRequest() {
        Assertions.assertThat((int)this.response.status()).isEqualTo(HttpResponseStatus.BAD_REQUEST.code());
        return this;
    }

    public ResponseAssertion hasNoCharset() {
        Assertions.assertThat((List)((List)this.response.headers().get(ResponseHeader.CONTENT_TYPE_HEADER.getValue()))).doesNotContain((Object[])new String[]{"charset"});
        return this;
    }

    public ResponseAssertion hasReturnedBytes(byte[] bytes) {
        Assertions.assertThat((byte[])this.response.bodyAsByteArray()).isEqualTo((Object)bytes);
        return this;
    }

    public ResponseAssertion isServiceUnavailable() {
        Assertions.assertThat((int)this.response.status()).isEqualTo(HttpResponseStatus.SERVICE_UNAVAILABLE.code());
        return this;
    }

    public ResponseAssertion hasMediaType(MediaType[] mediaType) {
        String contentType = this.response.header(ResponseHeader.CONTENT_TYPE_HEADER.getValue());
        boolean hasMatches = Arrays.stream(mediaType).anyMatch(m -> MediaType.fromString((String)contentType).match(m));
        Assertions.assertThat((boolean)hasMatches).isTrue();
        return this;
    }

    public ResponseAssertion hasValidDate() {
        String dateHeader = this.response.header(ResponseHeader.DATE_HEADER.getValue());
        ZonedDateTime zonedDateTime = DateUtils.parseRFC1123((String)dateHeader);
        Assertions.assertThat((ZonedDateTime)zonedDateTime).isNotNull();
        return this;
    }

    public ResponseAssertion hasLastModified(long timestamp) {
        String dateHeader = this.response.header(ResponseHeader.LAST_MODIFIED_HEADER.getValue());
        Assertions.assertThat((String)dateHeader).isNotNull();
        ZonedDateTime zonedDateTime = Instant.ofEpochMilli(timestamp).atZone(ZoneId.systemDefault());
        String value = DateTimeFormatter.RFC_1123_DATE_TIME.format(zonedDateTime);
        Assertions.assertThat((String)value).isEqualTo(dateHeader);
        return this;
    }

    public ResponseAssertion expiresAfter(int expireDuration) {
        String dateHeader = this.response.header(ResponseHeader.DATE_HEADER.getValue());
        String expiresHeader = this.response.header(ResponseHeader.EXPIRES_HEADER.getValue());
        ZonedDateTime date = DateUtils.parseRFC1123((String)dateHeader);
        ZonedDateTime expires = DateUtils.parseRFC1123((String)expiresHeader);
        ZonedDateTime diff = expires.minus(expireDuration, ChronoUnit.SECONDS);
        Assertions.assertThat((ZonedDateTime)diff).isEqualTo((Object)date);
        return this;
    }

    public ResponseAssertion hasNoErrors() {
        this.hasJson().hasProperty("error").isNull();
        return this;
    }

    public JsonAssertion hasJson() {
        Json node = Json.read((String)this.response.body());
        return new JsonAssertion(node);
    }
}

